// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.model



public class ChangeMessageVisibilityRequest private constructor(builder: Builder) {
    /**
     * The URL of the Amazon SQS queue whose message's visibility is changed.
     *
     * Queue URLs and names are case-sensitive.
     */
    public val queueUrl: kotlin.String? = builder.queueUrl
    /**
     * The receipt handle associated with the message, whose visibility timeout is changed. This parameter is returned by the ` <a>ReceiveMessage</a> ` action.
     */
    public val receiptHandle: kotlin.String? = builder.receiptHandle
    /**
     * The new value for the message's visibility timeout (in seconds). Values range: `0` to `43200`. Maximum: 12 hours.
     */
    public val visibilityTimeout: kotlin.Int? = builder.visibilityTimeout

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChangeMessageVisibilityRequest(")
        append("queueUrl=$queueUrl,")
        append("receiptHandle=$receiptHandle,")
        append("visibilityTimeout=$visibilityTimeout")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = queueUrl?.hashCode() ?: 0
        result = 31 * result + (receiptHandle?.hashCode() ?: 0)
        result = 31 * result + (visibilityTimeout ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChangeMessageVisibilityRequest

        if (queueUrl != other.queueUrl) return false
        if (receiptHandle != other.receiptHandle) return false
        if (visibilityTimeout != other.visibilityTimeout) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The URL of the Amazon SQS queue whose message's visibility is changed.
         *
         * Queue URLs and names are case-sensitive.
         */
        public var queueUrl: kotlin.String? = null
        /**
         * The receipt handle associated with the message, whose visibility timeout is changed. This parameter is returned by the ` <a>ReceiveMessage</a> ` action.
         */
        public var receiptHandle: kotlin.String? = null
        /**
         * The new value for the message's visibility timeout (in seconds). Values range: `0` to `43200`. Maximum: 12 hours.
         */
        public var visibilityTimeout: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityRequest) : this() {
            this.queueUrl = x.queueUrl
            this.receiptHandle = x.receiptHandle
            this.visibilityTimeout = x.visibilityTimeout
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityRequest = ChangeMessageVisibilityRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
