// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.serde

import aws.sdk.kotlin.services.sqs.model.BatchResultErrorEntry
import aws.sdk.kotlin.services.sqs.model.DeleteMessageBatchResponse
import aws.sdk.kotlin.services.sqs.model.DeleteMessageBatchResultEntry
import aws.sdk.kotlin.services.sqs.model.SqsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.Flattened
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class DeleteMessageBatchOperationDeserializer: HttpDeserialize<DeleteMessageBatchResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteMessageBatchResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteMessageBatchError(context, call)
        }
        val builder = DeleteMessageBatchResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteMessageBatchOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteMessageBatchError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw SqsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AWS.SimpleQueueService.BatchEntryIdsNotDistinct" -> BatchEntryIdsNotDistinctDeserializer().deserialize(context, wrappedCall)
        "AWS.SimpleQueueService.EmptyBatchRequest" -> EmptyBatchRequestDeserializer().deserialize(context, wrappedCall)
        "AWS.SimpleQueueService.InvalidBatchEntryId" -> InvalidBatchEntryIdDeserializer().deserialize(context, wrappedCall)
        "AWS.SimpleQueueService.TooManyEntriesInBatchRequest" -> TooManyEntriesInBatchRequestDeserializer().deserialize(context, wrappedCall)
        else -> SqsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteMessageBatchOperationBody(builder: DeleteMessageBatchResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DeleteMessageBatchResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DeleteMessageBatchResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DeleteMessageBatch response")
    }
    // end unwrap response wrapper

    val FAILED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("BatchResultErrorEntry"), Flattened)
    val SUCCESSFUL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("DeleteMessageBatchResultEntry"), Flattened)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://queue.amazonaws.com/doc/2012-11-05/"))
        trait(XmlSerialName("DeleteMessageBatchResult"))
        field(FAILED_DESCRIPTOR)
        field(SUCCESSFUL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILED_DESCRIPTOR.index -> builder.failed =
                    deserializer.deserializeList(FAILED_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchResultErrorEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchResultErrorEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUCCESSFUL_DESCRIPTOR.index -> builder.successful =
                    deserializer.deserializeList(SUCCESSFUL_DESCRIPTOR) {
                        val col0 = mutableListOf<DeleteMessageBatchResultEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeleteMessageBatchResultEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
