// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.model



/**
 * Encloses a receipt handle and an entry ID for each message in ` <a>ChangeMessageVisibilityBatch</a>.`
 */
public class ChangeMessageVisibilityBatchRequestEntry private constructor(builder: Builder) {
    /**
     * An identifier for this particular receipt handle used to communicate the result.
     *
     * The `Id`s of a batch request need to be unique within a request.
     *
     * This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * A receipt handle.
     */
    public val receiptHandle: kotlin.String = requireNotNull(builder.receiptHandle) { "A non-null value must be provided for receiptHandle" }
    /**
     * The new value (in seconds) for the message's visibility timeout.
     */
    public val visibilityTimeout: kotlin.Int = builder.visibilityTimeout

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ChangeMessageVisibilityBatchRequestEntry(")
        append("id=$id,")
        append("receiptHandle=$receiptHandle,")
        append("visibilityTimeout=$visibilityTimeout")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id.hashCode()
        result = 31 * result + (receiptHandle.hashCode())
        result = 31 * result + (visibilityTimeout)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ChangeMessageVisibilityBatchRequestEntry

        if (id != other.id) return false
        if (receiptHandle != other.receiptHandle) return false
        if (visibilityTimeout != other.visibilityTimeout) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An identifier for this particular receipt handle used to communicate the result.
         *
         * The `Id`s of a batch request need to be unique within a request.
         *
         * This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).
         */
        public var id: kotlin.String? = null
        /**
         * A receipt handle.
         */
        public var receiptHandle: kotlin.String? = null
        /**
         * The new value (in seconds) for the message's visibility timeout.
         */
        public var visibilityTimeout: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry) : this() {
            this.id = x.id
            this.receiptHandle = x.receiptHandle
            this.visibilityTimeout = x.visibilityTimeout
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry = ChangeMessageVisibilityBatchRequestEntry(this)

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (receiptHandle == null) receiptHandle = ""
            return this
        }
    }
}
