// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.socialmessaging.paginators

import aws.sdk.kotlin.services.socialmessaging.SocialMessagingClient
import aws.sdk.kotlin.services.socialmessaging.model.LinkedWhatsAppBusinessAccountSummary
import aws.sdk.kotlin.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest
import aws.sdk.kotlin.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListLinkedWhatsAppBusinessAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLinkedWhatsAppBusinessAccountsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLinkedWhatsAppBusinessAccountsResponse]
 */
public fun SocialMessagingClient.listLinkedWhatsAppBusinessAccountsPaginated(initialRequest: ListLinkedWhatsAppBusinessAccountsRequest = ListLinkedWhatsAppBusinessAccountsRequest { }): Flow<ListLinkedWhatsAppBusinessAccountsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLinkedWhatsAppBusinessAccountsPaginated.listLinkedWhatsAppBusinessAccounts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLinkedWhatsAppBusinessAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLinkedWhatsAppBusinessAccountsResponse]
 */
public fun SocialMessagingClient.listLinkedWhatsAppBusinessAccountsPaginated(block: ListLinkedWhatsAppBusinessAccountsRequest.Builder.() -> Unit): Flow<ListLinkedWhatsAppBusinessAccountsResponse> =
    listLinkedWhatsAppBusinessAccountsPaginated(ListLinkedWhatsAppBusinessAccountsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLinkedWhatsAppBusinessAccountsPaginated]
 * to access the nested member [LinkedWhatsAppBusinessAccountSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LinkedWhatsAppBusinessAccountSummary]
 */
@JvmName("listLinkedWhatsAppBusinessAccountsResponseLinkedWhatsAppBusinessAccountSummary")
public fun Flow<ListLinkedWhatsAppBusinessAccountsResponse>.linkedAccounts(): Flow<LinkedWhatsAppBusinessAccountSummary> =
    transform() { response ->
        response.linkedAccounts?.forEach {
            emit(it)
        }
    }
