// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.socialmessaging.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The details of linking a WhatsApp Business Account to your Amazon Web Services account.
 */
public class WhatsAppSetupFinalization private constructor(builder: Builder) {
    /**
     * An Amazon Web Services access token generated by `WhatsAppSignupCallback` and used by `WhatsAppSetupFinalization`.
     */
    public val associateInProgressToken: kotlin.String = requireNotNull(builder.associateInProgressToken) { "A non-null value must be provided for associateInProgressToken" }
    /**
     * Used to add a new phone number to an existing WhatsApp Business Account. This field can't be used when the `waba` field is present.
     */
    public val phoneNumberParent: kotlin.String? = builder.phoneNumberParent
    /**
     * An array of WabaPhoneNumberSetupFinalization objects containing the details of each phone number associated with the WhatsApp Business Account.
     */
    public val phoneNumbers: List<WabaPhoneNumberSetupFinalization> = requireNotNull(builder.phoneNumbers) { "A non-null value must be provided for phoneNumbers" }
    /**
     * Used to create a new WhatsApp Business Account and add a phone number. This field can't be used when the `phoneNumberParent` field is present.
     */
    public val waba: aws.sdk.kotlin.services.socialmessaging.model.WabaSetupFinalization? = builder.waba

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.socialmessaging.model.WhatsAppSetupFinalization = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WhatsAppSetupFinalization(")
        append("associateInProgressToken=*** Sensitive Data Redacted ***,")
        append("phoneNumberParent=$phoneNumberParent,")
        append("phoneNumbers=$phoneNumbers,")
        append("waba=$waba")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = associateInProgressToken.hashCode()
        result = 31 * result + (phoneNumberParent?.hashCode() ?: 0)
        result = 31 * result + (phoneNumbers.hashCode())
        result = 31 * result + (waba?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WhatsAppSetupFinalization

        if (associateInProgressToken != other.associateInProgressToken) return false
        if (phoneNumberParent != other.phoneNumberParent) return false
        if (phoneNumbers != other.phoneNumbers) return false
        if (waba != other.waba) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.socialmessaging.model.WhatsAppSetupFinalization = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An Amazon Web Services access token generated by `WhatsAppSignupCallback` and used by `WhatsAppSetupFinalization`.
         */
        public var associateInProgressToken: kotlin.String? = null
        /**
         * Used to add a new phone number to an existing WhatsApp Business Account. This field can't be used when the `waba` field is present.
         */
        public var phoneNumberParent: kotlin.String? = null
        /**
         * An array of WabaPhoneNumberSetupFinalization objects containing the details of each phone number associated with the WhatsApp Business Account.
         */
        public var phoneNumbers: List<WabaPhoneNumberSetupFinalization>? = null
        /**
         * Used to create a new WhatsApp Business Account and add a phone number. This field can't be used when the `phoneNumberParent` field is present.
         */
        public var waba: aws.sdk.kotlin.services.socialmessaging.model.WabaSetupFinalization? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.socialmessaging.model.WhatsAppSetupFinalization) : this() {
            this.associateInProgressToken = x.associateInProgressToken
            this.phoneNumberParent = x.phoneNumberParent
            this.phoneNumbers = x.phoneNumbers
            this.waba = x.waba
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.socialmessaging.model.WhatsAppSetupFinalization = WhatsAppSetupFinalization(this)

        /**
         * construct an [aws.sdk.kotlin.services.socialmessaging.model.WabaSetupFinalization] inside the given [block]
         */
        public fun waba(block: aws.sdk.kotlin.services.socialmessaging.model.WabaSetupFinalization.Builder.() -> kotlin.Unit) {
            this.waba = aws.sdk.kotlin.services.socialmessaging.model.WabaSetupFinalization.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (associateInProgressToken == null) associateInProgressToken = ""
            if (phoneNumbers == null) phoneNumbers = emptyList()
            return this
        }
    }
}
