// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.socialmessaging.model

import aws.smithy.kotlin.runtime.SdkDsl

public class SendWhatsAppMessageRequest private constructor(builder: Builder) {
    /**
     * The message to send through WhatsApp. The length is in KB. The message field passes through a WhatsApp Message object, see [Messages](https://developers.facebook.com/docs/whatsapp/cloud-api/reference/messages) in the *WhatsApp Business Platform Cloud API Reference*.
     */
    public val message: kotlin.ByteArray? = builder.message
    /**
     * The API version for the request formatted as `v{VersionNumber}`. For a list of supported API versions and Amazon Web Services Regions, see *Amazon Web Services End User Messaging Social API*[ Service Endpoints](https://docs.aws.amazon.com/general/latest/gr/end-user-messaging.html) in the *Amazon Web Services General Reference*.
     */
    public val metaApiVersion: kotlin.String? = builder.metaApiVersion
    /**
     * The ID of the phone number used to send the WhatsApp message. If you are sending a media file only the `originationPhoneNumberId` used to upload the file can be used. Phone number identifiers are formatted as `phone-number-id-01234567890123456789012345678901`. Use [GetLinkedWhatsAppBusinessAccount](https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html) to find a phone number's id.
     */
    public val originationPhoneNumberId: kotlin.String? = builder.originationPhoneNumberId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.socialmessaging.model.SendWhatsAppMessageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendWhatsAppMessageRequest(")
        append("message=*** Sensitive Data Redacted ***,")
        append("metaApiVersion=$metaApiVersion,")
        append("originationPhoneNumberId=$originationPhoneNumberId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.contentHashCode() ?: 0
        result = 31 * result + (metaApiVersion?.hashCode() ?: 0)
        result = 31 * result + (originationPhoneNumberId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendWhatsAppMessageRequest

        if (message != null) {
            if (other.message == null) return false
            if (!message.contentEquals(other.message)) return false
        } else if (other.message != null) return false
        if (metaApiVersion != other.metaApiVersion) return false
        if (originationPhoneNumberId != other.originationPhoneNumberId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.socialmessaging.model.SendWhatsAppMessageRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The message to send through WhatsApp. The length is in KB. The message field passes through a WhatsApp Message object, see [Messages](https://developers.facebook.com/docs/whatsapp/cloud-api/reference/messages) in the *WhatsApp Business Platform Cloud API Reference*.
         */
        public var message: kotlin.ByteArray? = null
        /**
         * The API version for the request formatted as `v{VersionNumber}`. For a list of supported API versions and Amazon Web Services Regions, see *Amazon Web Services End User Messaging Social API*[ Service Endpoints](https://docs.aws.amazon.com/general/latest/gr/end-user-messaging.html) in the *Amazon Web Services General Reference*.
         */
        public var metaApiVersion: kotlin.String? = null
        /**
         * The ID of the phone number used to send the WhatsApp message. If you are sending a media file only the `originationPhoneNumberId` used to upload the file can be used. Phone number identifiers are formatted as `phone-number-id-01234567890123456789012345678901`. Use [GetLinkedWhatsAppBusinessAccount](https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html) to find a phone number's id.
         */
        public var originationPhoneNumberId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.socialmessaging.model.SendWhatsAppMessageRequest) : this() {
            this.message = x.message
            this.metaApiVersion = x.metaApiVersion
            this.originationPhoneNumberId = x.originationPhoneNumberId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.socialmessaging.model.SendWhatsAppMessageRequest = SendWhatsAppMessageRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
