// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.socialmessaging.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * You can use presigned URLs to grant time-limited access to objects in Amazon S3 without updating your bucket policy. For more information, see [Working with presigned URLs](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-presigned-url.html) in the *Amazon S3 User Guide*.
 */
public class S3PresignedUrl private constructor(builder: Builder) {
    /**
     * A map of headers and their values. You must specify the `Content-Type` header when using `PostWhatsAppMessageMedia`. For a list of common headers, see [Common Request Headers](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonRequestHeaders.html) in the *Amazon S3 API Reference*
     */
    public val headers: Map<String, String> = requireNotNull(builder.headers) { "A non-null value must be provided for headers" }
    /**
     * The presign url to the object.
     */
    public val url: kotlin.String = requireNotNull(builder.url) { "A non-null value must be provided for url" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.socialmessaging.model.S3PresignedUrl = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3PresignedUrl(")
        append("*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = headers.hashCode()
        result = 31 * result + (url.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3PresignedUrl

        if (headers != other.headers) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.socialmessaging.model.S3PresignedUrl = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A map of headers and their values. You must specify the `Content-Type` header when using `PostWhatsAppMessageMedia`. For a list of common headers, see [Common Request Headers](https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonRequestHeaders.html) in the *Amazon S3 API Reference*
         */
        public var headers: Map<String, String>? = null
        /**
         * The presign url to the object.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.socialmessaging.model.S3PresignedUrl) : this() {
            this.headers = x.headers
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.socialmessaging.model.S3PresignedUrl = S3PresignedUrl(this)

        internal fun correctErrors(): Builder {
            if (headers == null) headers = emptyMap()
            if (url == null) url = ""
            return this
        }
    }
}
