// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.socialmessaging.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The details of your linked WhatsApp Business Account.
 */
public class LinkedWhatsAppBusinessAccount private constructor(builder: Builder) {
    /**
     * The ARN of the linked WhatsApp Business Account.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The event destinations for the linked WhatsApp Business Account.
     */
    public val eventDestinations: List<WhatsAppBusinessAccountEventDestination> = requireNotNull(builder.eventDestinations) { "A non-null value must be provided for eventDestinations" }
    /**
     * The ID of the linked WhatsApp Business Account, formatted as `waba-01234567890123456789012345678901`.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The date the WhatsApp Business Account was linked.
     */
    public val linkDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.linkDate) { "A non-null value must be provided for linkDate" }
    /**
     * The phone numbers associated with the Linked WhatsApp Business Account.
     */
    public val phoneNumbers: List<WhatsAppPhoneNumberSummary> = requireNotNull(builder.phoneNumbers) { "A non-null value must be provided for phoneNumbers" }
    /**
     * The registration status of the linked WhatsApp Business Account.
     */
    public val registrationStatus: aws.sdk.kotlin.services.socialmessaging.model.RegistrationStatus = requireNotNull(builder.registrationStatus) { "A non-null value must be provided for registrationStatus" }
    /**
     * The WhatsApp Business Account ID from meta.
     */
    public val wabaId: kotlin.String = requireNotNull(builder.wabaId) { "A non-null value must be provided for wabaId" }
    /**
     * The name of the linked WhatsApp Business Account.
     */
    public val wabaName: kotlin.String = requireNotNull(builder.wabaName) { "A non-null value must be provided for wabaName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.socialmessaging.model.LinkedWhatsAppBusinessAccount = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LinkedWhatsAppBusinessAccount(")
        append("arn=$arn,")
        append("eventDestinations=$eventDestinations,")
        append("id=$id,")
        append("linkDate=$linkDate,")
        append("phoneNumbers=$phoneNumbers,")
        append("registrationStatus=$registrationStatus,")
        append("wabaId=$wabaId,")
        append("wabaName=$wabaName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (eventDestinations.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (linkDate.hashCode())
        result = 31 * result + (phoneNumbers.hashCode())
        result = 31 * result + (registrationStatus.hashCode())
        result = 31 * result + (wabaId.hashCode())
        result = 31 * result + (wabaName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LinkedWhatsAppBusinessAccount

        if (arn != other.arn) return false
        if (eventDestinations != other.eventDestinations) return false
        if (id != other.id) return false
        if (linkDate != other.linkDate) return false
        if (phoneNumbers != other.phoneNumbers) return false
        if (registrationStatus != other.registrationStatus) return false
        if (wabaId != other.wabaId) return false
        if (wabaName != other.wabaName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.socialmessaging.model.LinkedWhatsAppBusinessAccount = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the linked WhatsApp Business Account.
         */
        public var arn: kotlin.String? = null
        /**
         * The event destinations for the linked WhatsApp Business Account.
         */
        public var eventDestinations: List<WhatsAppBusinessAccountEventDestination>? = null
        /**
         * The ID of the linked WhatsApp Business Account, formatted as `waba-01234567890123456789012345678901`.
         */
        public var id: kotlin.String? = null
        /**
         * The date the WhatsApp Business Account was linked.
         */
        public var linkDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The phone numbers associated with the Linked WhatsApp Business Account.
         */
        public var phoneNumbers: List<WhatsAppPhoneNumberSummary>? = null
        /**
         * The registration status of the linked WhatsApp Business Account.
         */
        public var registrationStatus: aws.sdk.kotlin.services.socialmessaging.model.RegistrationStatus? = null
        /**
         * The WhatsApp Business Account ID from meta.
         */
        public var wabaId: kotlin.String? = null
        /**
         * The name of the linked WhatsApp Business Account.
         */
        public var wabaName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.socialmessaging.model.LinkedWhatsAppBusinessAccount) : this() {
            this.arn = x.arn
            this.eventDestinations = x.eventDestinations
            this.id = x.id
            this.linkDate = x.linkDate
            this.phoneNumbers = x.phoneNumbers
            this.registrationStatus = x.registrationStatus
            this.wabaId = x.wabaId
            this.wabaName = x.wabaName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.socialmessaging.model.LinkedWhatsAppBusinessAccount = LinkedWhatsAppBusinessAccount(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (eventDestinations == null) eventDestinations = emptyList()
            if (id == null) id = ""
            if (linkDate == null) linkDate = Instant.fromEpochSeconds(0)
            if (phoneNumbers == null) phoneNumbers = emptyList()
            if (registrationStatus == null) registrationStatus = RegistrationStatus.SdkUnknown("no value provided")
            if (wabaId == null) wabaId = ""
            if (wabaName == null) wabaName = ""
            return this
        }
    }
}
