// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.socialmessaging

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.socialmessaging.auth.DefaultSocialMessagingAuthSchemeProvider
import aws.sdk.kotlin.services.socialmessaging.auth.SocialMessagingAuthSchemeProvider
import aws.sdk.kotlin.services.socialmessaging.endpoints.DefaultSocialMessagingEndpointProvider
import aws.sdk.kotlin.services.socialmessaging.endpoints.SocialMessagingEndpointParameters
import aws.sdk.kotlin.services.socialmessaging.endpoints.SocialMessagingEndpointProvider
import aws.sdk.kotlin.services.socialmessaging.model.AssociateWhatsAppBusinessAccountRequest
import aws.sdk.kotlin.services.socialmessaging.model.AssociateWhatsAppBusinessAccountResponse
import aws.sdk.kotlin.services.socialmessaging.model.DeleteWhatsAppMessageMediaRequest
import aws.sdk.kotlin.services.socialmessaging.model.DeleteWhatsAppMessageMediaResponse
import aws.sdk.kotlin.services.socialmessaging.model.DisassociateWhatsAppBusinessAccountRequest
import aws.sdk.kotlin.services.socialmessaging.model.DisassociateWhatsAppBusinessAccountResponse
import aws.sdk.kotlin.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountPhoneNumberRequest
import aws.sdk.kotlin.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountPhoneNumberResponse
import aws.sdk.kotlin.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountRequest
import aws.sdk.kotlin.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountResponse
import aws.sdk.kotlin.services.socialmessaging.model.GetWhatsAppMessageMediaRequest
import aws.sdk.kotlin.services.socialmessaging.model.GetWhatsAppMessageMediaResponse
import aws.sdk.kotlin.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest
import aws.sdk.kotlin.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsResponse
import aws.sdk.kotlin.services.socialmessaging.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.socialmessaging.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.socialmessaging.model.PostWhatsAppMessageMediaRequest
import aws.sdk.kotlin.services.socialmessaging.model.PostWhatsAppMessageMediaResponse
import aws.sdk.kotlin.services.socialmessaging.model.PutWhatsAppBusinessAccountEventDestinationsRequest
import aws.sdk.kotlin.services.socialmessaging.model.PutWhatsAppBusinessAccountEventDestinationsResponse
import aws.sdk.kotlin.services.socialmessaging.model.SendWhatsAppMessageRequest
import aws.sdk.kotlin.services.socialmessaging.model.SendWhatsAppMessageResponse
import aws.sdk.kotlin.services.socialmessaging.model.TagResourceRequest
import aws.sdk.kotlin.services.socialmessaging.model.TagResourceResponse
import aws.sdk.kotlin.services.socialmessaging.model.UntagResourceRequest
import aws.sdk.kotlin.services.socialmessaging.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "SocialMessaging"
public const val SdkVersion: String = "1.4.21"
public const val ServiceApiVersion: String = "2024-01-01"

/**
 * *Amazon Web Services End User Messaging Social*, also referred to as Social messaging, is a messaging service that enables application developers to incorporate WhatsApp into their existing workflows. The *Amazon Web Services End User Messaging Social API* provides information about the *Amazon Web Services End User Messaging Social API* resources, including supported HTTP methods, parameters, and schemas.
 *
 * The *Amazon Web Services End User Messaging Social API* provides programmatic access to options that are unique to the WhatsApp Business Platform.
 *
 * If you're new to the *Amazon Web Services End User Messaging Social API*, it's also helpful to review [What is Amazon Web Services End User Messaging Social](https://docs.aws.amazon.com/sms-voice/latest/userguide/what-is-service.html) in the *Amazon Web Services End User Messaging Social User Guide*. The *Amazon Web Services End User Messaging Social User Guide* provides tutorials, code samples, and procedures that demonstrate how to use *Amazon Web Services End User Messaging Social API* features programmatically and how to integrate functionality into applications. The guide also provides key information, such as integration with other Amazon Web Services services, and the quotas that apply to use of the service.
 *
 * **Regional availability**
 *
 * The *Amazon Web Services End User Messaging Social API* is available across several Amazon Web Services Regions and it provides a dedicated endpoint for each of these Regions. For a list of all the Regions and endpoints where the API is currently available, see [Amazon Web Services Service Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#pinpoint_region) and [Amazon Web Services End User Messaging endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/end-user-messaging.html) in the Amazon Web Services General Reference. To learn more about Amazon Web Services Regions, see [Managing Amazon Web Services Regions](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html) in the Amazon Web Services General Reference.
 *
 * In each Region, Amazon Web Services maintains multiple Availability Zones. These Availability Zones are physically isolated from each other, but are united by private, low-latency, high-throughput, and highly redundant network connections. These Availability Zones enable us to provide very high levels of availability and redundancy, while also minimizing latency. To learn more about the number of Availability Zones that are available in each Region, see [Amazon Web Services Global Infrastructure.](https://aws.amazon.com/about-aws/global-infrastructure/)
 */
public interface SocialMessagingClient : SdkClient {
    /**
     * SocialMessagingClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SocialMessagingClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "SocialMessaging",
                "SOCIALMESSAGING",
                "socialmessaging",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SocialMessagingClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SocialMessagingClient = DefaultSocialMessagingClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SocialMessagingEndpointProvider = builder.endpointProvider ?: DefaultSocialMessagingEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SocialMessagingAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSocialMessagingAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SocialMessaging"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SocialMessagingEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SocialMessagingAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * This is only used through the Amazon Web Services console during sign-up to associate your WhatsApp Business Account to your Amazon Web Services account.
     */
    public suspend fun associateWhatsAppBusinessAccount(input: AssociateWhatsAppBusinessAccountRequest = AssociateWhatsAppBusinessAccountRequest { }): AssociateWhatsAppBusinessAccountResponse

    /**
     * Delete a media object from the WhatsApp service. If the object is still in an Amazon S3 bucket you should delete it from there too.
     */
    public suspend fun deleteWhatsAppMessageMedia(input: DeleteWhatsAppMessageMediaRequest): DeleteWhatsAppMessageMediaResponse

    /**
     * Disassociate a WhatsApp Business Account (WABA) from your Amazon Web Services account.
     */
    public suspend fun disassociateWhatsAppBusinessAccount(input: DisassociateWhatsAppBusinessAccountRequest): DisassociateWhatsAppBusinessAccountResponse

    /**
     * Get the details of your linked WhatsApp Business Account.
     */
    public suspend fun getLinkedWhatsAppBusinessAccount(input: GetLinkedWhatsAppBusinessAccountRequest): GetLinkedWhatsAppBusinessAccountResponse

    /**
     * Use your WhatsApp phone number id to get the WABA account id and phone number details.
     */
    public suspend fun getLinkedWhatsAppBusinessAccountPhoneNumber(input: GetLinkedWhatsAppBusinessAccountPhoneNumberRequest): GetLinkedWhatsAppBusinessAccountPhoneNumberResponse

    /**
     * Get a media file from the WhatsApp service. On successful completion the media file is retrieved from Meta and stored in the specified Amazon S3 bucket. Use either `destinationS3File` or `destinationS3PresignedUrl` for the destination. If both are used then an `InvalidParameterException` is returned.
     */
    public suspend fun getWhatsAppMessageMedia(input: GetWhatsAppMessageMediaRequest): GetWhatsAppMessageMediaResponse

    /**
     * List all WhatsApp Business Accounts linked to your Amazon Web Services account.
     */
    public suspend fun listLinkedWhatsAppBusinessAccounts(input: ListLinkedWhatsAppBusinessAccountsRequest = ListLinkedWhatsAppBusinessAccountsRequest { }): ListLinkedWhatsAppBusinessAccountsResponse

    /**
     * List all tags associated with a resource, such as a phone number or WABA.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Upload a media file to the WhatsApp service. Only the specified `originationPhoneNumberId` has the permissions to send the media file when using [SendWhatsAppMessage](https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_SendWhatsAppMessage.html). You must use either `sourceS3File` or `sourceS3PresignedUrl` for the source. If both or neither are specified then an `InvalidParameterException` is returned.
     */
    public suspend fun postWhatsAppMessageMedia(input: PostWhatsAppMessageMediaRequest): PostWhatsAppMessageMediaResponse

    /**
     * Add an event destination to log event data from WhatsApp for a WhatsApp Business Account (WABA). A WABA can only have one event destination at a time. All resources associated with the WABA use the same event destination.
     */
    public suspend fun putWhatsAppBusinessAccountEventDestinations(input: PutWhatsAppBusinessAccountEventDestinationsRequest): PutWhatsAppBusinessAccountEventDestinationsResponse

    /**
     * Send a WhatsApp message. For examples of sending a message using the Amazon Web Services CLI, see [Sending messages](https://docs.aws.amazon.com/social-messaging/latest/userguide/send-message.html) in the **Amazon Web Services End User Messaging Social User Guide**.
     */
    public suspend fun sendWhatsAppMessage(input: SendWhatsAppMessageRequest): SendWhatsAppMessageResponse

    /**
     * Adds or overwrites only the specified tags for the specified resource. When you specify an existing tag key, the value is overwritten with the new value.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SocialMessagingClient.withConfig(block: SocialMessagingClient.Config.Builder.() -> Unit): SocialMessagingClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSocialMessagingClient(newConfig)
}

/**
 * This is only used through the Amazon Web Services console during sign-up to associate your WhatsApp Business Account to your Amazon Web Services account.
 */
public suspend inline fun SocialMessagingClient.associateWhatsAppBusinessAccount(crossinline block: AssociateWhatsAppBusinessAccountRequest.Builder.() -> Unit): AssociateWhatsAppBusinessAccountResponse = associateWhatsAppBusinessAccount(AssociateWhatsAppBusinessAccountRequest.Builder().apply(block).build())

/**
 * Delete a media object from the WhatsApp service. If the object is still in an Amazon S3 bucket you should delete it from there too.
 */
public suspend inline fun SocialMessagingClient.deleteWhatsAppMessageMedia(crossinline block: DeleteWhatsAppMessageMediaRequest.Builder.() -> Unit): DeleteWhatsAppMessageMediaResponse = deleteWhatsAppMessageMedia(DeleteWhatsAppMessageMediaRequest.Builder().apply(block).build())

/**
 * Disassociate a WhatsApp Business Account (WABA) from your Amazon Web Services account.
 */
public suspend inline fun SocialMessagingClient.disassociateWhatsAppBusinessAccount(crossinline block: DisassociateWhatsAppBusinessAccountRequest.Builder.() -> Unit): DisassociateWhatsAppBusinessAccountResponse = disassociateWhatsAppBusinessAccount(DisassociateWhatsAppBusinessAccountRequest.Builder().apply(block).build())

/**
 * Get the details of your linked WhatsApp Business Account.
 */
public suspend inline fun SocialMessagingClient.getLinkedWhatsAppBusinessAccount(crossinline block: GetLinkedWhatsAppBusinessAccountRequest.Builder.() -> Unit): GetLinkedWhatsAppBusinessAccountResponse = getLinkedWhatsAppBusinessAccount(GetLinkedWhatsAppBusinessAccountRequest.Builder().apply(block).build())

/**
 * Use your WhatsApp phone number id to get the WABA account id and phone number details.
 */
public suspend inline fun SocialMessagingClient.getLinkedWhatsAppBusinessAccountPhoneNumber(crossinline block: GetLinkedWhatsAppBusinessAccountPhoneNumberRequest.Builder.() -> Unit): GetLinkedWhatsAppBusinessAccountPhoneNumberResponse = getLinkedWhatsAppBusinessAccountPhoneNumber(GetLinkedWhatsAppBusinessAccountPhoneNumberRequest.Builder().apply(block).build())

/**
 * Get a media file from the WhatsApp service. On successful completion the media file is retrieved from Meta and stored in the specified Amazon S3 bucket. Use either `destinationS3File` or `destinationS3PresignedUrl` for the destination. If both are used then an `InvalidParameterException` is returned.
 */
public suspend inline fun SocialMessagingClient.getWhatsAppMessageMedia(crossinline block: GetWhatsAppMessageMediaRequest.Builder.() -> Unit): GetWhatsAppMessageMediaResponse = getWhatsAppMessageMedia(GetWhatsAppMessageMediaRequest.Builder().apply(block).build())

/**
 * List all WhatsApp Business Accounts linked to your Amazon Web Services account.
 */
public suspend inline fun SocialMessagingClient.listLinkedWhatsAppBusinessAccounts(crossinline block: ListLinkedWhatsAppBusinessAccountsRequest.Builder.() -> Unit): ListLinkedWhatsAppBusinessAccountsResponse = listLinkedWhatsAppBusinessAccounts(ListLinkedWhatsAppBusinessAccountsRequest.Builder().apply(block).build())

/**
 * List all tags associated with a resource, such as a phone number or WABA.
 */
public suspend inline fun SocialMessagingClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Upload a media file to the WhatsApp service. Only the specified `originationPhoneNumberId` has the permissions to send the media file when using [SendWhatsAppMessage](https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_SendWhatsAppMessage.html). You must use either `sourceS3File` or `sourceS3PresignedUrl` for the source. If both or neither are specified then an `InvalidParameterException` is returned.
 */
public suspend inline fun SocialMessagingClient.postWhatsAppMessageMedia(crossinline block: PostWhatsAppMessageMediaRequest.Builder.() -> Unit): PostWhatsAppMessageMediaResponse = postWhatsAppMessageMedia(PostWhatsAppMessageMediaRequest.Builder().apply(block).build())

/**
 * Add an event destination to log event data from WhatsApp for a WhatsApp Business Account (WABA). A WABA can only have one event destination at a time. All resources associated with the WABA use the same event destination.
 */
public suspend inline fun SocialMessagingClient.putWhatsAppBusinessAccountEventDestinations(crossinline block: PutWhatsAppBusinessAccountEventDestinationsRequest.Builder.() -> Unit): PutWhatsAppBusinessAccountEventDestinationsResponse = putWhatsAppBusinessAccountEventDestinations(PutWhatsAppBusinessAccountEventDestinationsRequest.Builder().apply(block).build())

/**
 * Send a WhatsApp message. For examples of sending a message using the Amazon Web Services CLI, see [Sending messages](https://docs.aws.amazon.com/social-messaging/latest/userguide/send-message.html) in the **Amazon Web Services End User Messaging Social User Guide**.
 */
public suspend inline fun SocialMessagingClient.sendWhatsAppMessage(crossinline block: SendWhatsAppMessageRequest.Builder.() -> Unit): SendWhatsAppMessageResponse = sendWhatsAppMessage(SendWhatsAppMessageRequest.Builder().apply(block).build())

/**
 * Adds or overwrites only the specified tags for the specified resource. When you specify an existing tag key, the value is overwritten with the new value.
 */
public suspend inline fun SocialMessagingClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from a resource.
 */
public suspend inline fun SocialMessagingClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
