// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.serde

import aws.sdk.kotlin.services.sns.model.SnsException
import aws.sdk.kotlin.services.sns.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UntagResourceOperationDeserializer: HttpDeserializer.NonStreaming<UntagResourceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UntagResourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUntagResourceError(context, call, payload)
        }
        val builder = UntagResourceResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUntagResourceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw SnsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameter" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "StaleTag" -> StaleTagExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AuthorizationError" -> AuthorizationErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TagPolicy" -> TagPolicyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFound" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TagLimitExceeded" -> TagLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConcurrentAccess" -> ConcurrentAccessExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SnsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
