// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.serde

import aws.sdk.kotlin.services.sns.model.BatchResultErrorEntry
import aws.sdk.kotlin.services.sns.model.PublishBatchResponse
import aws.sdk.kotlin.services.sns.model.PublishBatchResultEntry
import aws.sdk.kotlin.services.sns.model.SnsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class PublishBatchOperationDeserializer: HttpDeserializer.NonStreaming<PublishBatchResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PublishBatchResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPublishBatchError(context, call, payload)
        }
        val builder = PublishBatchResponse.Builder()

        if (payload != null) {
            deserializePublishBatchOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPublishBatchError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw SnsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BatchRequestTooLong" -> BatchRequestTooLongExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSInvalidState" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSNotFound" -> KmsNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PlatformApplicationDisabled" -> PlatformApplicationDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSOptInRequired" -> KmsOptInRequiredDeserializer().deserialize(context, wrappedCall, payload)
        "ParameterValueInvalid" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidBatchEntryId" -> InvalidBatchEntryIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EndpointDisabled" -> EndpointDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSecurity" -> InvalidSecurityExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSAccessDenied" -> KmsAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFound" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameter" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyEntriesInBatchRequest" -> TooManyEntriesInBatchRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AuthorizationError" -> AuthorizationErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BatchEntryIdsNotDistinct" -> BatchEntryIdsNotDistinctExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EmptyBatchRequest" -> EmptyBatchRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSThrottling" -> KmsThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalError" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "KMSDisabled" -> KmsDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SnsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePublishBatchOperationBody(builder: PublishBatchResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "PublishBatch")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Failed com.amazonaws.sns#PublishBatchResponse$Failed
            "Failed" -> builder.failed = deserializeBatchResultErrorEntryListShape(curr)
            // Successful com.amazonaws.sns#PublishBatchResponse$Successful
            "Successful" -> builder.successful = deserializePublishBatchResultEntryListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
