// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.serde

import aws.sdk.kotlin.services.sns.model.PhoneNumberInformation
import aws.sdk.kotlin.services.sns.model.RouteType
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializePhoneNumberInformationDocument(reader: XmlTagReader): PhoneNumberInformation {
    val builder = PhoneNumberInformation.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // CreatedAt com.amazonaws.sns#PhoneNumberInformation$CreatedAt
            "CreatedAt" -> builder.createdAt = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.sns#Timestamp`)" }
            // PhoneNumber com.amazonaws.sns#PhoneNumberInformation$PhoneNumber
            "PhoneNumber" -> builder.phoneNumber = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sns#PhoneNumber`)" }
            // Status com.amazonaws.sns#PhoneNumberInformation$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sns#String`)" }
            // Iso2CountryCode com.amazonaws.sns#PhoneNumberInformation$Iso2CountryCode
            "Iso2CountryCode" -> builder.iso2CountryCode = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sns#Iso2CountryCode`)" }
            // RouteType com.amazonaws.sns#PhoneNumberInformation$RouteType
            "RouteType" -> builder.routeType = curr.tryData()
                .parse { RouteType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.sns#RouteType`)" }
            // NumberCapabilities com.amazonaws.sns#PhoneNumberInformation$NumberCapabilities
            "NumberCapabilities" -> builder.numberCapabilities = deserializeNumberCapabilityListShape(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
