// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.serde

import aws.sdk.kotlin.services.sns.model.ListSubscriptionsByTopicResponse
import aws.sdk.kotlin.services.sns.model.SnsException
import aws.sdk.kotlin.services.sns.model.Subscription
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ListSubscriptionsByTopicOperationDeserializer: HttpDeserializer.NonStreaming<ListSubscriptionsByTopicResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListSubscriptionsByTopicResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListSubscriptionsByTopicError(context, call, payload)
        }
        val builder = ListSubscriptionsByTopicResponse.Builder()

        if (payload != null) {
            deserializeListSubscriptionsByTopicOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListSubscriptionsByTopicError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw SnsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFound" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameter" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AuthorizationError" -> AuthorizationErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalError" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SnsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListSubscriptionsByTopicOperationBody(builder: ListSubscriptionsByTopicResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ListSubscriptionsByTopic")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // NextToken com.amazonaws.sns#ListSubscriptionsByTopicResponse$NextToken
            "NextToken" -> builder.nextToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sns#nextToken`)" }
            // Subscriptions com.amazonaws.sns#ListSubscriptionsByTopicResponse$Subscriptions
            "Subscriptions" -> builder.subscriptions = deserializeSubscriptionsListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
