// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.serde

import aws.sdk.kotlin.services.sns.model.ConfirmSubscriptionResponse
import aws.sdk.kotlin.services.sns.model.SnsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ConfirmSubscriptionOperationDeserializer: HttpDeserializer.NonStreaming<ConfirmSubscriptionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ConfirmSubscriptionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwConfirmSubscriptionError(context, call, payload)
        }
        val builder = ConfirmSubscriptionResponse.Builder()

        if (payload != null) {
            deserializeConfirmSubscriptionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwConfirmSubscriptionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw SnsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFound" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameter" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FilterPolicyLimitExceeded" -> FilterPolicyLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AuthorizationError" -> AuthorizationErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "SubscriptionLimitExceeded" -> SubscriptionLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ReplayLimitExceeded" -> ReplayLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalError" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SnsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeConfirmSubscriptionOperationBody(builder: ConfirmSubscriptionResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ConfirmSubscription")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // SubscriptionArn com.amazonaws.sns#ConfirmSubscriptionResponse$SubscriptionArn
            "SubscriptionArn" -> builder.subscriptionArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sns#subscriptionARN`)" }
            else -> {}
        }
        curr.drop()
    }
}
