// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Input for Subscribe action.
 */
public class SubscribeRequest private constructor(builder: Builder) {
    /**
     * A map of attributes with their corresponding values.
     *
     * The following lists the names, descriptions, and values of the special request parameters that the `Subscribe` action uses:
     * + `DeliveryPolicy` – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.
     * + `FilterPolicy` – The simple JSON object that lets your subscriber receive only a subset of messages, rather than receiving every message published to the topic.
     * + `FilterPolicyScope` – This attribute lets you choose the filtering scope by using one of the following string value types:
     *    + `MessageAttributes` (default) – The filter is applied on the message attributes.
     *    + `MessageBody` – The filter is applied on the message body.
     * + `RawMessageDelivery` – When set to `true`, enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need for the endpoints to process JSON formatting, which is otherwise created for Amazon SNS metadata.
     * + `RedrivePolicy` – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
     *
     * The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:
     * + `SubscriptionRoleArn` – The ARN of the IAM role that has the following:
     *    + Permission to write to the Kinesis Data Firehose delivery stream
     *    + Amazon SNS listed as a trusted entity
     * Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions. For more information, see [Fanout to Kinesis Data Firehose delivery streams](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html) in the *Amazon SNS Developer Guide*.
     *
     * The following attributes apply only to [FIFO topics](https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html):
     * + `ReplayPolicy` – Adds or updates an inline policy document for a subscription to replay messages stored in the specified Amazon SNS topic.
     * + `ReplayStatus` – Retrieves the status of the subscription message replay, which can be one of the following:
     *    + `Completed` – The replay has successfully redelivered all messages, and is now delivering newly published messages. If an ending point was specified in the `ReplayPolicy` then the subscription will no longer receive newly published messages.
     *    + `In progress` – The replay is currently replaying the selected messages.
     *    + `Failed` – The replay was unable to complete.
     *    + `Pending` – The default state while the replay initiates.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The endpoint that you want to receive notifications. Endpoints vary by protocol:
     * + For the `http` protocol, the (public) endpoint is a URL beginning with `http://`.
     * + For the `https` protocol, the (public) endpoint is a URL beginning with `https://`.
     * + For the `email` protocol, the endpoint is an email address.
     * + For the `email-json` protocol, the endpoint is an email address.
     * + For the `sms` protocol, the endpoint is a phone number of an SMS-enabled device.
     * + For the `sqs` protocol, the endpoint is the ARN of an Amazon SQS queue.
     * + For the `application` protocol, the endpoint is the EndpointArn of a mobile app and device.
     * + For the `lambda` protocol, the endpoint is the ARN of an Lambda function.
     * + For the `firehose` protocol, the endpoint is the ARN of an Amazon Kinesis Data Firehose delivery stream.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The protocol that you want to use. Supported protocols include:
     * + `http` – delivery of JSON-encoded message via HTTP POST
     * + `https` – delivery of JSON-encoded message via HTTPS POST
     * + `email` – delivery of message via SMTP
     * + `email-json` – delivery of JSON-encoded message via SMTP
     * + `sms` – delivery of message via SMS
     * + `sqs` – delivery of JSON-encoded message to an Amazon SQS queue
     * + `application` – delivery of JSON-encoded message to an EndpointArn for a mobile app and device
     * + `lambda` – delivery of JSON-encoded message to an Lambda function
     * + `firehose` – delivery of JSON-encoded message to an Amazon Kinesis Data Firehose delivery stream.
     */
    public val protocol: kotlin.String? = builder.protocol
    /**
     * Sets whether the response from the `Subscribe` request includes the subscription ARN, even if the subscription is not yet confirmed.
     *
     * If you set this parameter to `true`, the response includes the ARN in all cases, even if the subscription is not yet confirmed. In addition to the ARN for confirmed subscriptions, the response also includes the `pending subscription` ARN value for subscriptions that aren't yet confirmed. A subscription becomes confirmed when the subscriber calls the `ConfirmSubscription` action with a confirmation token.
     *
     * The default value is `false`.
     */
    public val returnSubscriptionArn: kotlin.Boolean? = builder.returnSubscriptionArn
    /**
     * The ARN of the topic you want to subscribe to.
     */
    public val topicArn: kotlin.String? = builder.topicArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sns.model.SubscribeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SubscribeRequest(")
        append("attributes=$attributes,")
        append("endpoint=$endpoint,")
        append("protocol=$protocol,")
        append("returnSubscriptionArn=$returnSubscriptionArn,")
        append("topicArn=$topicArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (returnSubscriptionArn?.hashCode() ?: 0)
        result = 31 * result + (topicArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SubscribeRequest

        if (attributes != other.attributes) return false
        if (endpoint != other.endpoint) return false
        if (protocol != other.protocol) return false
        if (returnSubscriptionArn != other.returnSubscriptionArn) return false
        if (topicArn != other.topicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sns.model.SubscribeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A map of attributes with their corresponding values.
         *
         * The following lists the names, descriptions, and values of the special request parameters that the `Subscribe` action uses:
         * + `DeliveryPolicy` – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.
         * + `FilterPolicy` – The simple JSON object that lets your subscriber receive only a subset of messages, rather than receiving every message published to the topic.
         * + `FilterPolicyScope` – This attribute lets you choose the filtering scope by using one of the following string value types:
         *    + `MessageAttributes` (default) – The filter is applied on the message attributes.
         *    + `MessageBody` – The filter is applied on the message body.
         * + `RawMessageDelivery` – When set to `true`, enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need for the endpoints to process JSON formatting, which is otherwise created for Amazon SNS metadata.
         * + `RedrivePolicy` – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
         *
         * The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:
         * + `SubscriptionRoleArn` – The ARN of the IAM role that has the following:
         *    + Permission to write to the Kinesis Data Firehose delivery stream
         *    + Amazon SNS listed as a trusted entity
         * Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions. For more information, see [Fanout to Kinesis Data Firehose delivery streams](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html) in the *Amazon SNS Developer Guide*.
         *
         * The following attributes apply only to [FIFO topics](https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html):
         * + `ReplayPolicy` – Adds or updates an inline policy document for a subscription to replay messages stored in the specified Amazon SNS topic.
         * + `ReplayStatus` – Retrieves the status of the subscription message replay, which can be one of the following:
         *    + `Completed` – The replay has successfully redelivered all messages, and is now delivering newly published messages. If an ending point was specified in the `ReplayPolicy` then the subscription will no longer receive newly published messages.
         *    + `In progress` – The replay is currently replaying the selected messages.
         *    + `Failed` – The replay was unable to complete.
         *    + `Pending` – The default state while the replay initiates.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The endpoint that you want to receive notifications. Endpoints vary by protocol:
         * + For the `http` protocol, the (public) endpoint is a URL beginning with `http://`.
         * + For the `https` protocol, the (public) endpoint is a URL beginning with `https://`.
         * + For the `email` protocol, the endpoint is an email address.
         * + For the `email-json` protocol, the endpoint is an email address.
         * + For the `sms` protocol, the endpoint is a phone number of an SMS-enabled device.
         * + For the `sqs` protocol, the endpoint is the ARN of an Amazon SQS queue.
         * + For the `application` protocol, the endpoint is the EndpointArn of a mobile app and device.
         * + For the `lambda` protocol, the endpoint is the ARN of an Lambda function.
         * + For the `firehose` protocol, the endpoint is the ARN of an Amazon Kinesis Data Firehose delivery stream.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The protocol that you want to use. Supported protocols include:
         * + `http` – delivery of JSON-encoded message via HTTP POST
         * + `https` – delivery of JSON-encoded message via HTTPS POST
         * + `email` – delivery of message via SMTP
         * + `email-json` – delivery of JSON-encoded message via SMTP
         * + `sms` – delivery of message via SMS
         * + `sqs` – delivery of JSON-encoded message to an Amazon SQS queue
         * + `application` – delivery of JSON-encoded message to an EndpointArn for a mobile app and device
         * + `lambda` – delivery of JSON-encoded message to an Lambda function
         * + `firehose` – delivery of JSON-encoded message to an Amazon Kinesis Data Firehose delivery stream.
         */
        public var protocol: kotlin.String? = null
        /**
         * Sets whether the response from the `Subscribe` request includes the subscription ARN, even if the subscription is not yet confirmed.
         *
         * If you set this parameter to `true`, the response includes the ARN in all cases, even if the subscription is not yet confirmed. In addition to the ARN for confirmed subscriptions, the response also includes the `pending subscription` ARN value for subscriptions that aren't yet confirmed. A subscription becomes confirmed when the subscriber calls the `ConfirmSubscription` action with a confirmation token.
         *
         * The default value is `false`.
         */
        public var returnSubscriptionArn: kotlin.Boolean? = null
        /**
         * The ARN of the topic you want to subscribe to.
         */
        public var topicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sns.model.SubscribeRequest) : this() {
            this.attributes = x.attributes
            this.endpoint = x.endpoint
            this.protocol = x.protocol
            this.returnSubscriptionArn = x.returnSubscriptionArn
            this.topicArn = x.topicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sns.model.SubscribeRequest = SubscribeRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
