// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Input for SetSubscriptionAttributes action.
 */
public class SetSubscriptionAttributesRequest private constructor(builder: Builder) {
    /**
     * A map of attributes with their corresponding values.
     *
     * The following lists the names, descriptions, and values of the special request parameters that this action uses:
     * + `DeliveryPolicy` – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.
     * + `FilterPolicy` – The simple JSON object that lets your subscriber receive only a subset of messages, rather than receiving every message published to the topic.
     * + `FilterPolicyScope` – This attribute lets you choose the filtering scope by using one of the following string value types:
     *    + `MessageAttributes` (default) – The filter is applied on the message attributes.
     *    + `MessageBody` – The filter is applied on the message body.
     * + `RawMessageDelivery` – When set to `true`, enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need for the endpoints to process JSON formatting, which is otherwise created for Amazon SNS metadata.
     * + `RedrivePolicy` – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
     *
     * The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:
     * + `SubscriptionRoleArn` – The ARN of the IAM role that has the following:
     *    + Permission to write to the Kinesis Data Firehose delivery stream
     *    + Amazon SNS listed as a trusted entity
     * Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions. For more information, see [Fanout to Kinesis Data Firehose delivery streams](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html) in the *Amazon SNS Developer Guide*.
     */
    public val attributeName: kotlin.String? = builder.attributeName
    /**
     * The new value for the attribute in JSON format.
     */
    public val attributeValue: kotlin.String? = builder.attributeValue
    /**
     * The ARN of the subscription to modify.
     */
    public val subscriptionArn: kotlin.String? = builder.subscriptionArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sns.model.SetSubscriptionAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetSubscriptionAttributesRequest(")
        append("attributeName=$attributeName,")
        append("attributeValue=$attributeValue,")
        append("subscriptionArn=$subscriptionArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName?.hashCode() ?: 0
        result = 31 * result + (attributeValue?.hashCode() ?: 0)
        result = 31 * result + (subscriptionArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetSubscriptionAttributesRequest

        if (attributeName != other.attributeName) return false
        if (attributeValue != other.attributeValue) return false
        if (subscriptionArn != other.subscriptionArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sns.model.SetSubscriptionAttributesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A map of attributes with their corresponding values.
         *
         * The following lists the names, descriptions, and values of the special request parameters that this action uses:
         * + `DeliveryPolicy` – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.
         * + `FilterPolicy` – The simple JSON object that lets your subscriber receive only a subset of messages, rather than receiving every message published to the topic.
         * + `FilterPolicyScope` – This attribute lets you choose the filtering scope by using one of the following string value types:
         *    + `MessageAttributes` (default) – The filter is applied on the message attributes.
         *    + `MessageBody` – The filter is applied on the message body.
         * + `RawMessageDelivery` – When set to `true`, enables raw message delivery to Amazon SQS or HTTP/S endpoints. This eliminates the need for the endpoints to process JSON formatting, which is otherwise created for Amazon SNS metadata.
         * + `RedrivePolicy` – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
         *
         * The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:
         * + `SubscriptionRoleArn` – The ARN of the IAM role that has the following:
         *    + Permission to write to the Kinesis Data Firehose delivery stream
         *    + Amazon SNS listed as a trusted entity
         * Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions. For more information, see [Fanout to Kinesis Data Firehose delivery streams](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html) in the *Amazon SNS Developer Guide*.
         */
        public var attributeName: kotlin.String? = null
        /**
         * The new value for the attribute in JSON format.
         */
        public var attributeValue: kotlin.String? = null
        /**
         * The ARN of the subscription to modify.
         */
        public var subscriptionArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sns.model.SetSubscriptionAttributesRequest) : this() {
            this.attributeName = x.attributeName
            this.attributeValue = x.attributeValue
            this.subscriptionArn = x.subscriptionArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sns.model.SetSubscriptionAttributesRequest = SetSubscriptionAttributesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
