// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the details of a single Amazon SNS message along with an `Id` that identifies a message within the batch.
 */
public class PublishBatchRequestEntry private constructor(builder: Builder) {
    /**
     * An identifier for the message in this batch.
     *
     * The `Ids` of a batch request must be unique within a request.
     *
     * This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The body of the message.
     */
    public val message: kotlin.String = requireNotNull(builder.message) { "A non-null value must be provided for message" }
    /**
     * Each message attribute consists of a `Name`, `Type`, and `Value`. For more information, see [Amazon SNS message attributes](https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html) in the Amazon SNS Developer Guide.
     */
    public val messageAttributes: Map<String, MessageAttributeValue>? = builder.messageAttributes
    /**
     * This parameter applies only to FIFO (first-in-first-out) topics.
     *
     * The token used for deduplication of messages within a 5-minute minimum deduplication interval. If a message with a particular `MessageDeduplicationId` is sent successfully, subsequent messages with the same `MessageDeduplicationId` are accepted successfully but aren't delivered.
     * + Every message must have a unique `MessageDeduplicationId`.
     *    + You may provide a `MessageDeduplicationId` explicitly.
     *    + If you aren't able to provide a `MessageDeduplicationId` and you enable `ContentBasedDeduplication` for your topic, Amazon SNS uses a SHA-256 hash to generate the `MessageDeduplicationId` using the body of the message (but not the attributes of the message).
     *    + If you don't provide a `MessageDeduplicationId` and the topic doesn't have `ContentBasedDeduplication` set, the action fails with an error.
     *    + If the topic has a `ContentBasedDeduplication` set, your `MessageDeduplicationId` overrides the generated one.
     * + When `ContentBasedDeduplication` is in effect, messages with identical content sent within the deduplication interval are treated as duplicates and only one copy of the message is delivered.
     * + If you send one message with `ContentBasedDeduplication` enabled, and then another message with a `MessageDeduplicationId` that is the same as the one generated for the first `MessageDeduplicationId`, the two messages are treated as duplicates and only one copy of the message is delivered.
     *
     * The `MessageDeduplicationId` is available to the consumer of the message (this can be useful for troubleshooting delivery issues).
     *
     * If a message is sent successfully but the acknowledgement is lost and the message is resent with the same `MessageDeduplicationId` after the deduplication interval, Amazon SNS can't detect duplicate messages.
     *
     * Amazon SNS continues to keep track of the message deduplication ID even after the message is received and deleted.
     *
     * The length of `MessageDeduplicationId` is 128 characters.
     *
     * `MessageDeduplicationId` can contain alphanumeric characters `(a-z, A-Z, 0-9)` and punctuation `(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)`.
     */
    public val messageDeduplicationId: kotlin.String? = builder.messageDeduplicationId
    /**
     * This parameter applies only to FIFO (first-in-first-out) topics.
     *
     * The tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). To interleave multiple ordered streams within a single topic, use `MessageGroupId` values (for example, session data for multiple users). In this scenario, multiple consumers can process the topic, but the session data of each user is processed in a FIFO fashion.
     *
     * You must associate a non-empty `MessageGroupId` with a message. If you don't provide a `MessageGroupId`, the action fails.
     *
     * The length of `MessageGroupId` is 128 characters.
     *
     * `MessageGroupId` can contain alphanumeric characters `(a-z, A-Z, 0-9)` and punctuation `(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)`.
     *
     * `MessageGroupId` is required for FIFO topics. You can't use it for standard topics.
     */
    public val messageGroupId: kotlin.String? = builder.messageGroupId
    /**
     * Set `MessageStructure` to `json` if you want to send a different message for each protocol. For example, using one publish action, you can send a short message to your SMS subscribers and a longer message to your email subscribers. If you set `MessageStructure` to `json`, the value of the `Message` parameter must:
     * + be a syntactically valid JSON object; and
     * + contain at least a top-level JSON key of "default" with a value that is a string.
     *
     * You can define other top-level keys that define the message you want to send to a specific transport protocol (e.g. http).
     */
    public val messageStructure: kotlin.String? = builder.messageStructure
    /**
     * The subject of the batch message.
     */
    public val subject: kotlin.String? = builder.subject

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sns.model.PublishBatchRequestEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PublishBatchRequestEntry(")
        append("id=$id,")
        append("message=$message,")
        append("messageAttributes=$messageAttributes,")
        append("messageDeduplicationId=$messageDeduplicationId,")
        append("messageGroupId=$messageGroupId,")
        append("messageStructure=$messageStructure,")
        append("subject=$subject")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id.hashCode()
        result = 31 * result + (message.hashCode())
        result = 31 * result + (messageAttributes?.hashCode() ?: 0)
        result = 31 * result + (messageDeduplicationId?.hashCode() ?: 0)
        result = 31 * result + (messageGroupId?.hashCode() ?: 0)
        result = 31 * result + (messageStructure?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PublishBatchRequestEntry

        if (id != other.id) return false
        if (message != other.message) return false
        if (messageAttributes != other.messageAttributes) return false
        if (messageDeduplicationId != other.messageDeduplicationId) return false
        if (messageGroupId != other.messageGroupId) return false
        if (messageStructure != other.messageStructure) return false
        if (subject != other.subject) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sns.model.PublishBatchRequestEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An identifier for the message in this batch.
         *
         * The `Ids` of a batch request must be unique within a request.
         *
         * This identifier can have up to 80 characters. The following characters are accepted: alphanumeric characters, hyphens(-), and underscores (_).
         */
        public var id: kotlin.String? = null
        /**
         * The body of the message.
         */
        public var message: kotlin.String? = null
        /**
         * Each message attribute consists of a `Name`, `Type`, and `Value`. For more information, see [Amazon SNS message attributes](https://docs.aws.amazon.com/sns/latest/dg/sns-message-attributes.html) in the Amazon SNS Developer Guide.
         */
        public var messageAttributes: Map<String, MessageAttributeValue>? = null
        /**
         * This parameter applies only to FIFO (first-in-first-out) topics.
         *
         * The token used for deduplication of messages within a 5-minute minimum deduplication interval. If a message with a particular `MessageDeduplicationId` is sent successfully, subsequent messages with the same `MessageDeduplicationId` are accepted successfully but aren't delivered.
         * + Every message must have a unique `MessageDeduplicationId`.
         *    + You may provide a `MessageDeduplicationId` explicitly.
         *    + If you aren't able to provide a `MessageDeduplicationId` and you enable `ContentBasedDeduplication` for your topic, Amazon SNS uses a SHA-256 hash to generate the `MessageDeduplicationId` using the body of the message (but not the attributes of the message).
         *    + If you don't provide a `MessageDeduplicationId` and the topic doesn't have `ContentBasedDeduplication` set, the action fails with an error.
         *    + If the topic has a `ContentBasedDeduplication` set, your `MessageDeduplicationId` overrides the generated one.
         * + When `ContentBasedDeduplication` is in effect, messages with identical content sent within the deduplication interval are treated as duplicates and only one copy of the message is delivered.
         * + If you send one message with `ContentBasedDeduplication` enabled, and then another message with a `MessageDeduplicationId` that is the same as the one generated for the first `MessageDeduplicationId`, the two messages are treated as duplicates and only one copy of the message is delivered.
         *
         * The `MessageDeduplicationId` is available to the consumer of the message (this can be useful for troubleshooting delivery issues).
         *
         * If a message is sent successfully but the acknowledgement is lost and the message is resent with the same `MessageDeduplicationId` after the deduplication interval, Amazon SNS can't detect duplicate messages.
         *
         * Amazon SNS continues to keep track of the message deduplication ID even after the message is received and deleted.
         *
         * The length of `MessageDeduplicationId` is 128 characters.
         *
         * `MessageDeduplicationId` can contain alphanumeric characters `(a-z, A-Z, 0-9)` and punctuation `(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)`.
         */
        public var messageDeduplicationId: kotlin.String? = null
        /**
         * This parameter applies only to FIFO (first-in-first-out) topics.
         *
         * The tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). To interleave multiple ordered streams within a single topic, use `MessageGroupId` values (for example, session data for multiple users). In this scenario, multiple consumers can process the topic, but the session data of each user is processed in a FIFO fashion.
         *
         * You must associate a non-empty `MessageGroupId` with a message. If you don't provide a `MessageGroupId`, the action fails.
         *
         * The length of `MessageGroupId` is 128 characters.
         *
         * `MessageGroupId` can contain alphanumeric characters `(a-z, A-Z, 0-9)` and punctuation `(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)`.
         *
         * `MessageGroupId` is required for FIFO topics. You can't use it for standard topics.
         */
        public var messageGroupId: kotlin.String? = null
        /**
         * Set `MessageStructure` to `json` if you want to send a different message for each protocol. For example, using one publish action, you can send a short message to your SMS subscribers and a longer message to your email subscribers. If you set `MessageStructure` to `json`, the value of the `Message` parameter must:
         * + be a syntactically valid JSON object; and
         * + contain at least a top-level JSON key of "default" with a value that is a string.
         *
         * You can define other top-level keys that define the message you want to send to a specific transport protocol (e.g. http).
         */
        public var messageStructure: kotlin.String? = null
        /**
         * The subject of the batch message.
         */
        public var subject: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sns.model.PublishBatchRequestEntry) : this() {
            this.id = x.id
            this.message = x.message
            this.messageAttributes = x.messageAttributes
            this.messageDeduplicationId = x.messageDeduplicationId
            this.messageGroupId = x.messageGroupId
            this.messageStructure = x.messageStructure
            this.subject = x.subject
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sns.model.PublishBatchRequestEntry = PublishBatchRequestEntry(this)

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (message == null) message = ""
            return this
        }
    }
}
