// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Response for GetSubscriptionAttributes action.
 */
public class GetSubscriptionAttributesResponse private constructor(builder: Builder) {
    /**
     * A map of the subscription's attributes. Attributes in this map include the following:
     * + `ConfirmationWasAuthenticated` – `true` if the subscription confirmation request was authenticated.
     * + `DeliveryPolicy` – The JSON serialization of the subscription's delivery policy.
     * + `EffectiveDeliveryPolicy` – The JSON serialization of the effective delivery policy that takes into account the topic delivery policy and account system defaults.
     * + `FilterPolicy` – The filter policy JSON that is assigned to the subscription. For more information, see [Amazon SNS Message Filtering](https://docs.aws.amazon.com/sns/latest/dg/sns-message-filtering.html) in the *Amazon SNS Developer Guide*.
     * + `FilterPolicyScope` – This attribute lets you choose the filtering scope by using one of the following string value types:
     *    + `MessageAttributes` (default) – The filter is applied on the message attributes.
     *    + `MessageBody` – The filter is applied on the message body.
     * + `Owner` – The Amazon Web Services account ID of the subscription's owner.
     * + `PendingConfirmation` – `true` if the subscription hasn't been confirmed. To confirm a pending subscription, call the `ConfirmSubscription` action with a confirmation token.
     * + `RawMessageDelivery` – `true` if raw message delivery is enabled for the subscription. Raw messages are free of JSON formatting and can be sent to HTTP/S and Amazon SQS endpoints.
     * + `RedrivePolicy` – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
     * + `SubscriptionArn` – The subscription's ARN.
     * + `TopicArn` – The topic ARN that the subscription is associated with.
     *
     * The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:
     * + `SubscriptionRoleArn` – The ARN of the IAM role that has the following:
     *    + Permission to write to the Kinesis Data Firehose delivery stream
     *    + Amazon SNS listed as a trusted entity
     * Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions. For more information, see [Fanout to Kinesis Data Firehose delivery streams](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html) in the *Amazon SNS Developer Guide*.
     */
    public val attributes: Map<String, String>? = builder.attributes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sns.model.GetSubscriptionAttributesResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSubscriptionAttributesResponse(")
        append("attributes=$attributes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSubscriptionAttributesResponse

        if (attributes != other.attributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sns.model.GetSubscriptionAttributesResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A map of the subscription's attributes. Attributes in this map include the following:
         * + `ConfirmationWasAuthenticated` – `true` if the subscription confirmation request was authenticated.
         * + `DeliveryPolicy` – The JSON serialization of the subscription's delivery policy.
         * + `EffectiveDeliveryPolicy` – The JSON serialization of the effective delivery policy that takes into account the topic delivery policy and account system defaults.
         * + `FilterPolicy` – The filter policy JSON that is assigned to the subscription. For more information, see [Amazon SNS Message Filtering](https://docs.aws.amazon.com/sns/latest/dg/sns-message-filtering.html) in the *Amazon SNS Developer Guide*.
         * + `FilterPolicyScope` – This attribute lets you choose the filtering scope by using one of the following string value types:
         *    + `MessageAttributes` (default) – The filter is applied on the message attributes.
         *    + `MessageBody` – The filter is applied on the message body.
         * + `Owner` – The Amazon Web Services account ID of the subscription's owner.
         * + `PendingConfirmation` – `true` if the subscription hasn't been confirmed. To confirm a pending subscription, call the `ConfirmSubscription` action with a confirmation token.
         * + `RawMessageDelivery` – `true` if raw message delivery is enabled for the subscription. Raw messages are free of JSON formatting and can be sent to HTTP/S and Amazon SQS endpoints.
         * + `RedrivePolicy` – When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors (for example, when the subscribed endpoint is unreachable) or server errors (for example, when the service that powers the subscribed endpoint becomes unavailable) are held in the dead-letter queue for further analysis or reprocessing.
         * + `SubscriptionArn` – The subscription's ARN.
         * + `TopicArn` – The topic ARN that the subscription is associated with.
         *
         * The following attribute applies only to Amazon Kinesis Data Firehose delivery stream subscriptions:
         * + `SubscriptionRoleArn` – The ARN of the IAM role that has the following:
         *    + Permission to write to the Kinesis Data Firehose delivery stream
         *    + Amazon SNS listed as a trusted entity
         * Specifying a valid ARN for this attribute is required for Kinesis Data Firehose delivery stream subscriptions. For more information, see [Fanout to Kinesis Data Firehose delivery streams](https://docs.aws.amazon.com/sns/latest/dg/sns-firehose-as-subscriber.html) in the *Amazon SNS Developer Guide*.
         */
        public var attributes: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sns.model.GetSubscriptionAttributesResponse) : this() {
            this.attributes = x.attributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sns.model.GetSubscriptionAttributesResponse = GetSubscriptionAttributesResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
