// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.sns.auth.DefaultSnsAuthSchemeProvider
import aws.sdk.kotlin.services.sns.auth.SnsAuthSchemeProvider
import aws.sdk.kotlin.services.sns.endpoints.DefaultSnsEndpointProvider
import aws.sdk.kotlin.services.sns.endpoints.SnsEndpointParameters
import aws.sdk.kotlin.services.sns.endpoints.SnsEndpointProvider
import aws.sdk.kotlin.services.sns.model.AddPermissionRequest
import aws.sdk.kotlin.services.sns.model.AddPermissionResponse
import aws.sdk.kotlin.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest
import aws.sdk.kotlin.services.sns.model.CheckIfPhoneNumberIsOptedOutResponse
import aws.sdk.kotlin.services.sns.model.ConfirmSubscriptionRequest
import aws.sdk.kotlin.services.sns.model.ConfirmSubscriptionResponse
import aws.sdk.kotlin.services.sns.model.CreatePlatformApplicationRequest
import aws.sdk.kotlin.services.sns.model.CreatePlatformApplicationResponse
import aws.sdk.kotlin.services.sns.model.CreatePlatformEndpointRequest
import aws.sdk.kotlin.services.sns.model.CreatePlatformEndpointResponse
import aws.sdk.kotlin.services.sns.model.CreateSmsSandboxPhoneNumberRequest
import aws.sdk.kotlin.services.sns.model.CreateSmsSandboxPhoneNumberResponse
import aws.sdk.kotlin.services.sns.model.CreateTopicRequest
import aws.sdk.kotlin.services.sns.model.CreateTopicResponse
import aws.sdk.kotlin.services.sns.model.DeleteEndpointRequest
import aws.sdk.kotlin.services.sns.model.DeleteEndpointResponse
import aws.sdk.kotlin.services.sns.model.DeletePlatformApplicationRequest
import aws.sdk.kotlin.services.sns.model.DeletePlatformApplicationResponse
import aws.sdk.kotlin.services.sns.model.DeleteSmsSandboxPhoneNumberRequest
import aws.sdk.kotlin.services.sns.model.DeleteSmsSandboxPhoneNumberResponse
import aws.sdk.kotlin.services.sns.model.DeleteTopicRequest
import aws.sdk.kotlin.services.sns.model.DeleteTopicResponse
import aws.sdk.kotlin.services.sns.model.GetDataProtectionPolicyRequest
import aws.sdk.kotlin.services.sns.model.GetDataProtectionPolicyResponse
import aws.sdk.kotlin.services.sns.model.GetEndpointAttributesRequest
import aws.sdk.kotlin.services.sns.model.GetEndpointAttributesResponse
import aws.sdk.kotlin.services.sns.model.GetPlatformApplicationAttributesRequest
import aws.sdk.kotlin.services.sns.model.GetPlatformApplicationAttributesResponse
import aws.sdk.kotlin.services.sns.model.GetSmsAttributesRequest
import aws.sdk.kotlin.services.sns.model.GetSmsAttributesResponse
import aws.sdk.kotlin.services.sns.model.GetSmsSandboxAccountStatusRequest
import aws.sdk.kotlin.services.sns.model.GetSmsSandboxAccountStatusResponse
import aws.sdk.kotlin.services.sns.model.GetSubscriptionAttributesRequest
import aws.sdk.kotlin.services.sns.model.GetSubscriptionAttributesResponse
import aws.sdk.kotlin.services.sns.model.GetTopicAttributesRequest
import aws.sdk.kotlin.services.sns.model.GetTopicAttributesResponse
import aws.sdk.kotlin.services.sns.model.ListEndpointsByPlatformApplicationRequest
import aws.sdk.kotlin.services.sns.model.ListEndpointsByPlatformApplicationResponse
import aws.sdk.kotlin.services.sns.model.ListOriginationNumbersRequest
import aws.sdk.kotlin.services.sns.model.ListOriginationNumbersResponse
import aws.sdk.kotlin.services.sns.model.ListPhoneNumbersOptedOutRequest
import aws.sdk.kotlin.services.sns.model.ListPhoneNumbersOptedOutResponse
import aws.sdk.kotlin.services.sns.model.ListPlatformApplicationsRequest
import aws.sdk.kotlin.services.sns.model.ListPlatformApplicationsResponse
import aws.sdk.kotlin.services.sns.model.ListSmsSandboxPhoneNumbersRequest
import aws.sdk.kotlin.services.sns.model.ListSmsSandboxPhoneNumbersResponse
import aws.sdk.kotlin.services.sns.model.ListSubscriptionsByTopicRequest
import aws.sdk.kotlin.services.sns.model.ListSubscriptionsByTopicResponse
import aws.sdk.kotlin.services.sns.model.ListSubscriptionsRequest
import aws.sdk.kotlin.services.sns.model.ListSubscriptionsResponse
import aws.sdk.kotlin.services.sns.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.sns.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.sns.model.ListTopicsRequest
import aws.sdk.kotlin.services.sns.model.ListTopicsResponse
import aws.sdk.kotlin.services.sns.model.OptInPhoneNumberRequest
import aws.sdk.kotlin.services.sns.model.OptInPhoneNumberResponse
import aws.sdk.kotlin.services.sns.model.PublishBatchRequest
import aws.sdk.kotlin.services.sns.model.PublishBatchResponse
import aws.sdk.kotlin.services.sns.model.PublishRequest
import aws.sdk.kotlin.services.sns.model.PublishResponse
import aws.sdk.kotlin.services.sns.model.PutDataProtectionPolicyRequest
import aws.sdk.kotlin.services.sns.model.PutDataProtectionPolicyResponse
import aws.sdk.kotlin.services.sns.model.RemovePermissionRequest
import aws.sdk.kotlin.services.sns.model.RemovePermissionResponse
import aws.sdk.kotlin.services.sns.model.SetEndpointAttributesRequest
import aws.sdk.kotlin.services.sns.model.SetEndpointAttributesResponse
import aws.sdk.kotlin.services.sns.model.SetPlatformApplicationAttributesRequest
import aws.sdk.kotlin.services.sns.model.SetPlatformApplicationAttributesResponse
import aws.sdk.kotlin.services.sns.model.SetSmsAttributesRequest
import aws.sdk.kotlin.services.sns.model.SetSmsAttributesResponse
import aws.sdk.kotlin.services.sns.model.SetSubscriptionAttributesRequest
import aws.sdk.kotlin.services.sns.model.SetSubscriptionAttributesResponse
import aws.sdk.kotlin.services.sns.model.SetTopicAttributesRequest
import aws.sdk.kotlin.services.sns.model.SetTopicAttributesResponse
import aws.sdk.kotlin.services.sns.model.SubscribeRequest
import aws.sdk.kotlin.services.sns.model.SubscribeResponse
import aws.sdk.kotlin.services.sns.model.TagResourceRequest
import aws.sdk.kotlin.services.sns.model.TagResourceResponse
import aws.sdk.kotlin.services.sns.model.UnsubscribeRequest
import aws.sdk.kotlin.services.sns.model.UnsubscribeResponse
import aws.sdk.kotlin.services.sns.model.UntagResourceRequest
import aws.sdk.kotlin.services.sns.model.UntagResourceResponse
import aws.sdk.kotlin.services.sns.model.VerifySmsSandboxPhoneNumberRequest
import aws.sdk.kotlin.services.sns.model.VerifySmsSandboxPhoneNumberResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "SNS"
public const val SdkVersion: String = "1.2.2"
public const val ServiceApiVersion: String = "2010-03-31"

/**
 * # Amazon Simple Notification Service
 * Amazon Simple Notification Service (Amazon SNS) is a web service that enables you to build distributed web-enabled applications. Applications can use Amazon SNS to easily push real-time notification messages to interested subscribers over multiple delivery protocols. For more information about this product see the [Amazon SNS product page](http://aws.amazon.com/sns/). For detailed information about Amazon SNS features and their associated API calls, see the [Amazon SNS Developer Guide](https://docs.aws.amazon.com/sns/latest/dg/).
 *
 * For information on the permissions you need to use this API, see [Identity and access management in Amazon SNS](https://docs.aws.amazon.com/sns/latest/dg/sns-authentication-and-access-control.html) in the *Amazon SNS Developer Guide.*
 *
 * We also provide SDKs that enable you to access Amazon SNS from your preferred programming language. The SDKs contain functionality that automatically takes care of tasks such as: cryptographically signing your service requests, retrying requests, and handling error responses. For a list of available SDKs, go to [Tools for Amazon Web Services](http://aws.amazon.com/tools/).
 */
public interface SnsClient : SdkClient {
    /**
     * SnsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SnsClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Sns",
                "SNS",
                "sns",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SnsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SnsClient = DefaultSnsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SnsEndpointProvider = builder.endpointProvider ?: DefaultSnsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SnsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSnsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SNS"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SnsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SnsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds a statement to a topic's access control policy, granting access for the specified Amazon Web Services accounts to the specified actions.
     *
     * To remove the ability to change topic permissions, you must deny permissions to the `AddPermission`, `RemovePermission`, and `SetTopicAttributes` actions in your IAM policy.
     */
    public suspend fun addPermission(input: AddPermissionRequest): AddPermissionResponse

    /**
     * Accepts a phone number and indicates whether the phone holder has opted out of receiving SMS messages from your Amazon Web Services account. You cannot send SMS messages to a number that is opted out.
     *
     * To resume sending messages, you can opt in the number by using the `OptInPhoneNumber` action.
     */
    public suspend fun checkIfPhoneNumberIsOptedOut(input: CheckIfPhoneNumberIsOptedOutRequest): CheckIfPhoneNumberIsOptedOutResponse

    /**
     * Verifies an endpoint owner's intent to receive messages by validating the token sent to the endpoint by an earlier `Subscribe` action. If the token is valid, the action creates a new subscription and returns its Amazon Resource Name (ARN). This call requires an AWS signature only when the `AuthenticateOnUnsubscribe` flag is set to "true".
     */
    public suspend fun confirmSubscription(input: ConfirmSubscriptionRequest): ConfirmSubscriptionResponse

    /**
     * Creates a platform application object for one of the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging), to which devices and mobile apps may register. You must specify `PlatformPrincipal` and `PlatformCredential` attributes when using the `CreatePlatformApplication` action.
     *
     * `PlatformPrincipal` and `PlatformCredential` are received from the notification service.
     * + For `ADM`, `PlatformPrincipal` is `client id` and `PlatformCredential` is `client secret`.
     * + For `Baidu`, `PlatformPrincipal` is `API key` and `PlatformCredential` is `secret key`.
     * + For `APNS` and `APNS_SANDBOX` using certificate credentials, `PlatformPrincipal` is `SSL certificate` and `PlatformCredential` is `private key`.
     * + For `APNS` and `APNS_SANDBOX` using token credentials, `PlatformPrincipal` is `signing key ID` and `PlatformCredential` is `signing key`.
     * + For GCM (Firebase Cloud Messaging) using key credentials, there is no `PlatformPrincipal`. The `PlatformCredential` is `API key`.
     * + For GCM (Firebase Cloud Messaging) using token credentials, there is no `PlatformPrincipal`. The `PlatformCredential` is a JSON formatted private key file. When using the Amazon Web Services CLI, the file must be in string format and special characters must be ignored. To format the file correctly, Amazon SNS recommends using the following command: `SERVICE_JSON=`jq @json <<< cat service.json``.
     * + For `MPNS`, `PlatformPrincipal` is `TLS certificate` and `PlatformCredential` is `private key`.
     * + For `WNS`, `PlatformPrincipal` is `Package Security Identifier` and `PlatformCredential` is `secret key`.
     *
     * You can use the returned `PlatformApplicationArn` as an attribute for the `CreatePlatformEndpoint` action.
     */
    public suspend fun createPlatformApplication(input: CreatePlatformApplicationRequest): CreatePlatformApplicationResponse

    /**
     * Creates an endpoint for a device and mobile app on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. `CreatePlatformEndpoint` requires the `PlatformApplicationArn` that is returned from `CreatePlatformApplication`. You can use the returned `EndpointArn` to send a message to a mobile app or by the `Subscribe` action for subscription to a topic. The `CreatePlatformEndpoint` action is idempotent, so if the requester already owns an endpoint with the same device token and attributes, that endpoint's ARN is returned without creating a new endpoint. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
     *
     * When using `CreatePlatformEndpoint` with Baidu, two attributes must be provided: ChannelId and UserId. The token field must also contain the ChannelId. For more information, see [Creating an Amazon SNS Endpoint for Baidu](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePushBaiduEndpoint.html).
     */
    public suspend fun createPlatformEndpoint(input: CreatePlatformEndpointRequest): CreatePlatformEndpointResponse

    /**
     * Adds a destination phone number to an Amazon Web Services account in the SMS sandbox and sends a one-time password (OTP) to that phone number.
     *
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the *SMS sandbox*. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see [SMS sandbox](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html) in the *Amazon SNS Developer Guide*.
     */
    public suspend fun createSmsSandboxPhoneNumber(input: CreateSmsSandboxPhoneNumberRequest): CreateSmsSandboxPhoneNumberResponse

    /**
     * Creates a topic to which notifications can be published. Users can create at most 100,000 standard topics (at most 1,000 FIFO topics). For more information, see [Creating an Amazon SNS topic](https://docs.aws.amazon.com/sns/latest/dg/sns-create-topic.html) in the *Amazon SNS Developer Guide*. This action is idempotent, so if the requester already owns a topic with the specified name, that topic's ARN is returned without creating a new topic.
     */
    public suspend fun createTopic(input: CreateTopicRequest): CreateTopicResponse

    /**
     * Deletes the endpoint for a device and mobile app from Amazon SNS. This action is idempotent. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
     *
     * When you delete an endpoint that is also subscribed to a topic, then you must also unsubscribe the endpoint from the topic.
     */
    public suspend fun deleteEndpoint(input: DeleteEndpointRequest): DeleteEndpointResponse

    /**
     * Deletes a platform application object for one of the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
     */
    public suspend fun deletePlatformApplication(input: DeletePlatformApplicationRequest): DeletePlatformApplicationResponse

    /**
     * Deletes an Amazon Web Services account's verified or pending phone number from the SMS sandbox.
     *
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the *SMS sandbox*. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see [SMS sandbox](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html) in the *Amazon SNS Developer Guide*.
     */
    public suspend fun deleteSmsSandboxPhoneNumber(input: DeleteSmsSandboxPhoneNumberRequest): DeleteSmsSandboxPhoneNumberResponse

    /**
     * Deletes a topic and all its subscriptions. Deleting a topic might prevent some messages previously sent to the topic from being delivered to subscribers. This action is idempotent, so deleting a topic that does not exist does not result in an error.
     */
    public suspend fun deleteTopic(input: DeleteTopicRequest): DeleteTopicResponse

    /**
     * Retrieves the specified inline `DataProtectionPolicy` document that is stored in the specified Amazon SNS topic.
     */
    public suspend fun getDataProtectionPolicy(input: GetDataProtectionPolicyRequest): GetDataProtectionPolicyResponse

    /**
     * Retrieves the endpoint attributes for a device on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
     */
    public suspend fun getEndpointAttributes(input: GetEndpointAttributesRequest): GetEndpointAttributesResponse

    /**
     * Retrieves the attributes of the platform application object for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
     */
    public suspend fun getPlatformApplicationAttributes(input: GetPlatformApplicationAttributesRequest): GetPlatformApplicationAttributesResponse

    /**
     * Returns the settings for sending SMS messages from your Amazon Web Services account.
     *
     * These settings are set with the `SetSMSAttributes` action.
     */
    public suspend fun getSmsAttributes(input: GetSmsAttributesRequest = GetSmsAttributesRequest { }): GetSmsAttributesResponse

    /**
     * Retrieves the SMS sandbox status for the calling Amazon Web Services account in the target Amazon Web Services Region.
     *
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the *SMS sandbox*. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see [SMS sandbox](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html) in the *Amazon SNS Developer Guide*.
     */
    public suspend fun getSmsSandboxAccountStatus(input: GetSmsSandboxAccountStatusRequest = GetSmsSandboxAccountStatusRequest { }): GetSmsSandboxAccountStatusResponse

    /**
     * Returns all of the properties of a subscription.
     */
    public suspend fun getSubscriptionAttributes(input: GetSubscriptionAttributesRequest): GetSubscriptionAttributesResponse

    /**
     * Returns all of the properties of a topic. Topic properties returned might differ based on the authorization of the user.
     */
    public suspend fun getTopicAttributes(input: GetTopicAttributesRequest): GetTopicAttributesResponse

    /**
     * Lists the endpoints and endpoint attributes for devices in a supported push notification service, such as GCM (Firebase Cloud Messaging) and APNS. The results for `ListEndpointsByPlatformApplication` are paginated and return a limited list of endpoints, up to 100. If additional records are available after the first page results, then a NextToken string will be returned. To receive the next page, you call `ListEndpointsByPlatformApplication` again using the NextToken string received from the previous call. When there are no more records to return, NextToken will be null. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
     *
     * This action is throttled at 30 transactions per second (TPS).
     */
    public suspend fun listEndpointsByPlatformApplication(input: ListEndpointsByPlatformApplicationRequest): ListEndpointsByPlatformApplicationResponse

    /**
     * Lists the calling Amazon Web Services account's dedicated origination numbers and their metadata. For more information about origination numbers, see [Origination numbers](https://docs.aws.amazon.com/sns/latest/dg/channels-sms-originating-identities-origination-numbers.html) in the *Amazon SNS Developer Guide*.
     */
    public suspend fun listOriginationNumbers(input: ListOriginationNumbersRequest = ListOriginationNumbersRequest { }): ListOriginationNumbersResponse

    /**
     * Returns a list of phone numbers that are opted out, meaning you cannot send SMS messages to them.
     *
     * The results for `ListPhoneNumbersOptedOut` are paginated, and each page returns up to 100 phone numbers. If additional phone numbers are available after the first page of results, then a `NextToken` string will be returned. To receive the next page, you call `ListPhoneNumbersOptedOut` again using the `NextToken` string received from the previous call. When there are no more records to return, `NextToken` will be null.
     */
    public suspend fun listPhoneNumbersOptedOut(input: ListPhoneNumbersOptedOutRequest = ListPhoneNumbersOptedOutRequest { }): ListPhoneNumbersOptedOutResponse

    /**
     * Lists the platform application objects for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). The results for `ListPlatformApplications` are paginated and return a limited list of applications, up to 100. If additional records are available after the first page results, then a NextToken string will be returned. To receive the next page, you call `ListPlatformApplications` using the NextToken string received from the previous call. When there are no more records to return, `NextToken` will be null. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
     *
     * This action is throttled at 15 transactions per second (TPS).
     */
    public suspend fun listPlatformApplications(input: ListPlatformApplicationsRequest = ListPlatformApplicationsRequest { }): ListPlatformApplicationsResponse

    /**
     * Lists the calling Amazon Web Services account's current verified and pending destination phone numbers in the SMS sandbox.
     *
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the *SMS sandbox*. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see [SMS sandbox](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html) in the *Amazon SNS Developer Guide*.
     */
    public suspend fun listSmsSandboxPhoneNumbers(input: ListSmsSandboxPhoneNumbersRequest = ListSmsSandboxPhoneNumbersRequest { }): ListSmsSandboxPhoneNumbersResponse

    /**
     * Returns a list of the requester's subscriptions. Each call returns a limited list of subscriptions, up to 100. If there are more subscriptions, a `NextToken` is also returned. Use the `NextToken` parameter in a new `ListSubscriptions` call to get further results.
     *
     * This action is throttled at 30 transactions per second (TPS).
     */
    public suspend fun listSubscriptions(input: ListSubscriptionsRequest = ListSubscriptionsRequest { }): ListSubscriptionsResponse

    /**
     * Returns a list of the subscriptions to a specific topic. Each call returns a limited list of subscriptions, up to 100. If there are more subscriptions, a `NextToken` is also returned. Use the `NextToken` parameter in a new `ListSubscriptionsByTopic` call to get further results.
     *
     * This action is throttled at 30 transactions per second (TPS).
     */
    public suspend fun listSubscriptionsByTopic(input: ListSubscriptionsByTopicRequest): ListSubscriptionsByTopicResponse

    /**
     * List all tags added to the specified Amazon SNS topic. For an overview, see [Amazon SNS Tags](https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html) in the *Amazon Simple Notification Service Developer Guide*.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of the requester's topics. Each call returns a limited list of topics, up to 100. If there are more topics, a `NextToken` is also returned. Use the `NextToken` parameter in a new `ListTopics` call to get further results.
     *
     * This action is throttled at 30 transactions per second (TPS).
     */
    public suspend fun listTopics(input: ListTopicsRequest = ListTopicsRequest { }): ListTopicsResponse

    /**
     * Use this request to opt in a phone number that is opted out, which enables you to resume sending SMS messages to the number.
     *
     * You can opt in a phone number only once every 30 days.
     */
    public suspend fun optInPhoneNumber(input: OptInPhoneNumberRequest): OptInPhoneNumberResponse

    /**
     * Sends a message to an Amazon SNS topic, a text message (SMS message) directly to a phone number, or a message to a mobile platform endpoint (when you specify the `TargetArn`).
     *
     * If you send a message to a topic, Amazon SNS delivers the message to each endpoint that is subscribed to the topic. The format of the message depends on the notification protocol for each subscribed endpoint.
     *
     * When a `messageId` is returned, the message is saved and Amazon SNS immediately delivers it to subscribers.
     *
     * To use the `Publish` action for publishing a message to a mobile endpoint, such as an app on a Kindle device or mobile phone, you must specify the EndpointArn for the TargetArn parameter. The EndpointArn is returned when making a call with the `CreatePlatformEndpoint` action.
     *
     * For more information about formatting messages, see [Send Custom Platform-Specific Payloads in Messages to Mobile Devices](https://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-custommessage.html).
     *
     * You can publish messages only to topics and endpoints in the same Amazon Web Services Region.
     */
    public suspend fun publish(input: PublishRequest): PublishResponse

    /**
     * Publishes up to ten messages to the specified topic. This is a batch version of `Publish`. For FIFO topics, multiple messages within a single batch are published in the order they are sent, and messages are deduplicated within the batch and across batches for 5 minutes.
     *
     * The result of publishing each message is reported individually in the response. Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of `200`.
     *
     * The maximum allowed individual message size and the maximum total payload size (the sum of the individual lengths of all of the batched messages) are both 256 KB (262,144 bytes).
     *
     * Some actions take lists of parameters. These lists are specified using the `param.n` notation. Values of `n` are integers starting from 1. For example, a parameter list with two elements looks like this:
     *
     * &AttributeName.1=first
     *
     * &AttributeName.2=second
     *
     * If you send a batch message to a topic, Amazon SNS publishes the batch message to each endpoint that is subscribed to the topic. The format of the batch message depends on the notification protocol for each subscribed endpoint.
     *
     * When a `messageId` is returned, the batch message is saved and Amazon SNS immediately delivers the message to subscribers.
     */
    public suspend fun publishBatch(input: PublishBatchRequest): PublishBatchResponse

    /**
     * Adds or updates an inline policy document that is stored in the specified Amazon SNS topic.
     */
    public suspend fun putDataProtectionPolicy(input: PutDataProtectionPolicyRequest): PutDataProtectionPolicyResponse

    /**
     * Removes a statement from a topic's access control policy.
     *
     * To remove the ability to change topic permissions, you must deny permissions to the `AddPermission`, `RemovePermission`, and `SetTopicAttributes` actions in your IAM policy.
     */
    public suspend fun removePermission(input: RemovePermissionRequest): RemovePermissionResponse

    /**
     * Sets the attributes for an endpoint for a device on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
     */
    public suspend fun setEndpointAttributes(input: SetEndpointAttributesRequest): SetEndpointAttributesResponse

    /**
     * Sets the attributes of the platform application object for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html). For information on configuring attributes for message delivery status, see [Using Amazon SNS Application Attributes for Message Delivery Status](https://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html).
     */
    public suspend fun setPlatformApplicationAttributes(input: SetPlatformApplicationAttributesRequest): SetPlatformApplicationAttributesResponse

    /**
     * Use this request to set the default settings for sending SMS messages and receiving daily SMS usage reports.
     *
     * You can override some of these settings for a single message when you use the `Publish` action with the `MessageAttributes.entry.N` parameter. For more information, see [Publishing to a mobile phone](https://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html) in the *Amazon SNS Developer Guide*.
     *
     * To use this operation, you must grant the Amazon SNS service principal (`sns.amazonaws.com`) permission to perform the `s3:ListBucket` action.
     */
    public suspend fun setSmsAttributes(input: SetSmsAttributesRequest): SetSmsAttributesResponse

    /**
     * Allows a subscription owner to set an attribute of the subscription to a new value.
     */
    public suspend fun setSubscriptionAttributes(input: SetSubscriptionAttributesRequest): SetSubscriptionAttributesResponse

    /**
     * Allows a topic owner to set an attribute of the topic to a new value.
     *
     * To remove the ability to change topic permissions, you must deny permissions to the `AddPermission`, `RemovePermission`, and `SetTopicAttributes` actions in your IAM policy.
     */
    public suspend fun setTopicAttributes(input: SetTopicAttributesRequest): SetTopicAttributesResponse

    /**
     * Subscribes an endpoint to an Amazon SNS topic. If the endpoint type is HTTP/S or email, or if the endpoint and the topic are not in the same Amazon Web Services account, the endpoint owner must run the `ConfirmSubscription` action to confirm the subscription.
     *
     * You call the `ConfirmSubscription` action with the token from the subscription response. Confirmation tokens are valid for two days.
     *
     * This action is throttled at 100 transactions per second (TPS).
     */
    public suspend fun subscribe(input: SubscribeRequest): SubscribeResponse

    /**
     * Add tags to the specified Amazon SNS topic. For an overview, see [Amazon SNS Tags](https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html) in the *Amazon SNS Developer Guide*.
     *
     * When you use topic tags, keep the following guidelines in mind:
     * + Adding more than 50 tags to a topic isn't recommended.
     * + Tags don't have any semantic meaning. Amazon SNS interprets tags as character strings.
     * + Tags are case-sensitive.
     * + A new tag with a key identical to that of an existing tag overwrites the existing tag.
     * + Tagging actions are limited to 10 TPS per Amazon Web Services account, per Amazon Web Services Region. If your application requires a higher throughput, file a [technical support request](https://console.aws.amazon.com/support/home#/case/create?issueType=technical).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes a subscription. If the subscription requires authentication for deletion, only the owner of the subscription or the topic's owner can unsubscribe, and an Amazon Web Services signature is required. If the `Unsubscribe` call does not require authentication and the requester is not the subscription owner, a final cancellation message is delivered to the endpoint, so that the endpoint owner can easily resubscribe to the topic if the `Unsubscribe` request was unintended.
     *
     * Amazon SQS queue subscriptions require authentication for deletion. Only the owner of the subscription, or the owner of the topic can unsubscribe using the required Amazon Web Services signature.
     *
     * This action is throttled at 100 transactions per second (TPS).
     */
    public suspend fun unsubscribe(input: UnsubscribeRequest): UnsubscribeResponse

    /**
     * Remove tags from the specified Amazon SNS topic. For an overview, see [Amazon SNS Tags](https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html) in the *Amazon SNS Developer Guide*.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Verifies a destination phone number with a one-time password (OTP) for the calling Amazon Web Services account.
     *
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the *SMS sandbox*. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see [SMS sandbox](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html) in the *Amazon SNS Developer Guide*.
     */
    public suspend fun verifySmsSandboxPhoneNumber(input: VerifySmsSandboxPhoneNumberRequest): VerifySmsSandboxPhoneNumberResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SnsClient.withConfig(block: SnsClient.Config.Builder.() -> Unit): SnsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSnsClient(newConfig)
}

/**
 * Adds a statement to a topic's access control policy, granting access for the specified Amazon Web Services accounts to the specified actions.
 *
 * To remove the ability to change topic permissions, you must deny permissions to the `AddPermission`, `RemovePermission`, and `SetTopicAttributes` actions in your IAM policy.
 */
public suspend inline fun SnsClient.addPermission(crossinline block: AddPermissionRequest.Builder.() -> Unit): AddPermissionResponse = addPermission(AddPermissionRequest.Builder().apply(block).build())

/**
 * Accepts a phone number and indicates whether the phone holder has opted out of receiving SMS messages from your Amazon Web Services account. You cannot send SMS messages to a number that is opted out.
 *
 * To resume sending messages, you can opt in the number by using the `OptInPhoneNumber` action.
 */
public suspend inline fun SnsClient.checkIfPhoneNumberIsOptedOut(crossinline block: CheckIfPhoneNumberIsOptedOutRequest.Builder.() -> Unit): CheckIfPhoneNumberIsOptedOutResponse = checkIfPhoneNumberIsOptedOut(CheckIfPhoneNumberIsOptedOutRequest.Builder().apply(block).build())

/**
 * Verifies an endpoint owner's intent to receive messages by validating the token sent to the endpoint by an earlier `Subscribe` action. If the token is valid, the action creates a new subscription and returns its Amazon Resource Name (ARN). This call requires an AWS signature only when the `AuthenticateOnUnsubscribe` flag is set to "true".
 */
public suspend inline fun SnsClient.confirmSubscription(crossinline block: ConfirmSubscriptionRequest.Builder.() -> Unit): ConfirmSubscriptionResponse = confirmSubscription(ConfirmSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates a platform application object for one of the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging), to which devices and mobile apps may register. You must specify `PlatformPrincipal` and `PlatformCredential` attributes when using the `CreatePlatformApplication` action.
 *
 * `PlatformPrincipal` and `PlatformCredential` are received from the notification service.
 * + For `ADM`, `PlatformPrincipal` is `client id` and `PlatformCredential` is `client secret`.
 * + For `Baidu`, `PlatformPrincipal` is `API key` and `PlatformCredential` is `secret key`.
 * + For `APNS` and `APNS_SANDBOX` using certificate credentials, `PlatformPrincipal` is `SSL certificate` and `PlatformCredential` is `private key`.
 * + For `APNS` and `APNS_SANDBOX` using token credentials, `PlatformPrincipal` is `signing key ID` and `PlatformCredential` is `signing key`.
 * + For GCM (Firebase Cloud Messaging) using key credentials, there is no `PlatformPrincipal`. The `PlatformCredential` is `API key`.
 * + For GCM (Firebase Cloud Messaging) using token credentials, there is no `PlatformPrincipal`. The `PlatformCredential` is a JSON formatted private key file. When using the Amazon Web Services CLI, the file must be in string format and special characters must be ignored. To format the file correctly, Amazon SNS recommends using the following command: `SERVICE_JSON=`jq @json <<< cat service.json``.
 * + For `MPNS`, `PlatformPrincipal` is `TLS certificate` and `PlatformCredential` is `private key`.
 * + For `WNS`, `PlatformPrincipal` is `Package Security Identifier` and `PlatformCredential` is `secret key`.
 *
 * You can use the returned `PlatformApplicationArn` as an attribute for the `CreatePlatformEndpoint` action.
 */
public suspend inline fun SnsClient.createPlatformApplication(crossinline block: CreatePlatformApplicationRequest.Builder.() -> Unit): CreatePlatformApplicationResponse = createPlatformApplication(CreatePlatformApplicationRequest.Builder().apply(block).build())

/**
 * Creates an endpoint for a device and mobile app on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. `CreatePlatformEndpoint` requires the `PlatformApplicationArn` that is returned from `CreatePlatformApplication`. You can use the returned `EndpointArn` to send a message to a mobile app or by the `Subscribe` action for subscription to a topic. The `CreatePlatformEndpoint` action is idempotent, so if the requester already owns an endpoint with the same device token and attributes, that endpoint's ARN is returned without creating a new endpoint. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
 *
 * When using `CreatePlatformEndpoint` with Baidu, two attributes must be provided: ChannelId and UserId. The token field must also contain the ChannelId. For more information, see [Creating an Amazon SNS Endpoint for Baidu](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePushBaiduEndpoint.html).
 */
public suspend inline fun SnsClient.createPlatformEndpoint(crossinline block: CreatePlatformEndpointRequest.Builder.() -> Unit): CreatePlatformEndpointResponse = createPlatformEndpoint(CreatePlatformEndpointRequest.Builder().apply(block).build())

/**
 * Adds a destination phone number to an Amazon Web Services account in the SMS sandbox and sends a one-time password (OTP) to that phone number.
 *
 * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the *SMS sandbox*. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see [SMS sandbox](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html) in the *Amazon SNS Developer Guide*.
 */
public suspend inline fun SnsClient.createSmsSandboxPhoneNumber(crossinline block: CreateSmsSandboxPhoneNumberRequest.Builder.() -> Unit): CreateSmsSandboxPhoneNumberResponse = createSmsSandboxPhoneNumber(CreateSmsSandboxPhoneNumberRequest.Builder().apply(block).build())

/**
 * Creates a topic to which notifications can be published. Users can create at most 100,000 standard topics (at most 1,000 FIFO topics). For more information, see [Creating an Amazon SNS topic](https://docs.aws.amazon.com/sns/latest/dg/sns-create-topic.html) in the *Amazon SNS Developer Guide*. This action is idempotent, so if the requester already owns a topic with the specified name, that topic's ARN is returned without creating a new topic.
 */
public suspend inline fun SnsClient.createTopic(crossinline block: CreateTopicRequest.Builder.() -> Unit): CreateTopicResponse = createTopic(CreateTopicRequest.Builder().apply(block).build())

/**
 * Deletes the endpoint for a device and mobile app from Amazon SNS. This action is idempotent. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
 *
 * When you delete an endpoint that is also subscribed to a topic, then you must also unsubscribe the endpoint from the topic.
 */
public suspend inline fun SnsClient.deleteEndpoint(crossinline block: DeleteEndpointRequest.Builder.() -> Unit): DeleteEndpointResponse = deleteEndpoint(DeleteEndpointRequest.Builder().apply(block).build())

/**
 * Deletes a platform application object for one of the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
 */
public suspend inline fun SnsClient.deletePlatformApplication(crossinline block: DeletePlatformApplicationRequest.Builder.() -> Unit): DeletePlatformApplicationResponse = deletePlatformApplication(DeletePlatformApplicationRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Web Services account's verified or pending phone number from the SMS sandbox.
 *
 * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the *SMS sandbox*. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see [SMS sandbox](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html) in the *Amazon SNS Developer Guide*.
 */
public suspend inline fun SnsClient.deleteSmsSandboxPhoneNumber(crossinline block: DeleteSmsSandboxPhoneNumberRequest.Builder.() -> Unit): DeleteSmsSandboxPhoneNumberResponse = deleteSmsSandboxPhoneNumber(DeleteSmsSandboxPhoneNumberRequest.Builder().apply(block).build())

/**
 * Deletes a topic and all its subscriptions. Deleting a topic might prevent some messages previously sent to the topic from being delivered to subscribers. This action is idempotent, so deleting a topic that does not exist does not result in an error.
 */
public suspend inline fun SnsClient.deleteTopic(crossinline block: DeleteTopicRequest.Builder.() -> Unit): DeleteTopicResponse = deleteTopic(DeleteTopicRequest.Builder().apply(block).build())

/**
 * Retrieves the specified inline `DataProtectionPolicy` document that is stored in the specified Amazon SNS topic.
 */
public suspend inline fun SnsClient.getDataProtectionPolicy(crossinline block: GetDataProtectionPolicyRequest.Builder.() -> Unit): GetDataProtectionPolicyResponse = getDataProtectionPolicy(GetDataProtectionPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves the endpoint attributes for a device on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
 */
public suspend inline fun SnsClient.getEndpointAttributes(crossinline block: GetEndpointAttributesRequest.Builder.() -> Unit): GetEndpointAttributesResponse = getEndpointAttributes(GetEndpointAttributesRequest.Builder().apply(block).build())

/**
 * Retrieves the attributes of the platform application object for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
 */
public suspend inline fun SnsClient.getPlatformApplicationAttributes(crossinline block: GetPlatformApplicationAttributesRequest.Builder.() -> Unit): GetPlatformApplicationAttributesResponse = getPlatformApplicationAttributes(GetPlatformApplicationAttributesRequest.Builder().apply(block).build())

/**
 * Returns the settings for sending SMS messages from your Amazon Web Services account.
 *
 * These settings are set with the `SetSMSAttributes` action.
 */
public suspend inline fun SnsClient.getSmsAttributes(crossinline block: GetSmsAttributesRequest.Builder.() -> Unit): GetSmsAttributesResponse = getSmsAttributes(GetSmsAttributesRequest.Builder().apply(block).build())

/**
 * Retrieves the SMS sandbox status for the calling Amazon Web Services account in the target Amazon Web Services Region.
 *
 * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the *SMS sandbox*. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see [SMS sandbox](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html) in the *Amazon SNS Developer Guide*.
 */
public suspend inline fun SnsClient.getSmsSandboxAccountStatus(crossinline block: GetSmsSandboxAccountStatusRequest.Builder.() -> Unit): GetSmsSandboxAccountStatusResponse = getSmsSandboxAccountStatus(GetSmsSandboxAccountStatusRequest.Builder().apply(block).build())

/**
 * Returns all of the properties of a subscription.
 */
public suspend inline fun SnsClient.getSubscriptionAttributes(crossinline block: GetSubscriptionAttributesRequest.Builder.() -> Unit): GetSubscriptionAttributesResponse = getSubscriptionAttributes(GetSubscriptionAttributesRequest.Builder().apply(block).build())

/**
 * Returns all of the properties of a topic. Topic properties returned might differ based on the authorization of the user.
 */
public suspend inline fun SnsClient.getTopicAttributes(crossinline block: GetTopicAttributesRequest.Builder.() -> Unit): GetTopicAttributesResponse = getTopicAttributes(GetTopicAttributesRequest.Builder().apply(block).build())

/**
 * Lists the endpoints and endpoint attributes for devices in a supported push notification service, such as GCM (Firebase Cloud Messaging) and APNS. The results for `ListEndpointsByPlatformApplication` are paginated and return a limited list of endpoints, up to 100. If additional records are available after the first page results, then a NextToken string will be returned. To receive the next page, you call `ListEndpointsByPlatformApplication` again using the NextToken string received from the previous call. When there are no more records to return, NextToken will be null. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
 *
 * This action is throttled at 30 transactions per second (TPS).
 */
public suspend inline fun SnsClient.listEndpointsByPlatformApplication(crossinline block: ListEndpointsByPlatformApplicationRequest.Builder.() -> Unit): ListEndpointsByPlatformApplicationResponse = listEndpointsByPlatformApplication(ListEndpointsByPlatformApplicationRequest.Builder().apply(block).build())

/**
 * Lists the calling Amazon Web Services account's dedicated origination numbers and their metadata. For more information about origination numbers, see [Origination numbers](https://docs.aws.amazon.com/sns/latest/dg/channels-sms-originating-identities-origination-numbers.html) in the *Amazon SNS Developer Guide*.
 */
public suspend inline fun SnsClient.listOriginationNumbers(crossinline block: ListOriginationNumbersRequest.Builder.() -> Unit): ListOriginationNumbersResponse = listOriginationNumbers(ListOriginationNumbersRequest.Builder().apply(block).build())

/**
 * Returns a list of phone numbers that are opted out, meaning you cannot send SMS messages to them.
 *
 * The results for `ListPhoneNumbersOptedOut` are paginated, and each page returns up to 100 phone numbers. If additional phone numbers are available after the first page of results, then a `NextToken` string will be returned. To receive the next page, you call `ListPhoneNumbersOptedOut` again using the `NextToken` string received from the previous call. When there are no more records to return, `NextToken` will be null.
 */
public suspend inline fun SnsClient.listPhoneNumbersOptedOut(crossinline block: ListPhoneNumbersOptedOutRequest.Builder.() -> Unit): ListPhoneNumbersOptedOutResponse = listPhoneNumbersOptedOut(ListPhoneNumbersOptedOutRequest.Builder().apply(block).build())

/**
 * Lists the platform application objects for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). The results for `ListPlatformApplications` are paginated and return a limited list of applications, up to 100. If additional records are available after the first page results, then a NextToken string will be returned. To receive the next page, you call `ListPlatformApplications` using the NextToken string received from the previous call. When there are no more records to return, `NextToken` will be null. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
 *
 * This action is throttled at 15 transactions per second (TPS).
 */
public suspend inline fun SnsClient.listPlatformApplications(crossinline block: ListPlatformApplicationsRequest.Builder.() -> Unit): ListPlatformApplicationsResponse = listPlatformApplications(ListPlatformApplicationsRequest.Builder().apply(block).build())

/**
 * Lists the calling Amazon Web Services account's current verified and pending destination phone numbers in the SMS sandbox.
 *
 * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the *SMS sandbox*. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see [SMS sandbox](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html) in the *Amazon SNS Developer Guide*.
 */
public suspend inline fun SnsClient.listSmsSandboxPhoneNumbers(crossinline block: ListSmsSandboxPhoneNumbersRequest.Builder.() -> Unit): ListSmsSandboxPhoneNumbersResponse = listSmsSandboxPhoneNumbers(ListSmsSandboxPhoneNumbersRequest.Builder().apply(block).build())

/**
 * Returns a list of the requester's subscriptions. Each call returns a limited list of subscriptions, up to 100. If there are more subscriptions, a `NextToken` is also returned. Use the `NextToken` parameter in a new `ListSubscriptions` call to get further results.
 *
 * This action is throttled at 30 transactions per second (TPS).
 */
public suspend inline fun SnsClient.listSubscriptions(crossinline block: ListSubscriptionsRequest.Builder.() -> Unit): ListSubscriptionsResponse = listSubscriptions(ListSubscriptionsRequest.Builder().apply(block).build())

/**
 * Returns a list of the subscriptions to a specific topic. Each call returns a limited list of subscriptions, up to 100. If there are more subscriptions, a `NextToken` is also returned. Use the `NextToken` parameter in a new `ListSubscriptionsByTopic` call to get further results.
 *
 * This action is throttled at 30 transactions per second (TPS).
 */
public suspend inline fun SnsClient.listSubscriptionsByTopic(crossinline block: ListSubscriptionsByTopicRequest.Builder.() -> Unit): ListSubscriptionsByTopicResponse = listSubscriptionsByTopic(ListSubscriptionsByTopicRequest.Builder().apply(block).build())

/**
 * List all tags added to the specified Amazon SNS topic. For an overview, see [Amazon SNS Tags](https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html) in the *Amazon Simple Notification Service Developer Guide*.
 */
public suspend inline fun SnsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of the requester's topics. Each call returns a limited list of topics, up to 100. If there are more topics, a `NextToken` is also returned. Use the `NextToken` parameter in a new `ListTopics` call to get further results.
 *
 * This action is throttled at 30 transactions per second (TPS).
 */
public suspend inline fun SnsClient.listTopics(crossinline block: ListTopicsRequest.Builder.() -> Unit): ListTopicsResponse = listTopics(ListTopicsRequest.Builder().apply(block).build())

/**
 * Use this request to opt in a phone number that is opted out, which enables you to resume sending SMS messages to the number.
 *
 * You can opt in a phone number only once every 30 days.
 */
public suspend inline fun SnsClient.optInPhoneNumber(crossinline block: OptInPhoneNumberRequest.Builder.() -> Unit): OptInPhoneNumberResponse = optInPhoneNumber(OptInPhoneNumberRequest.Builder().apply(block).build())

/**
 * Sends a message to an Amazon SNS topic, a text message (SMS message) directly to a phone number, or a message to a mobile platform endpoint (when you specify the `TargetArn`).
 *
 * If you send a message to a topic, Amazon SNS delivers the message to each endpoint that is subscribed to the topic. The format of the message depends on the notification protocol for each subscribed endpoint.
 *
 * When a `messageId` is returned, the message is saved and Amazon SNS immediately delivers it to subscribers.
 *
 * To use the `Publish` action for publishing a message to a mobile endpoint, such as an app on a Kindle device or mobile phone, you must specify the EndpointArn for the TargetArn parameter. The EndpointArn is returned when making a call with the `CreatePlatformEndpoint` action.
 *
 * For more information about formatting messages, see [Send Custom Platform-Specific Payloads in Messages to Mobile Devices](https://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-custommessage.html).
 *
 * You can publish messages only to topics and endpoints in the same Amazon Web Services Region.
 */
public suspend inline fun SnsClient.publish(crossinline block: PublishRequest.Builder.() -> Unit): PublishResponse = publish(PublishRequest.Builder().apply(block).build())

/**
 * Publishes up to ten messages to the specified topic. This is a batch version of `Publish`. For FIFO topics, multiple messages within a single batch are published in the order they are sent, and messages are deduplicated within the batch and across batches for 5 minutes.
 *
 * The result of publishing each message is reported individually in the response. Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of `200`.
 *
 * The maximum allowed individual message size and the maximum total payload size (the sum of the individual lengths of all of the batched messages) are both 256 KB (262,144 bytes).
 *
 * Some actions take lists of parameters. These lists are specified using the `param.n` notation. Values of `n` are integers starting from 1. For example, a parameter list with two elements looks like this:
 *
 * &AttributeName.1=first
 *
 * &AttributeName.2=second
 *
 * If you send a batch message to a topic, Amazon SNS publishes the batch message to each endpoint that is subscribed to the topic. The format of the batch message depends on the notification protocol for each subscribed endpoint.
 *
 * When a `messageId` is returned, the batch message is saved and Amazon SNS immediately delivers the message to subscribers.
 */
public suspend inline fun SnsClient.publishBatch(crossinline block: PublishBatchRequest.Builder.() -> Unit): PublishBatchResponse = publishBatch(PublishBatchRequest.Builder().apply(block).build())

/**
 * Adds or updates an inline policy document that is stored in the specified Amazon SNS topic.
 */
public suspend inline fun SnsClient.putDataProtectionPolicy(crossinline block: PutDataProtectionPolicyRequest.Builder.() -> Unit): PutDataProtectionPolicyResponse = putDataProtectionPolicy(PutDataProtectionPolicyRequest.Builder().apply(block).build())

/**
 * Removes a statement from a topic's access control policy.
 *
 * To remove the ability to change topic permissions, you must deny permissions to the `AddPermission`, `RemovePermission`, and `SetTopicAttributes` actions in your IAM policy.
 */
public suspend inline fun SnsClient.removePermission(crossinline block: RemovePermissionRequest.Builder.() -> Unit): RemovePermissionResponse = removePermission(RemovePermissionRequest.Builder().apply(block).build())

/**
 * Sets the attributes for an endpoint for a device on one of the supported push notification services, such as GCM (Firebase Cloud Messaging) and APNS. For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
 */
public suspend inline fun SnsClient.setEndpointAttributes(crossinline block: SetEndpointAttributesRequest.Builder.() -> Unit): SetEndpointAttributesResponse = setEndpointAttributes(SetEndpointAttributesRequest.Builder().apply(block).build())

/**
 * Sets the attributes of the platform application object for the supported push notification services, such as APNS and GCM (Firebase Cloud Messaging). For more information, see [Using Amazon SNS Mobile Push Notifications](https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html). For information on configuring attributes for message delivery status, see [Using Amazon SNS Application Attributes for Message Delivery Status](https://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html).
 */
public suspend inline fun SnsClient.setPlatformApplicationAttributes(crossinline block: SetPlatformApplicationAttributesRequest.Builder.() -> Unit): SetPlatformApplicationAttributesResponse = setPlatformApplicationAttributes(SetPlatformApplicationAttributesRequest.Builder().apply(block).build())

/**
 * Use this request to set the default settings for sending SMS messages and receiving daily SMS usage reports.
 *
 * You can override some of these settings for a single message when you use the `Publish` action with the `MessageAttributes.entry.N` parameter. For more information, see [Publishing to a mobile phone](https://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html) in the *Amazon SNS Developer Guide*.
 *
 * To use this operation, you must grant the Amazon SNS service principal (`sns.amazonaws.com`) permission to perform the `s3:ListBucket` action.
 */
public suspend inline fun SnsClient.setSmsAttributes(crossinline block: SetSmsAttributesRequest.Builder.() -> Unit): SetSmsAttributesResponse = setSmsAttributes(SetSmsAttributesRequest.Builder().apply(block).build())

/**
 * Allows a subscription owner to set an attribute of the subscription to a new value.
 */
public suspend inline fun SnsClient.setSubscriptionAttributes(crossinline block: SetSubscriptionAttributesRequest.Builder.() -> Unit): SetSubscriptionAttributesResponse = setSubscriptionAttributes(SetSubscriptionAttributesRequest.Builder().apply(block).build())

/**
 * Allows a topic owner to set an attribute of the topic to a new value.
 *
 * To remove the ability to change topic permissions, you must deny permissions to the `AddPermission`, `RemovePermission`, and `SetTopicAttributes` actions in your IAM policy.
 */
public suspend inline fun SnsClient.setTopicAttributes(crossinline block: SetTopicAttributesRequest.Builder.() -> Unit): SetTopicAttributesResponse = setTopicAttributes(SetTopicAttributesRequest.Builder().apply(block).build())

/**
 * Subscribes an endpoint to an Amazon SNS topic. If the endpoint type is HTTP/S or email, or if the endpoint and the topic are not in the same Amazon Web Services account, the endpoint owner must run the `ConfirmSubscription` action to confirm the subscription.
 *
 * You call the `ConfirmSubscription` action with the token from the subscription response. Confirmation tokens are valid for two days.
 *
 * This action is throttled at 100 transactions per second (TPS).
 */
public suspend inline fun SnsClient.subscribe(crossinline block: SubscribeRequest.Builder.() -> Unit): SubscribeResponse = subscribe(SubscribeRequest.Builder().apply(block).build())

/**
 * Add tags to the specified Amazon SNS topic. For an overview, see [Amazon SNS Tags](https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html) in the *Amazon SNS Developer Guide*.
 *
 * When you use topic tags, keep the following guidelines in mind:
 * + Adding more than 50 tags to a topic isn't recommended.
 * + Tags don't have any semantic meaning. Amazon SNS interprets tags as character strings.
 * + Tags are case-sensitive.
 * + A new tag with a key identical to that of an existing tag overwrites the existing tag.
 * + Tagging actions are limited to 10 TPS per Amazon Web Services account, per Amazon Web Services Region. If your application requires a higher throughput, file a [technical support request](https://console.aws.amazon.com/support/home#/case/create?issueType=technical).
 */
public suspend inline fun SnsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes a subscription. If the subscription requires authentication for deletion, only the owner of the subscription or the topic's owner can unsubscribe, and an Amazon Web Services signature is required. If the `Unsubscribe` call does not require authentication and the requester is not the subscription owner, a final cancellation message is delivered to the endpoint, so that the endpoint owner can easily resubscribe to the topic if the `Unsubscribe` request was unintended.
 *
 * Amazon SQS queue subscriptions require authentication for deletion. Only the owner of the subscription, or the owner of the topic can unsubscribe using the required Amazon Web Services signature.
 *
 * This action is throttled at 100 transactions per second (TPS).
 */
public suspend inline fun SnsClient.unsubscribe(crossinline block: UnsubscribeRequest.Builder.() -> Unit): UnsubscribeResponse = unsubscribe(UnsubscribeRequest.Builder().apply(block).build())

/**
 * Remove tags from the specified Amazon SNS topic. For an overview, see [Amazon SNS Tags](https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html) in the *Amazon SNS Developer Guide*.
 */
public suspend inline fun SnsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Verifies a destination phone number with a one-time password (OTP) for the calling Amazon Web Services account.
 *
 * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the *SMS sandbox*. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more information, including how to move out of the sandbox to send messages without restrictions, see [SMS sandbox](https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html) in the *Amazon SNS Developer Guide*.
 */
public suspend inline fun SnsClient.verifySmsSandboxPhoneNumber(crossinline block: VerifySmsSandboxPhoneNumberRequest.Builder.() -> Unit): VerifySmsSandboxPhoneNumberResponse = verifySmsSandboxPhoneNumber(VerifySmsSandboxPhoneNumberRequest.Builder().apply(block).build())
