// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.serde

import aws.sdk.kotlin.services.sns.model.SnsException
import aws.sdk.kotlin.services.sns.model.SubscribeResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class SubscribeOperationDeserializer: HttpDeserialize<SubscribeResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): SubscribeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSubscribeError(context, call)
        }
        val builder = SubscribeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSubscribeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwSubscribeError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw SnsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidSecurity" -> InvalidSecurityExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFound" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameter" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "FilterPolicyLimitExceeded" -> FilterPolicyLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "AuthorizationError" -> AuthorizationErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "SubscriptionLimitExceeded" -> SubscriptionLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalError" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SnsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSubscribeOperationBody(builder: SubscribeResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("SubscribeResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("SubscribeResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap Subscribe response")
    }
    // end unwrap response wrapper

    val SUBSCRIPTIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("SubscriptionArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://sns.amazonaws.com/doc/2010-03-31/"))
        trait(XmlSerialName("SubscribeResult"))
        field(SUBSCRIPTIONARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SUBSCRIPTIONARN_DESCRIPTOR.index -> builder.subscriptionArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
