// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.serde

import aws.sdk.kotlin.services.sns.model.MessageAttributeValue
import aws.sdk.kotlin.services.sns.model.PublishRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlMapName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PublishOperationSerializer: HttpSerialize<PublishRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PublishRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializePublishOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializePublishOperationBody(context: ExecutionContext, input: PublishRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Message"))
    val MESSAGEATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, FormUrlSerialName("MessageAttributes"), FormUrlMapName(key = "Name", value = "Value"))
    val MESSAGEDEDUPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MessageDeduplicationId"))
    val MESSAGEGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MessageGroupId"))
    val MESSAGESTRUCTURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MessageStructure"))
    val PHONENUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PhoneNumber"))
    val SUBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Subject"))
    val TARGETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TargetArn"))
    val TOPICARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TopicArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("PublishInput"))
        trait(QueryLiteral("Action", "Publish"))
        trait(QueryLiteral("Version", "2010-03-31"))
        field(MESSAGE_DESCRIPTOR)
        field(MESSAGEATTRIBUTES_DESCRIPTOR)
        field(MESSAGEDEDUPLICATIONID_DESCRIPTOR)
        field(MESSAGEGROUPID_DESCRIPTOR)
        field(MESSAGESTRUCTURE_DESCRIPTOR)
        field(PHONENUMBER_DESCRIPTOR)
        field(SUBJECT_DESCRIPTOR)
        field(TARGETARN_DESCRIPTOR)
        field(TOPICARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.message?.let { field(MESSAGE_DESCRIPTOR, it) }
        if (input.messageAttributes != null) {
            mapField(MESSAGEATTRIBUTES_DESCRIPTOR) {
                input.messageAttributes.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeMessageAttributeValueDocument)) }
            }
        }
        input.messageDeduplicationId?.let { field(MESSAGEDEDUPLICATIONID_DESCRIPTOR, it) }
        input.messageGroupId?.let { field(MESSAGEGROUPID_DESCRIPTOR, it) }
        input.messageStructure?.let { field(MESSAGESTRUCTURE_DESCRIPTOR, it) }
        input.phoneNumber?.let { field(PHONENUMBER_DESCRIPTOR, it) }
        input.subject?.let { field(SUBJECT_DESCRIPTOR, it) }
        input.targetArn?.let { field(TARGETARN_DESCRIPTOR, it) }
        input.topicArn?.let { field(TOPICARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
