// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.serde

import aws.sdk.kotlin.services.sns.model.OptInPhoneNumberResponse
import aws.sdk.kotlin.services.sns.model.SnsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class OptInPhoneNumberOperationDeserializer: HttpDeserialize<OptInPhoneNumberResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): OptInPhoneNumberResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwOptInPhoneNumberError(context, call)
        }
        val builder = OptInPhoneNumberResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwOptInPhoneNumberError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw SnsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameter" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "Throttled" -> ThrottledExceptionDeserializer().deserialize(context, wrappedCall)
        "AuthorizationError" -> AuthorizationErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalError" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SnsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
