// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.serde

import aws.sdk.kotlin.services.sns.model.Endpoint
import aws.sdk.kotlin.services.sns.model.ListEndpointsByPlatformApplicationResponse
import aws.sdk.kotlin.services.sns.model.SnsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class ListEndpointsByPlatformApplicationOperationDeserializer: HttpDeserialize<ListEndpointsByPlatformApplicationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListEndpointsByPlatformApplicationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListEndpointsByPlatformApplicationError(context, call)
        }
        val builder = ListEndpointsByPlatformApplicationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListEndpointsByPlatformApplicationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListEndpointsByPlatformApplicationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw SnsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFound" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameter" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "AuthorizationError" -> AuthorizationErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalError" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SnsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListEndpointsByPlatformApplicationOperationBody(builder: ListEndpointsByPlatformApplicationResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ListEndpointsByPlatformApplicationResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ListEndpointsByPlatformApplicationResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ListEndpointsByPlatformApplication response")
    }
    // end unwrap response wrapper

    val ENDPOINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Endpoints"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://sns.amazonaws.com/doc/2010-03-31/"))
        trait(XmlSerialName("ListEndpointsByPlatformApplicationResult"))
        field(ENDPOINTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDPOINTS_DESCRIPTOR.index -> builder.endpoints =
                    deserializer.deserializeList(ENDPOINTS_DESCRIPTOR) {
                        val col0 = mutableListOf<Endpoint>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEndpointDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
