// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.serde

import aws.sdk.kotlin.services.sns.model.AddPermissionResponse
import aws.sdk.kotlin.services.sns.model.SnsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class AddPermissionOperationDeserializer: HttpDeserialize<AddPermissionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): AddPermissionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAddPermissionError(context, call)
        }
        val builder = AddPermissionResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwAddPermissionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw SnsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFound" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameter" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedCall)
        "AuthorizationError" -> AuthorizationErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalError" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SnsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
