// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.model



/**
 * Input for SetPlatformApplicationAttributes action.
 */
public class SetPlatformApplicationAttributesRequest private constructor(builder: Builder) {
    /**
     * A map of the platform application attributes. Attributes in this map include the following:
     * + `PlatformCredential` – The credential received from the notification service.
     *    + For ADM, `PlatformCredential`is client secret.
     *    + For Apple Services using certificate credentials, `PlatformCredential` is private key.
     *    + For Apple Services using token credentials, `PlatformCredential` is signing key.
     *    + For GCM (Firebase Cloud Messaging), `PlatformCredential` is API key.
     *
     * + `PlatformPrincipal` – The principal received from the notification service.
     *    + For ADM, `PlatformPrincipal`is client id.
     *    + For Apple Services using certificate credentials, `PlatformPrincipal` is SSL certificate.
     *    + For Apple Services using token credentials, `PlatformPrincipal` is signing key ID.
     *    + For GCM (Firebase Cloud Messaging), there is no `PlatformPrincipal`.
     *
     * + `EventEndpointCreated` – Topic ARN to which `EndpointCreated` event notifications are sent.
     * + `EventEndpointDeleted` – Topic ARN to which `EndpointDeleted` event notifications are sent.
     * + `EventEndpointUpdated` – Topic ARN to which `EndpointUpdate` event notifications are sent.
     * + `EventDeliveryFailure` – Topic ARN to which `DeliveryFailure` event notifications are sent upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
     * + `SuccessFeedbackRoleArn` – IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs on your behalf.
     * + `FailureFeedbackRoleArn` – IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs on your behalf.
     * + `SuccessFeedbackSampleRate` – Sample rate percentage (0-100) of successfully delivered messages.
     *
     * The following attributes only apply to `APNs` token-based authentication:
     * + `ApplePlatformTeamID` – The identifier that's assigned to your Apple developer account team.
     * + `ApplePlatformBundleID` – The bundle identifier that's assigned to your iOS app.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * PlatformApplicationArn for SetPlatformApplicationAttributes action.
     */
    public val platformApplicationArn: kotlin.String? = builder.platformApplicationArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sns.model.SetPlatformApplicationAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetPlatformApplicationAttributesRequest(")
        append("attributes=$attributes,")
        append("platformApplicationArn=$platformApplicationArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (platformApplicationArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetPlatformApplicationAttributesRequest

        if (attributes != other.attributes) return false
        if (platformApplicationArn != other.platformApplicationArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sns.model.SetPlatformApplicationAttributesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A map of the platform application attributes. Attributes in this map include the following:
         * + `PlatformCredential` – The credential received from the notification service.
         *    + For ADM, `PlatformCredential`is client secret.
         *    + For Apple Services using certificate credentials, `PlatformCredential` is private key.
         *    + For Apple Services using token credentials, `PlatformCredential` is signing key.
         *    + For GCM (Firebase Cloud Messaging), `PlatformCredential` is API key.
         *
         * + `PlatformPrincipal` – The principal received from the notification service.
         *    + For ADM, `PlatformPrincipal`is client id.
         *    + For Apple Services using certificate credentials, `PlatformPrincipal` is SSL certificate.
         *    + For Apple Services using token credentials, `PlatformPrincipal` is signing key ID.
         *    + For GCM (Firebase Cloud Messaging), there is no `PlatformPrincipal`.
         *
         * + `EventEndpointCreated` – Topic ARN to which `EndpointCreated` event notifications are sent.
         * + `EventEndpointDeleted` – Topic ARN to which `EndpointDeleted` event notifications are sent.
         * + `EventEndpointUpdated` – Topic ARN to which `EndpointUpdate` event notifications are sent.
         * + `EventDeliveryFailure` – Topic ARN to which `DeliveryFailure` event notifications are sent upon Direct Publish delivery failure (permanent) to one of the application's endpoints.
         * + `SuccessFeedbackRoleArn` – IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs on your behalf.
         * + `FailureFeedbackRoleArn` – IAM role ARN used to give Amazon SNS write access to use CloudWatch Logs on your behalf.
         * + `SuccessFeedbackSampleRate` – Sample rate percentage (0-100) of successfully delivered messages.
         *
         * The following attributes only apply to `APNs` token-based authentication:
         * + `ApplePlatformTeamID` – The identifier that's assigned to your Apple developer account team.
         * + `ApplePlatformBundleID` – The bundle identifier that's assigned to your iOS app.
         */
        public var attributes: Map<String, String>? = null
        /**
         * PlatformApplicationArn for SetPlatformApplicationAttributes action.
         */
        public var platformApplicationArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sns.model.SetPlatformApplicationAttributesRequest) : this() {
            this.attributes = x.attributes
            this.platformApplicationArn = x.platformApplicationArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sns.model.SetPlatformApplicationAttributesRequest = SetPlatformApplicationAttributesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
