// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.model



/**
 * Input for SetEndpointAttributes action.
 */
public class SetEndpointAttributesRequest private constructor(builder: Builder) {
    /**
     * A map of the endpoint attributes. Attributes in this map include the following:
     * + `CustomUserData` – arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and less than 2KB.
     * + `Enabled` – flag that enables/disables delivery to the endpoint. Amazon SNS will set this to false when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can set it back to true, typically after updating Token.
     * + `Token` – device token, also referred to as a registration id, for an app and mobile device. This is returned from the notification service when an app and mobile device are registered with the notification service.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * EndpointArn used for SetEndpointAttributes action.
     */
    public val endpointArn: kotlin.String? = builder.endpointArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sns.model.SetEndpointAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SetEndpointAttributesRequest(")
        append("attributes=$attributes,")
        append("endpointArn=$endpointArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (endpointArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SetEndpointAttributesRequest

        if (attributes != other.attributes) return false
        if (endpointArn != other.endpointArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sns.model.SetEndpointAttributesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A map of the endpoint attributes. Attributes in this map include the following:
         * + `CustomUserData` – arbitrary user data to associate with the endpoint. Amazon SNS does not use this data. The data must be in UTF-8 format and less than 2KB.
         * + `Enabled` – flag that enables/disables delivery to the endpoint. Amazon SNS will set this to false when a notification service indicates to Amazon SNS that the endpoint is invalid. Users can set it back to true, typically after updating Token.
         * + `Token` – device token, also referred to as a registration id, for an app and mobile device. This is returned from the notification service when an app and mobile device are registered with the notification service.
         */
        public var attributes: Map<String, String>? = null
        /**
         * EndpointArn used for SetEndpointAttributes action.
         */
        public var endpointArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sns.model.SetEndpointAttributesRequest) : this() {
            this.attributes = x.attributes
            this.endpointArn = x.endpointArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sns.model.SetEndpointAttributesRequest = SetEndpointAttributesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
