// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.model



/**
 * The user-specified message attribute value. For string data types, the value attribute has the same restrictions on the content as the message body. For more information, see [Publish](https://docs.aws.amazon.com/sns/latest/api/API_Publish.html).
 *
 * Name, type, and value must not be empty or null. In addition, the message body should not be empty or null. All parts of the message attribute, including name, type, and value, are included in the message size restriction, which is currently 256 KB (262,144 bytes). For more information, see [Amazon SNS message attributes](https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html) and [Publishing to a mobile phone](https://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html) in the *Amazon SNS Developer Guide.*
 */
public class MessageAttributeValue private constructor(builder: Builder) {
    /**
     * Binary type attributes can store any binary data, for example, compressed data, encrypted data, or images.
     */
    public val binaryValue: kotlin.ByteArray? = builder.binaryValue
    /**
     * Amazon SNS supports the following logical data types: String, String.Array, Number, and Binary. For more information, see [Message Attribute Data Types](https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html#SNSMessageAttributes.DataTypes).
     */
    public val dataType: kotlin.String = requireNotNull(builder.dataType) { "A non-null value must be provided for dataType" }
    /**
     * Strings are Unicode with UTF8 binary encoding. For a list of code values, see [ASCII Printable Characters](https://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
     */
    public val stringValue: kotlin.String? = builder.stringValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sns.model.MessageAttributeValue = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MessageAttributeValue(")
        append("binaryValue=$binaryValue,")
        append("dataType=$dataType,")
        append("stringValue=$stringValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = binaryValue?.contentHashCode() ?: 0
        result = 31 * result + (dataType.hashCode())
        result = 31 * result + (stringValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MessageAttributeValue

        if (binaryValue != null) {
            if (other.binaryValue == null) return false
            if (!binaryValue.contentEquals(other.binaryValue)) return false
        } else if (other.binaryValue != null) return false
        if (dataType != other.dataType) return false
        if (stringValue != other.stringValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sns.model.MessageAttributeValue = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Binary type attributes can store any binary data, for example, compressed data, encrypted data, or images.
         */
        public var binaryValue: kotlin.ByteArray? = null
        /**
         * Amazon SNS supports the following logical data types: String, String.Array, Number, and Binary. For more information, see [Message Attribute Data Types](https://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html#SNSMessageAttributes.DataTypes).
         */
        public var dataType: kotlin.String? = null
        /**
         * Strings are Unicode with UTF8 binary encoding. For a list of code values, see [ASCII Printable Characters](https://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
         */
        public var stringValue: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sns.model.MessageAttributeValue) : this() {
            this.binaryValue = x.binaryValue
            this.dataType = x.dataType
            this.stringValue = x.stringValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sns.model.MessageAttributeValue = MessageAttributeValue(this)

        internal fun correctErrors(): Builder {
            if (dataType == null) dataType = ""
            return this
        }
    }
}
