// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sns.model



/**
 * Input for CreateTopic action.
 */
public class CreateTopicRequest private constructor(builder: Builder) {
    /**
     * A map of attributes with their corresponding values.
     *
     * The following lists the names, descriptions, and values of the special request parameters that the `CreateTopic` action uses:
     * + `DeliveryPolicy` – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.
     * + `DisplayName` – The display name to use for a topic with SMS subscriptions.
     * + `FifoTopic` – Set to true to create a FIFO topic.
     * + `Policy` – The policy that defines who can access your topic. By default, only the topic owner can publish or subscribe to the topic.
     * + `SignatureVersion` – The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS. By default, `SignatureVersion` is set to `1`.
     * + `TracingConfig` – Tracing mode of an Amazon SNS topic. By default `TracingConfig` is set to `PassThrough`, and the topic passes through the tracing header it receives from an Amazon SNS publisher to its subscriptions. If set to `Active`, Amazon SNS will vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true. This is only supported on standard topics.
     *
     * The following attribute applies only to [server-side encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html):
     * + `KmsMasterKeyId` – The ID of an Amazon Web Services managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms). For more examples, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the *Key Management Service API Reference*.
     *
     * The following attributes apply only to [FIFO topics](https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html):
     * + `FifoTopic` – When this is set to `true`, a FIFO topic is created.
     * + `ContentBasedDeduplication` – Enables content-based deduplication for FIFO topics.
     *    + By default, `ContentBasedDeduplication` is set to `false`. If you create a FIFO topic and this attribute is `false`, you must specify a value for the `MessageDeduplicationId` parameter for the [Publish](https://docs.aws.amazon.com/sns/latest/api/API_Publish.html) action.
     *    + When you set `ContentBasedDeduplication` to `true`, Amazon SNS uses a SHA-256 hash to generate the `MessageDeduplicationId` using the body of the message (but not the attributes of the message).(Optional) To override the generated value, you can specify a value for the `MessageDeduplicationId` parameter for the `Publish` action.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * The body of the policy document you want to use for this topic.
     *
     * You can only add one policy per topic.
     *
     * The policy must be in JSON string format.
     *
     * Length Constraints: Maximum length of 30,720.
     */
    public val dataProtectionPolicy: kotlin.String? = builder.dataProtectionPolicy
    /**
     * The name of the topic you want to create.
     *
     * Constraints: Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long.
     *
     * For a FIFO (first-in-first-out) topic, the name must end with the `.fifo` suffix.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The list of tags to add to a new topic.
     *
     * To be able to tag a topic on creation, you must have the `sns:CreateTopic` and `sns:TagResource` permissions.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sns.model.CreateTopicRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTopicRequest(")
        append("attributes=$attributes,")
        append("dataProtectionPolicy=$dataProtectionPolicy,")
        append("name=$name,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (dataProtectionPolicy?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTopicRequest

        if (attributes != other.attributes) return false
        if (dataProtectionPolicy != other.dataProtectionPolicy) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sns.model.CreateTopicRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A map of attributes with their corresponding values.
         *
         * The following lists the names, descriptions, and values of the special request parameters that the `CreateTopic` action uses:
         * + `DeliveryPolicy` – The policy that defines how Amazon SNS retries failed deliveries to HTTP/S endpoints.
         * + `DisplayName` – The display name to use for a topic with SMS subscriptions.
         * + `FifoTopic` – Set to true to create a FIFO topic.
         * + `Policy` – The policy that defines who can access your topic. By default, only the topic owner can publish or subscribe to the topic.
         * + `SignatureVersion` – The signature version corresponds to the hashing algorithm used while creating the signature of the notifications, subscription confirmations, or unsubscribe confirmation messages sent by Amazon SNS. By default, `SignatureVersion` is set to `1`.
         * + `TracingConfig` – Tracing mode of an Amazon SNS topic. By default `TracingConfig` is set to `PassThrough`, and the topic passes through the tracing header it receives from an Amazon SNS publisher to its subscriptions. If set to `Active`, Amazon SNS will vend X-Ray segment data to topic owner account if the sampled flag in the tracing header is true. This is only supported on standard topics.
         *
         * The following attribute applies only to [server-side encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html):
         * + `KmsMasterKeyId` – The ID of an Amazon Web Services managed customer master key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms](https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms). For more examples, see [KeyId](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the *Key Management Service API Reference*.
         *
         * The following attributes apply only to [FIFO topics](https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html):
         * + `FifoTopic` – When this is set to `true`, a FIFO topic is created.
         * + `ContentBasedDeduplication` – Enables content-based deduplication for FIFO topics.
         *    + By default, `ContentBasedDeduplication` is set to `false`. If you create a FIFO topic and this attribute is `false`, you must specify a value for the `MessageDeduplicationId` parameter for the [Publish](https://docs.aws.amazon.com/sns/latest/api/API_Publish.html) action.
         *    + When you set `ContentBasedDeduplication` to `true`, Amazon SNS uses a SHA-256 hash to generate the `MessageDeduplicationId` using the body of the message (but not the attributes of the message).(Optional) To override the generated value, you can specify a value for the `MessageDeduplicationId` parameter for the `Publish` action.
         */
        public var attributes: Map<String, String>? = null
        /**
         * The body of the policy document you want to use for this topic.
         *
         * You can only add one policy per topic.
         *
         * The policy must be in JSON string format.
         *
         * Length Constraints: Maximum length of 30,720.
         */
        public var dataProtectionPolicy: kotlin.String? = null
        /**
         * The name of the topic you want to create.
         *
         * Constraints: Topic names must be made up of only uppercase and lowercase ASCII letters, numbers, underscores, and hyphens, and must be between 1 and 256 characters long.
         *
         * For a FIFO (first-in-first-out) topic, the name must end with the `.fifo` suffix.
         */
        public var name: kotlin.String? = null
        /**
         * The list of tags to add to a new topic.
         *
         * To be able to tag a topic on creation, you must have the `sns:CreateTopic` and `sns:TagResource` permissions.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sns.model.CreateTopicRequest) : this() {
            this.attributes = x.attributes
            this.dataProtectionPolicy = x.dataProtectionPolicy
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sns.model.CreateTopicRequest = CreateTopicRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
