// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowdevicemanagement.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.snowdevicemanagement.model.CreateTaskResponse
import aws.sdk.kotlin.services.snowdevicemanagement.model.SnowDeviceManagementException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateTaskOperationDeserializer: HttpDeserialize<CreateTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateTaskResponse {
        if (!response.status.isSuccess()) {
            throwCreateTaskError(context, response)
        }
        val builder = CreateTaskResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateTaskOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeCreateTaskOperationBody(builder: CreateTaskResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TASKARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("taskArn"))
    val TASKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("taskId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TASKARN_DESCRIPTOR)
        field(TASKID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TASKARN_DESCRIPTOR.index -> builder.taskArn = deserializeString()
                TASKID_DESCRIPTOR.index -> builder.taskId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateTaskError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "InternalServerException" -> InternalServerExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw SnowDeviceManagementException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
