// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowdevicemanagement.model



class ListDeviceResourcesRequest private constructor(builder: BuilderImpl) {
    /**
     * The ID of the managed device that you are listing the resources of.
     */
    val managedDeviceId: String? = builder.managedDeviceId
    /**
     * The maximum number of resources per page.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * A pagination token to continue to the next page of results.
     */
    val nextToken: String? = builder.nextToken
    /**
     * A structure used to filter the results by type of resource.
     */
    val type: String? = builder.type

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ListDeviceResourcesRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ListDeviceResourcesRequest(")
        append("managedDeviceId=$managedDeviceId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = managedDeviceId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ListDeviceResourcesRequest

        if (managedDeviceId != other.managedDeviceId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (type != other.type) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ListDeviceResourcesRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ListDeviceResourcesRequest
        /**
         * The ID of the managed device that you are listing the resources of.
         */
        fun managedDeviceId(managedDeviceId: String): FluentBuilder
        /**
         * The maximum number of resources per page.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * A pagination token to continue to the next page of results.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * A structure used to filter the results by type of resource.
         */
        fun type(type: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the managed device that you are listing the resources of.
         */
        var managedDeviceId: String?
        /**
         * The maximum number of resources per page.
         */
        var maxResults: Int?
        /**
         * A pagination token to continue to the next page of results.
         */
        var nextToken: String?
        /**
         * A structure used to filter the results by type of resource.
         */
        var type: String?

        fun build(): ListDeviceResourcesRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var managedDeviceId: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var type: String? = null

        constructor(x: ListDeviceResourcesRequest) : this() {
            this.managedDeviceId = x.managedDeviceId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.type = x.type
        }

        override fun build(): ListDeviceResourcesRequest = ListDeviceResourcesRequest(this)
        override fun managedDeviceId(managedDeviceId: String): FluentBuilder = apply { this.managedDeviceId = managedDeviceId }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun type(type: String): FluentBuilder = apply { this.type = type }
    }
}
