// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowdevicemanagement.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The description of an
 * instance.
 * Currently, Amazon EC2 instances are the only supported instance type.
 */
class Instance private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Machine Image (AMI) launch index, which you can use to find this instance in
     * the launch group.
     */
    val amiLaunchIndex: Int? = builder.amiLaunchIndex
    /**
     * Any block device mapping entries for the instance.
     */
    val blockDeviceMappings: List<InstanceBlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * The CPU options for the instance.
     */
    val cpuOptions: CpuOptions? = builder.cpuOptions
    /**
     * When the instance was created.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The ID of the AMI used to launch the instance.
     */
    val imageId: String? = builder.imageId
    /**
     * The ID of the instance.
     */
    val instanceId: String? = builder.instanceId
    /**
     * The instance type.
     */
    val instanceType: String? = builder.instanceType
    /**
     * The private IPv4 address assigned to the instance.
     */
    val privateIpAddress: String? = builder.privateIpAddress
    /**
     * The public IPv4 address assigned to the instance.
     */
    val publicIpAddress: String? = builder.publicIpAddress
    /**
     * The device name of the root device volume (for example, /dev/sda1).
     */
    val rootDeviceName: String? = builder.rootDeviceName
    /**
     * The security groups for the instance.
     */
    val securityGroups: List<SecurityGroupIdentifier>? = builder.securityGroups
    /**
     * The description of the current state of an instance.
     */
    val state: InstanceState? = builder.state
    /**
     * When the instance was last updated.
     */
    val updatedAt: Instant? = builder.updatedAt

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Instance = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Instance(")
        append("amiLaunchIndex=$amiLaunchIndex,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("cpuOptions=$cpuOptions,")
        append("createdAt=$createdAt,")
        append("imageId=$imageId,")
        append("instanceId=$instanceId,")
        append("instanceType=$instanceType,")
        append("privateIpAddress=$privateIpAddress,")
        append("publicIpAddress=$publicIpAddress,")
        append("rootDeviceName=$rootDeviceName,")
        append("securityGroups=$securityGroups,")
        append("state=$state,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amiLaunchIndex ?: 0
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (cpuOptions?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (publicIpAddress?.hashCode() ?: 0)
        result = 31 * result + (rootDeviceName?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Instance

        if (amiLaunchIndex != other.amiLaunchIndex) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (cpuOptions != other.cpuOptions) return false
        if (createdAt != other.createdAt) return false
        if (imageId != other.imageId) return false
        if (instanceId != other.instanceId) return false
        if (instanceType != other.instanceType) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (publicIpAddress != other.publicIpAddress) return false
        if (rootDeviceName != other.rootDeviceName) return false
        if (securityGroups != other.securityGroups) return false
        if (state != other.state) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Instance = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Instance
        /**
         * The Amazon Machine Image (AMI) launch index, which you can use to find this instance in
         * the launch group.
         */
        fun amiLaunchIndex(amiLaunchIndex: Int): FluentBuilder
        /**
         * Any block device mapping entries for the instance.
         */
        fun blockDeviceMappings(blockDeviceMappings: List<InstanceBlockDeviceMapping>): FluentBuilder
        /**
         * The CPU options for the instance.
         */
        fun cpuOptions(cpuOptions: CpuOptions): FluentBuilder
        /**
         * When the instance was created.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The ID of the AMI used to launch the instance.
         */
        fun imageId(imageId: String): FluentBuilder
        /**
         * The ID of the instance.
         */
        fun instanceId(instanceId: String): FluentBuilder
        /**
         * The instance type.
         */
        fun instanceType(instanceType: String): FluentBuilder
        /**
         * The private IPv4 address assigned to the instance.
         */
        fun privateIpAddress(privateIpAddress: String): FluentBuilder
        /**
         * The public IPv4 address assigned to the instance.
         */
        fun publicIpAddress(publicIpAddress: String): FluentBuilder
        /**
         * The device name of the root device volume (for example, /dev/sda1).
         */
        fun rootDeviceName(rootDeviceName: String): FluentBuilder
        /**
         * The security groups for the instance.
         */
        fun securityGroups(securityGroups: List<SecurityGroupIdentifier>): FluentBuilder
        /**
         * The description of the current state of an instance.
         */
        fun state(state: InstanceState): FluentBuilder
        /**
         * When the instance was last updated.
         */
        fun updatedAt(updatedAt: Instant): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Machine Image (AMI) launch index, which you can use to find this instance in
         * the launch group.
         */
        var amiLaunchIndex: Int?
        /**
         * Any block device mapping entries for the instance.
         */
        var blockDeviceMappings: List<InstanceBlockDeviceMapping>?
        /**
         * The CPU options for the instance.
         */
        var cpuOptions: CpuOptions?
        /**
         * When the instance was created.
         */
        var createdAt: Instant?
        /**
         * The ID of the AMI used to launch the instance.
         */
        var imageId: String?
        /**
         * The ID of the instance.
         */
        var instanceId: String?
        /**
         * The instance type.
         */
        var instanceType: String?
        /**
         * The private IPv4 address assigned to the instance.
         */
        var privateIpAddress: String?
        /**
         * The public IPv4 address assigned to the instance.
         */
        var publicIpAddress: String?
        /**
         * The device name of the root device volume (for example, /dev/sda1).
         */
        var rootDeviceName: String?
        /**
         * The security groups for the instance.
         */
        var securityGroups: List<SecurityGroupIdentifier>?
        /**
         * The description of the current state of an instance.
         */
        var state: InstanceState?
        /**
         * When the instance was last updated.
         */
        var updatedAt: Instant?

        fun build(): Instance
        /**
         * construct an [aws.sdk.kotlin.services.snowdevicemanagement.model.CpuOptions] inside the given [block]
         */
        fun cpuOptions(block: CpuOptions.DslBuilder.() -> kotlin.Unit) {
            this.cpuOptions = CpuOptions.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.snowdevicemanagement.model.InstanceState] inside the given [block]
         */
        fun state(block: InstanceState.DslBuilder.() -> kotlin.Unit) {
            this.state = InstanceState.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var amiLaunchIndex: Int? = null
        override var blockDeviceMappings: List<InstanceBlockDeviceMapping>? = null
        override var cpuOptions: CpuOptions? = null
        override var createdAt: Instant? = null
        override var imageId: String? = null
        override var instanceId: String? = null
        override var instanceType: String? = null
        override var privateIpAddress: String? = null
        override var publicIpAddress: String? = null
        override var rootDeviceName: String? = null
        override var securityGroups: List<SecurityGroupIdentifier>? = null
        override var state: InstanceState? = null
        override var updatedAt: Instant? = null

        constructor(x: Instance) : this() {
            this.amiLaunchIndex = x.amiLaunchIndex
            this.blockDeviceMappings = x.blockDeviceMappings
            this.cpuOptions = x.cpuOptions
            this.createdAt = x.createdAt
            this.imageId = x.imageId
            this.instanceId = x.instanceId
            this.instanceType = x.instanceType
            this.privateIpAddress = x.privateIpAddress
            this.publicIpAddress = x.publicIpAddress
            this.rootDeviceName = x.rootDeviceName
            this.securityGroups = x.securityGroups
            this.state = x.state
            this.updatedAt = x.updatedAt
        }

        override fun build(): Instance = Instance(this)
        override fun amiLaunchIndex(amiLaunchIndex: Int): FluentBuilder = apply { this.amiLaunchIndex = amiLaunchIndex }
        override fun blockDeviceMappings(blockDeviceMappings: List<InstanceBlockDeviceMapping>): FluentBuilder = apply { this.blockDeviceMappings = blockDeviceMappings }
        override fun cpuOptions(cpuOptions: CpuOptions): FluentBuilder = apply { this.cpuOptions = cpuOptions }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun imageId(imageId: String): FluentBuilder = apply { this.imageId = imageId }
        override fun instanceId(instanceId: String): FluentBuilder = apply { this.instanceId = instanceId }
        override fun instanceType(instanceType: String): FluentBuilder = apply { this.instanceType = instanceType }
        override fun privateIpAddress(privateIpAddress: String): FluentBuilder = apply { this.privateIpAddress = privateIpAddress }
        override fun publicIpAddress(publicIpAddress: String): FluentBuilder = apply { this.publicIpAddress = publicIpAddress }
        override fun rootDeviceName(rootDeviceName: String): FluentBuilder = apply { this.rootDeviceName = rootDeviceName }
        override fun securityGroups(securityGroups: List<SecurityGroupIdentifier>): FluentBuilder = apply { this.securityGroups = securityGroups }
        override fun state(state: InstanceState): FluentBuilder = apply { this.state = state }
        override fun updatedAt(updatedAt: Instant): FluentBuilder = apply { this.updatedAt = updatedAt }
    }
}
