// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowdevicemanagement.model



/**
 * Identifying information about the device.
 */
class DeviceSummary private constructor(builder: BuilderImpl) {
    /**
     * The ID of the job used to order the device.
     */
    val associatedWithJob: String? = builder.associatedWithJob
    /**
     * The Amazon Resource Name (ARN) of the device.
     */
    val managedDeviceArn: String? = builder.managedDeviceArn
    /**
     * The ID of the device.
     */
    val managedDeviceId: String? = builder.managedDeviceId
    /**
     * Optional metadata that you assign to a resource. You can use tags to categorize a resource
     * in different ways, such as by purpose, owner, or environment.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DeviceSummary = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DeviceSummary(")
        append("associatedWithJob=$associatedWithJob,")
        append("managedDeviceArn=$managedDeviceArn,")
        append("managedDeviceId=$managedDeviceId,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedWithJob?.hashCode() ?: 0
        result = 31 * result + (managedDeviceArn?.hashCode() ?: 0)
        result = 31 * result + (managedDeviceId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DeviceSummary

        if (associatedWithJob != other.associatedWithJob) return false
        if (managedDeviceArn != other.managedDeviceArn) return false
        if (managedDeviceId != other.managedDeviceId) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DeviceSummary = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DeviceSummary
        /**
         * The ID of the job used to order the device.
         */
        fun associatedWithJob(associatedWithJob: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the device.
         */
        fun managedDeviceArn(managedDeviceArn: String): FluentBuilder
        /**
         * The ID of the device.
         */
        fun managedDeviceId(managedDeviceId: String): FluentBuilder
        /**
         * Optional metadata that you assign to a resource. You can use tags to categorize a resource
         * in different ways, such as by purpose, owner, or environment.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the job used to order the device.
         */
        var associatedWithJob: String?
        /**
         * The Amazon Resource Name (ARN) of the device.
         */
        var managedDeviceArn: String?
        /**
         * The ID of the device.
         */
        var managedDeviceId: String?
        /**
         * Optional metadata that you assign to a resource. You can use tags to categorize a resource
         * in different ways, such as by purpose, owner, or environment.
         */
        var tags: Map<String, String>?

        fun build(): DeviceSummary
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associatedWithJob: String? = null
        override var managedDeviceArn: String? = null
        override var managedDeviceId: String? = null
        override var tags: Map<String, String>? = null

        constructor(x: DeviceSummary) : this() {
            this.associatedWithJob = x.associatedWithJob
            this.managedDeviceArn = x.managedDeviceArn
            this.managedDeviceId = x.managedDeviceId
            this.tags = x.tags
        }

        override fun build(): DeviceSummary = DeviceSummary(this)
        override fun associatedWithJob(associatedWithJob: String): FluentBuilder = apply { this.associatedWithJob = associatedWithJob }
        override fun managedDeviceArn(managedDeviceArn: String): FluentBuilder = apply { this.managedDeviceArn = managedDeviceArn }
        override fun managedDeviceId(managedDeviceId: String): FluentBuilder = apply { this.managedDeviceId = managedDeviceId }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
