// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowdevicemanagement.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeTaskResponse private constructor(builder: BuilderImpl) {
    /**
     * When the task was completed.
     */
    val completedAt: Instant? = builder.completedAt
    /**
     * When the CreateTask operation was called.
     */
    val createdAt: Instant? = builder.createdAt
    /**
     * The description provided of the task and managed devices.
     */
    val description: String? = builder.description
    /**
     * When the state of the task was last updated.
     */
    val lastUpdatedAt: Instant? = builder.lastUpdatedAt
    /**
     * The current state of the task.
     */
    val state: TaskState? = builder.state
    /**
     * Optional metadata that you assign to a resource. You can use tags to categorize a resource
     * in different ways, such as by purpose, owner, or environment.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The managed devices that the task was sent to.
     */
    val targets: List<String>? = builder.targets
    /**
     * The Amazon Resource Name (ARN) of the task.
     */
    val taskArn: String? = builder.taskArn
    /**
     * The ID of the task.
     */
    val taskId: String? = builder.taskId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeTaskResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTaskResponse(")
        append("completedAt=$completedAt,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("state=$state,")
        append("tags=$tags,")
        append("targets=$targets,")
        append("taskArn=$taskArn,")
        append("taskId=$taskId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = completedAt?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (taskId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeTaskResponse

        if (completedAt != other.completedAt) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (targets != other.targets) return false
        if (taskArn != other.taskArn) return false
        if (taskId != other.taskId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeTaskResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeTaskResponse
        /**
         * When the task was completed.
         */
        fun completedAt(completedAt: Instant): FluentBuilder
        /**
         * When the CreateTask operation was called.
         */
        fun createdAt(createdAt: Instant): FluentBuilder
        /**
         * The description provided of the task and managed devices.
         */
        fun description(description: String): FluentBuilder
        /**
         * When the state of the task was last updated.
         */
        fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder
        /**
         * The current state of the task.
         */
        fun state(state: TaskState): FluentBuilder
        /**
         * Optional metadata that you assign to a resource. You can use tags to categorize a resource
         * in different ways, such as by purpose, owner, or environment.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
        /**
         * The managed devices that the task was sent to.
         */
        fun targets(targets: List<String>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the task.
         */
        fun taskArn(taskArn: String): FluentBuilder
        /**
         * The ID of the task.
         */
        fun taskId(taskId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * When the task was completed.
         */
        var completedAt: Instant?
        /**
         * When the CreateTask operation was called.
         */
        var createdAt: Instant?
        /**
         * The description provided of the task and managed devices.
         */
        var description: String?
        /**
         * When the state of the task was last updated.
         */
        var lastUpdatedAt: Instant?
        /**
         * The current state of the task.
         */
        var state: TaskState?
        /**
         * Optional metadata that you assign to a resource. You can use tags to categorize a resource
         * in different ways, such as by purpose, owner, or environment.
         */
        var tags: Map<String, String>?
        /**
         * The managed devices that the task was sent to.
         */
        var targets: List<String>?
        /**
         * The Amazon Resource Name (ARN) of the task.
         */
        var taskArn: String?
        /**
         * The ID of the task.
         */
        var taskId: String?

        fun build(): DescribeTaskResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var completedAt: Instant? = null
        override var createdAt: Instant? = null
        override var description: String? = null
        override var lastUpdatedAt: Instant? = null
        override var state: TaskState? = null
        override var tags: Map<String, String>? = null
        override var targets: List<String>? = null
        override var taskArn: String? = null
        override var taskId: String? = null

        constructor(x: DescribeTaskResponse) : this() {
            this.completedAt = x.completedAt
            this.createdAt = x.createdAt
            this.description = x.description
            this.lastUpdatedAt = x.lastUpdatedAt
            this.state = x.state
            this.tags = x.tags
            this.targets = x.targets
            this.taskArn = x.taskArn
            this.taskId = x.taskId
        }

        override fun build(): DescribeTaskResponse = DescribeTaskResponse(this)
        override fun completedAt(completedAt: Instant): FluentBuilder = apply { this.completedAt = completedAt }
        override fun createdAt(createdAt: Instant): FluentBuilder = apply { this.createdAt = createdAt }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder = apply { this.lastUpdatedAt = lastUpdatedAt }
        override fun state(state: TaskState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
        override fun targets(targets: List<String>): FluentBuilder = apply { this.targets = targets }
        override fun taskArn(taskArn: String): FluentBuilder = apply { this.taskArn = taskArn }
        override fun taskId(taskId: String): FluentBuilder = apply { this.taskId = taskId }
    }
}
