// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowdevicemanagement.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeDeviceResponse private constructor(builder: BuilderImpl) {
    /**
     * The ID of the job used when ordering the device.
     */
    val associatedWithJob: String? = builder.associatedWithJob
    /**
     * The hardware specifications of the device.
     */
    val deviceCapacities: List<Capacity>? = builder.deviceCapacities
    /**
     * The current state of the device.
     */
    val deviceState: UnlockState? = builder.deviceState
    /**
     * The type of Amazon Web Services Snow Family device.
     */
    val deviceType: String? = builder.deviceType
    /**
     * When the device last contacted the Amazon Web Services Cloud. Indicates that the device is
     * online.
     */
    val lastReachedOutAt: Instant? = builder.lastReachedOutAt
    /**
     * When the device last pushed an update to the Amazon Web Services Cloud. Indicates when the device cache
     * was refreshed.
     */
    val lastUpdatedAt: Instant? = builder.lastUpdatedAt
    /**
     * The Amazon Resource Name (ARN) of the device.
     */
    val managedDeviceArn: String? = builder.managedDeviceArn
    /**
     * The ID of the device that you checked the information for.
     */
    val managedDeviceId: String? = builder.managedDeviceId
    /**
     * The network interfaces available on the device.
     */
    val physicalNetworkInterfaces: List<PhysicalNetworkInterface>? = builder.physicalNetworkInterfaces
    /**
     * The software installed on the device.
     */
    val software: SoftwareInformation? = builder.software
    /**
     * Optional metadata that you assign to a resource. You can use tags to categorize a resource
     * in different ways, such as by purpose, owner, or environment.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeDeviceResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDeviceResponse(")
        append("associatedWithJob=$associatedWithJob,")
        append("deviceCapacities=$deviceCapacities,")
        append("deviceState=$deviceState,")
        append("deviceType=$deviceType,")
        append("lastReachedOutAt=$lastReachedOutAt,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("managedDeviceArn=$managedDeviceArn,")
        append("managedDeviceId=$managedDeviceId,")
        append("physicalNetworkInterfaces=$physicalNetworkInterfaces,")
        append("software=$software,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associatedWithJob?.hashCode() ?: 0
        result = 31 * result + (deviceCapacities?.hashCode() ?: 0)
        result = 31 * result + (deviceState?.hashCode() ?: 0)
        result = 31 * result + (deviceType?.hashCode() ?: 0)
        result = 31 * result + (lastReachedOutAt?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (managedDeviceArn?.hashCode() ?: 0)
        result = 31 * result + (managedDeviceId?.hashCode() ?: 0)
        result = 31 * result + (physicalNetworkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (software?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeDeviceResponse

        if (associatedWithJob != other.associatedWithJob) return false
        if (deviceCapacities != other.deviceCapacities) return false
        if (deviceState != other.deviceState) return false
        if (deviceType != other.deviceType) return false
        if (lastReachedOutAt != other.lastReachedOutAt) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (managedDeviceArn != other.managedDeviceArn) return false
        if (managedDeviceId != other.managedDeviceId) return false
        if (physicalNetworkInterfaces != other.physicalNetworkInterfaces) return false
        if (software != other.software) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeDeviceResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeDeviceResponse
        /**
         * The ID of the job used when ordering the device.
         */
        fun associatedWithJob(associatedWithJob: String): FluentBuilder
        /**
         * The hardware specifications of the device.
         */
        fun deviceCapacities(deviceCapacities: List<Capacity>): FluentBuilder
        /**
         * The current state of the device.
         */
        fun deviceState(deviceState: UnlockState): FluentBuilder
        /**
         * The type of Amazon Web Services Snow Family device.
         */
        fun deviceType(deviceType: String): FluentBuilder
        /**
         * When the device last contacted the Amazon Web Services Cloud. Indicates that the device is
         * online.
         */
        fun lastReachedOutAt(lastReachedOutAt: Instant): FluentBuilder
        /**
         * When the device last pushed an update to the Amazon Web Services Cloud. Indicates when the device cache
         * was refreshed.
         */
        fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the device.
         */
        fun managedDeviceArn(managedDeviceArn: String): FluentBuilder
        /**
         * The ID of the device that you checked the information for.
         */
        fun managedDeviceId(managedDeviceId: String): FluentBuilder
        /**
         * The network interfaces available on the device.
         */
        fun physicalNetworkInterfaces(physicalNetworkInterfaces: List<PhysicalNetworkInterface>): FluentBuilder
        /**
         * The software installed on the device.
         */
        fun software(software: SoftwareInformation): FluentBuilder
        /**
         * Optional metadata that you assign to a resource. You can use tags to categorize a resource
         * in different ways, such as by purpose, owner, or environment.
         */
        fun tags(tags: Map<String, String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the job used when ordering the device.
         */
        var associatedWithJob: String?
        /**
         * The hardware specifications of the device.
         */
        var deviceCapacities: List<Capacity>?
        /**
         * The current state of the device.
         */
        var deviceState: UnlockState?
        /**
         * The type of Amazon Web Services Snow Family device.
         */
        var deviceType: String?
        /**
         * When the device last contacted the Amazon Web Services Cloud. Indicates that the device is
         * online.
         */
        var lastReachedOutAt: Instant?
        /**
         * When the device last pushed an update to the Amazon Web Services Cloud. Indicates when the device cache
         * was refreshed.
         */
        var lastUpdatedAt: Instant?
        /**
         * The Amazon Resource Name (ARN) of the device.
         */
        var managedDeviceArn: String?
        /**
         * The ID of the device that you checked the information for.
         */
        var managedDeviceId: String?
        /**
         * The network interfaces available on the device.
         */
        var physicalNetworkInterfaces: List<PhysicalNetworkInterface>?
        /**
         * The software installed on the device.
         */
        var software: SoftwareInformation?
        /**
         * Optional metadata that you assign to a resource. You can use tags to categorize a resource
         * in different ways, such as by purpose, owner, or environment.
         */
        var tags: Map<String, String>?

        fun build(): DescribeDeviceResponse
        /**
         * construct an [aws.sdk.kotlin.services.snowdevicemanagement.model.SoftwareInformation] inside the given [block]
         */
        fun software(block: SoftwareInformation.DslBuilder.() -> kotlin.Unit) {
            this.software = SoftwareInformation.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associatedWithJob: String? = null
        override var deviceCapacities: List<Capacity>? = null
        override var deviceState: UnlockState? = null
        override var deviceType: String? = null
        override var lastReachedOutAt: Instant? = null
        override var lastUpdatedAt: Instant? = null
        override var managedDeviceArn: String? = null
        override var managedDeviceId: String? = null
        override var physicalNetworkInterfaces: List<PhysicalNetworkInterface>? = null
        override var software: SoftwareInformation? = null
        override var tags: Map<String, String>? = null

        constructor(x: DescribeDeviceResponse) : this() {
            this.associatedWithJob = x.associatedWithJob
            this.deviceCapacities = x.deviceCapacities
            this.deviceState = x.deviceState
            this.deviceType = x.deviceType
            this.lastReachedOutAt = x.lastReachedOutAt
            this.lastUpdatedAt = x.lastUpdatedAt
            this.managedDeviceArn = x.managedDeviceArn
            this.managedDeviceId = x.managedDeviceId
            this.physicalNetworkInterfaces = x.physicalNetworkInterfaces
            this.software = x.software
            this.tags = x.tags
        }

        override fun build(): DescribeDeviceResponse = DescribeDeviceResponse(this)
        override fun associatedWithJob(associatedWithJob: String): FluentBuilder = apply { this.associatedWithJob = associatedWithJob }
        override fun deviceCapacities(deviceCapacities: List<Capacity>): FluentBuilder = apply { this.deviceCapacities = deviceCapacities }
        override fun deviceState(deviceState: UnlockState): FluentBuilder = apply { this.deviceState = deviceState }
        override fun deviceType(deviceType: String): FluentBuilder = apply { this.deviceType = deviceType }
        override fun lastReachedOutAt(lastReachedOutAt: Instant): FluentBuilder = apply { this.lastReachedOutAt = lastReachedOutAt }
        override fun lastUpdatedAt(lastUpdatedAt: Instant): FluentBuilder = apply { this.lastUpdatedAt = lastUpdatedAt }
        override fun managedDeviceArn(managedDeviceArn: String): FluentBuilder = apply { this.managedDeviceArn = managedDeviceArn }
        override fun managedDeviceId(managedDeviceId: String): FluentBuilder = apply { this.managedDeviceId = managedDeviceId }
        override fun physicalNetworkInterfaces(physicalNetworkInterfaces: List<PhysicalNetworkInterface>): FluentBuilder = apply { this.physicalNetworkInterfaces = physicalNetworkInterfaces }
        override fun software(software: SoftwareInformation): FluentBuilder = apply { this.software = software }
        override fun tags(tags: Map<String, String>): FluentBuilder = apply { this.tags = tags }
    }
}
