// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowdevicemanagement

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.snowdevicemanagement.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.snowdevicemanagement.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * Amazon Web Services Snow Device Management documentation.
 */
interface SnowDeviceManagementClient : SdkClient {

    override val serviceName: String
        get() = "Snow Device Management"
    /**
     * SnowDeviceManagementClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): SnowDeviceManagementClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultSnowDeviceManagementClient(config)
        }

        operator fun invoke(config: Config): SnowDeviceManagementClient = DefaultSnowDeviceManagementClient(config)

        /**
         * Construct a [SnowDeviceManagementClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): SnowDeviceManagementClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return SnowDeviceManagementClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Sends a cancel request for a specified task. You can cancel a task only if it's still in a
     * QUEUED state. Tasks that are already running can't be cancelled.
     * A task might still run if it's processed from the queue before the
     * CancelTask operation changes the task's state.
     */
    suspend fun cancelTask(input: CancelTaskRequest): CancelTaskResponse

    /**
     * Sends a cancel request for a specified task. You can cancel a task only if it's still in a
     * QUEUED state. Tasks that are already running can't be cancelled.
     * A task might still run if it's processed from the queue before the
     * CancelTask operation changes the task's state.
     */
    suspend fun cancelTask(block: CancelTaskRequest.DslBuilder.() -> Unit) = cancelTask(CancelTaskRequest.builder().apply(block).build())

    /**
     * Instructs one or more devices to start a task, such as unlocking or rebooting.
     */
    suspend fun createTask(input: CreateTaskRequest): CreateTaskResponse

    /**
     * Instructs one or more devices to start a task, such as unlocking or rebooting.
     */
    suspend fun createTask(block: CreateTaskRequest.DslBuilder.() -> Unit) = createTask(CreateTaskRequest.builder().apply(block).build())

    /**
     * Checks device-specific information, such as the device type, software version, IP
     * addresses, and lock status.
     */
    suspend fun describeDevice(input: DescribeDeviceRequest): DescribeDeviceResponse

    /**
     * Checks device-specific information, such as the device type, software version, IP
     * addresses, and lock status.
     */
    suspend fun describeDevice(block: DescribeDeviceRequest.DslBuilder.() -> Unit) = describeDevice(DescribeDeviceRequest.builder().apply(block).build())

    /**
     * Checks the current state of the Amazon EC2 instances. The output is similar to
     * describeDevice, but the results are sourced from the device cache in the
     * Amazon Web Services Cloud and include a subset of the available fields.
     */
    suspend fun describeDeviceEc2Instances(input: DescribeDeviceEc2InstancesRequest): DescribeDeviceEc2InstancesResponse

    /**
     * Checks the current state of the Amazon EC2 instances. The output is similar to
     * describeDevice, but the results are sourced from the device cache in the
     * Amazon Web Services Cloud and include a subset of the available fields.
     */
    suspend fun describeDeviceEc2Instances(block: DescribeDeviceEc2InstancesRequest.DslBuilder.() -> Unit) = describeDeviceEc2Instances(DescribeDeviceEc2InstancesRequest.builder().apply(block).build())

    /**
     * Checks the status of a remote task running on one or more target devices.
     */
    suspend fun describeExecution(input: DescribeExecutionRequest): DescribeExecutionResponse

    /**
     * Checks the status of a remote task running on one or more target devices.
     */
    suspend fun describeExecution(block: DescribeExecutionRequest.DslBuilder.() -> Unit) = describeExecution(DescribeExecutionRequest.builder().apply(block).build())

    /**
     * Checks the metadata for a given task on a device.
     */
    suspend fun describeTask(input: DescribeTaskRequest): DescribeTaskResponse

    /**
     * Checks the metadata for a given task on a device.
     */
    suspend fun describeTask(block: DescribeTaskRequest.DslBuilder.() -> Unit) = describeTask(DescribeTaskRequest.builder().apply(block).build())

    /**
     * Returns a list of the Amazon Web Services resources available for a device. Currently, Amazon EC2 instances are the only supported resource type.
     */
    suspend fun listDeviceResources(input: ListDeviceResourcesRequest): ListDeviceResourcesResponse

    /**
     * Returns a list of the Amazon Web Services resources available for a device. Currently, Amazon EC2 instances are the only supported resource type.
     */
    suspend fun listDeviceResources(block: ListDeviceResourcesRequest.DslBuilder.() -> Unit) = listDeviceResources(ListDeviceResourcesRequest.builder().apply(block).build())

    /**
     * Returns a list of all devices on your Amazon Web Services account that have Amazon Web Services Snow Device Management
     * enabled in the Amazon Web Services Region where the command is run.
     */
    suspend fun listDevices(input: ListDevicesRequest): ListDevicesResponse

    /**
     * Returns a list of all devices on your Amazon Web Services account that have Amazon Web Services Snow Device Management
     * enabled in the Amazon Web Services Region where the command is run.
     */
    suspend fun listDevices(block: ListDevicesRequest.DslBuilder.() -> Unit) = listDevices(ListDevicesRequest.builder().apply(block).build())

    /**
     * Returns the status of tasks for one or more target devices.
     */
    suspend fun listExecutions(input: ListExecutionsRequest): ListExecutionsResponse

    /**
     * Returns the status of tasks for one or more target devices.
     */
    suspend fun listExecutions(block: ListExecutionsRequest.DslBuilder.() -> Unit) = listExecutions(ListExecutionsRequest.builder().apply(block).build())

    /**
     * Returns a list of tags for a managed device or task.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of tags for a managed device or task.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Returns a list of tasks that can be filtered by state.
     */
    suspend fun listTasks(input: ListTasksRequest): ListTasksResponse

    /**
     * Returns a list of tasks that can be filtered by state.
     */
    suspend fun listTasks(block: ListTasksRequest.DslBuilder.() -> Unit) = listTasks(ListTasksRequest.builder().apply(block).build())

    /**
     * Adds or replaces tags on a device or task.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds or replaces tags on a device or task.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes a tag from a device or task.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes a tag from a device or task.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())
}
