// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowdevicemanagement.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.snowdevicemanagement.model.Capacity
import aws.sdk.kotlin.services.snowdevicemanagement.model.DescribeDeviceResponse
import aws.sdk.kotlin.services.snowdevicemanagement.model.PhysicalNetworkInterface
import aws.sdk.kotlin.services.snowdevicemanagement.model.SnowDeviceManagementException
import aws.sdk.kotlin.services.snowdevicemanagement.model.SoftwareInformation
import aws.sdk.kotlin.services.snowdevicemanagement.model.UnlockState
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeDeviceOperationDeserializer: HttpDeserialize<DescribeDeviceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeDeviceResponse {
        if (!response.status.isSuccess()) {
            throwDescribeDeviceError(context, response)
        }
        val builder = DescribeDeviceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDeviceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeDeviceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SnowDeviceManagementException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SnowDeviceManagementException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDeviceOperationBody(builder: DescribeDeviceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSOCIATEDWITHJOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("associatedWithJob"))
    val DEVICECAPACITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("deviceCapacities"))
    val DEVICESTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceState"))
    val DEVICETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deviceType"))
    val LASTREACHEDOUTAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastReachedOutAt"))
    val LASTUPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastUpdatedAt"))
    val MANAGEDDEVICEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("managedDeviceArn"))
    val MANAGEDDEVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("managedDeviceId"))
    val PHYSICALNETWORKINTERFACES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("physicalNetworkInterfaces"))
    val SOFTWARE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("software"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSOCIATEDWITHJOB_DESCRIPTOR)
        field(DEVICECAPACITIES_DESCRIPTOR)
        field(DEVICESTATE_DESCRIPTOR)
        field(DEVICETYPE_DESCRIPTOR)
        field(LASTREACHEDOUTAT_DESCRIPTOR)
        field(LASTUPDATEDAT_DESCRIPTOR)
        field(MANAGEDDEVICEARN_DESCRIPTOR)
        field(MANAGEDDEVICEID_DESCRIPTOR)
        field(PHYSICALNETWORKINTERFACES_DESCRIPTOR)
        field(SOFTWARE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSOCIATEDWITHJOB_DESCRIPTOR.index -> builder.associatedWithJob = deserializeString()
                DEVICECAPACITIES_DESCRIPTOR.index -> builder.deviceCapacities =
                    deserializer.deserializeList(DEVICECAPACITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<Capacity>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCapacityDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DEVICESTATE_DESCRIPTOR.index -> builder.deviceState = deserializeString().let { UnlockState.fromValue(it) }
                DEVICETYPE_DESCRIPTOR.index -> builder.deviceType = deserializeString()
                LASTREACHEDOUTAT_DESCRIPTOR.index -> builder.lastReachedOutAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTUPDATEDAT_DESCRIPTOR.index -> builder.lastUpdatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                MANAGEDDEVICEARN_DESCRIPTOR.index -> builder.managedDeviceArn = deserializeString()
                MANAGEDDEVICEID_DESCRIPTOR.index -> builder.managedDeviceId = deserializeString()
                PHYSICALNETWORKINTERFACES_DESCRIPTOR.index -> builder.physicalNetworkInterfaces =
                    deserializer.deserializeList(PHYSICALNETWORKINTERFACES_DESCRIPTOR) {
                        val col0 = mutableListOf<PhysicalNetworkInterface>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePhysicalNetworkInterfaceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SOFTWARE_DESCRIPTOR.index -> builder.software = deserializeSoftwareInformationDocument(deserializer)
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
