// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowdevicemanagement

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.snowdevicemanagement.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.snowdevicemanagement.model.*
import aws.sdk.kotlin.services.snowdevicemanagement.model.CancelTaskRequest
import aws.sdk.kotlin.services.snowdevicemanagement.model.CancelTaskResponse
import aws.sdk.kotlin.services.snowdevicemanagement.model.CreateTaskRequest
import aws.sdk.kotlin.services.snowdevicemanagement.model.CreateTaskResponse
import aws.sdk.kotlin.services.snowdevicemanagement.model.DescribeDeviceEc2InstancesRequest
import aws.sdk.kotlin.services.snowdevicemanagement.model.DescribeDeviceEc2InstancesResponse
import aws.sdk.kotlin.services.snowdevicemanagement.model.DescribeDeviceRequest
import aws.sdk.kotlin.services.snowdevicemanagement.model.DescribeDeviceResponse
import aws.sdk.kotlin.services.snowdevicemanagement.model.DescribeExecutionRequest
import aws.sdk.kotlin.services.snowdevicemanagement.model.DescribeExecutionResponse
import aws.sdk.kotlin.services.snowdevicemanagement.model.DescribeTaskRequest
import aws.sdk.kotlin.services.snowdevicemanagement.model.DescribeTaskResponse
import aws.sdk.kotlin.services.snowdevicemanagement.model.ListDeviceResourcesRequest
import aws.sdk.kotlin.services.snowdevicemanagement.model.ListDeviceResourcesResponse
import aws.sdk.kotlin.services.snowdevicemanagement.model.ListDevicesRequest
import aws.sdk.kotlin.services.snowdevicemanagement.model.ListDevicesResponse
import aws.sdk.kotlin.services.snowdevicemanagement.model.ListExecutionsRequest
import aws.sdk.kotlin.services.snowdevicemanagement.model.ListExecutionsResponse
import aws.sdk.kotlin.services.snowdevicemanagement.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.snowdevicemanagement.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.snowdevicemanagement.model.ListTasksRequest
import aws.sdk.kotlin.services.snowdevicemanagement.model.ListTasksResponse
import aws.sdk.kotlin.services.snowdevicemanagement.model.TagResourceRequest
import aws.sdk.kotlin.services.snowdevicemanagement.model.TagResourceResponse
import aws.sdk.kotlin.services.snowdevicemanagement.model.UntagResourceRequest
import aws.sdk.kotlin.services.snowdevicemanagement.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Web Services Snow Device Management documentation.
 */
public interface SnowDeviceManagementClient : SdkClient {

    override val serviceName: String
        get() = "Snow Device Management"
    /**
     * SnowDeviceManagementClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): SnowDeviceManagementClient {
            val config = Config.Builder().apply(block).build()
            return DefaultSnowDeviceManagementClient(config)
        }

        public operator fun invoke(config: Config): SnowDeviceManagementClient = DefaultSnowDeviceManagementClient(config)

        /**
         * Construct a [SnowDeviceManagementClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): SnowDeviceManagementClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultSnowDeviceManagementClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Sends a cancel request for a specified task. You can cancel a task only if it's still in a `QUEUED` state. Tasks that are already running can't be cancelled.
     *
     * A task might still run if it's processed from the queue before the `CancelTask` operation changes the task's state.
     */
    public suspend fun cancelTask(input: CancelTaskRequest): CancelTaskResponse

    /**
     * Instructs one or more devices to start a task, such as unlocking or rebooting.
     */
    public suspend fun createTask(input: CreateTaskRequest): CreateTaskResponse

    /**
     * Checks device-specific information, such as the device type, software version, IP addresses, and lock status.
     */
    public suspend fun describeDevice(input: DescribeDeviceRequest): DescribeDeviceResponse

    /**
     * Checks the current state of the Amazon EC2 instances. The output is similar to `describeDevice`, but the results are sourced from the device cache in the Amazon Web Services Cloud and include a subset of the available fields.
     */
    public suspend fun describeDeviceEc2Instances(input: DescribeDeviceEc2InstancesRequest): DescribeDeviceEc2InstancesResponse

    /**
     * Checks the status of a remote task running on one or more target devices.
     */
    public suspend fun describeExecution(input: DescribeExecutionRequest): DescribeExecutionResponse

    /**
     * Checks the metadata for a given task on a device.
     */
    public suspend fun describeTask(input: DescribeTaskRequest): DescribeTaskResponse

    /**
     * Returns a list of the Amazon Web Services resources available for a device. Currently, Amazon EC2 instances are the only supported resource type.
     */
    public suspend fun listDeviceResources(input: ListDeviceResourcesRequest): ListDeviceResourcesResponse

    /**
     * Returns a list of all devices on your Amazon Web Services account that have Amazon Web Services Snow Device Management enabled in the Amazon Web Services Region where the command is run.
     */
    public suspend fun listDevices(input: ListDevicesRequest = ListDevicesRequest {}): ListDevicesResponse

    /**
     * Returns the status of tasks for one or more target devices.
     */
    public suspend fun listExecutions(input: ListExecutionsRequest): ListExecutionsResponse

    /**
     * Returns a list of tags for a managed device or task.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of tasks that can be filtered by state.
     */
    public suspend fun listTasks(input: ListTasksRequest = ListTasksRequest {}): ListTasksResponse

    /**
     * Adds or replaces tags on a device or task.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from a device or task.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Sends a cancel request for a specified task. You can cancel a task only if it's still in a `QUEUED` state. Tasks that are already running can't be cancelled.
 *
 * A task might still run if it's processed from the queue before the `CancelTask` operation changes the task's state.
 */
public suspend inline fun SnowDeviceManagementClient.cancelTask(crossinline block: CancelTaskRequest.Builder.() -> Unit): CancelTaskResponse = cancelTask(CancelTaskRequest.Builder().apply(block).build())

/**
 * Instructs one or more devices to start a task, such as unlocking or rebooting.
 */
public suspend inline fun SnowDeviceManagementClient.createTask(crossinline block: CreateTaskRequest.Builder.() -> Unit): CreateTaskResponse = createTask(CreateTaskRequest.Builder().apply(block).build())

/**
 * Checks device-specific information, such as the device type, software version, IP addresses, and lock status.
 */
public suspend inline fun SnowDeviceManagementClient.describeDevice(crossinline block: DescribeDeviceRequest.Builder.() -> Unit): DescribeDeviceResponse = describeDevice(DescribeDeviceRequest.Builder().apply(block).build())

/**
 * Checks the current state of the Amazon EC2 instances. The output is similar to `describeDevice`, but the results are sourced from the device cache in the Amazon Web Services Cloud and include a subset of the available fields.
 */
public suspend inline fun SnowDeviceManagementClient.describeDeviceEc2Instances(crossinline block: DescribeDeviceEc2InstancesRequest.Builder.() -> Unit): DescribeDeviceEc2InstancesResponse = describeDeviceEc2Instances(DescribeDeviceEc2InstancesRequest.Builder().apply(block).build())

/**
 * Checks the status of a remote task running on one or more target devices.
 */
public suspend inline fun SnowDeviceManagementClient.describeExecution(crossinline block: DescribeExecutionRequest.Builder.() -> Unit): DescribeExecutionResponse = describeExecution(DescribeExecutionRequest.Builder().apply(block).build())

/**
 * Checks the metadata for a given task on a device.
 */
public suspend inline fun SnowDeviceManagementClient.describeTask(crossinline block: DescribeTaskRequest.Builder.() -> Unit): DescribeTaskResponse = describeTask(DescribeTaskRequest.Builder().apply(block).build())

/**
 * Returns a list of the Amazon Web Services resources available for a device. Currently, Amazon EC2 instances are the only supported resource type.
 */
public suspend inline fun SnowDeviceManagementClient.listDeviceResources(crossinline block: ListDeviceResourcesRequest.Builder.() -> Unit): ListDeviceResourcesResponse = listDeviceResources(ListDeviceResourcesRequest.Builder().apply(block).build())

/**
 * Returns a list of all devices on your Amazon Web Services account that have Amazon Web Services Snow Device Management enabled in the Amazon Web Services Region where the command is run.
 */
public suspend inline fun SnowDeviceManagementClient.listDevices(crossinline block: ListDevicesRequest.Builder.() -> Unit): ListDevicesResponse = listDevices(ListDevicesRequest.Builder().apply(block).build())

/**
 * Returns the status of tasks for one or more target devices.
 */
public suspend inline fun SnowDeviceManagementClient.listExecutions(crossinline block: ListExecutionsRequest.Builder.() -> Unit): ListExecutionsResponse = listExecutions(ListExecutionsRequest.Builder().apply(block).build())

/**
 * Returns a list of tags for a managed device or task.
 */
public suspend inline fun SnowDeviceManagementClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of tasks that can be filtered by state.
 */
public suspend inline fun SnowDeviceManagementClient.listTasks(crossinline block: ListTasksRequest.Builder.() -> Unit): ListTasksResponse = listTasks(ListTasksRequest.Builder().apply(block).build())

/**
 * Adds or replaces tags on a device or task.
 */
public suspend inline fun SnowDeviceManagementClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from a device or task.
 */
public suspend inline fun SnowDeviceManagementClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
