// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.serde

import aws.sdk.kotlin.services.snowball.model.CreateClusterRequest
import aws.sdk.kotlin.services.snowball.model.JobResource
import aws.sdk.kotlin.services.snowball.model.JobType
import aws.sdk.kotlin.services.snowball.model.Notification
import aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration
import aws.sdk.kotlin.services.snowball.model.RemoteManagement
import aws.sdk.kotlin.services.snowball.model.ShippingOption
import aws.sdk.kotlin.services.snowball.model.SnowballCapacity
import aws.sdk.kotlin.services.snowball.model.SnowballType
import aws.sdk.kotlin.services.snowball.model.TaxDocuments
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateClusterOperationSerializer: HttpSerializer.NonStreaming<CreateClusterRequest> {
    override fun serialize(context: ExecutionContext, input: CreateClusterRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCreateClusterOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateClusterOperationBody(context: ExecutionContext, input: CreateClusterRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDRESSID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AddressId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val FORCECREATEJOBS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("ForceCreateJobs"))
    val FORWARDINGADDRESSID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ForwardingAddressId"))
    val INITIALCLUSTERSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InitialClusterSize"))
    val JOBTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("JobType"))
    val KMSKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyARN"))
    val LONGTERMPRICINGIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LongTermPricingIds"))
    val NOTIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Notification"))
    val ONDEVICESERVICECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("OnDeviceServiceConfiguration"))
    val REMOTEMANAGEMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("RemoteManagement"))
    val RESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Resources"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleARN"))
    val SHIPPINGOPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ShippingOption"))
    val SNOWBALLCAPACITYPREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SnowballCapacityPreference"))
    val SNOWBALLTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("SnowballType"))
    val TAXDOCUMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TaxDocuments"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDRESSID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FORCECREATEJOBS_DESCRIPTOR)
        field(FORWARDINGADDRESSID_DESCRIPTOR)
        field(INITIALCLUSTERSIZE_DESCRIPTOR)
        field(JOBTYPE_DESCRIPTOR)
        field(KMSKEYARN_DESCRIPTOR)
        field(LONGTERMPRICINGIDS_DESCRIPTOR)
        field(NOTIFICATION_DESCRIPTOR)
        field(ONDEVICESERVICECONFIGURATION_DESCRIPTOR)
        field(REMOTEMANAGEMENT_DESCRIPTOR)
        field(RESOURCES_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SHIPPINGOPTION_DESCRIPTOR)
        field(SNOWBALLCAPACITYPREFERENCE_DESCRIPTOR)
        field(SNOWBALLTYPE_DESCRIPTOR)
        field(TAXDOCUMENTS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.addressId?.let { field(ADDRESSID_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.forceCreateJobs?.let { field(FORCECREATEJOBS_DESCRIPTOR, it) }
        input.forwardingAddressId?.let { field(FORWARDINGADDRESSID_DESCRIPTOR, it) }
        input.initialClusterSize?.let { field(INITIALCLUSTERSIZE_DESCRIPTOR, it) }
        input.jobType?.let { field(JOBTYPE_DESCRIPTOR, it.value) }
        input.kmsKeyArn?.let { field(KMSKEYARN_DESCRIPTOR, it) }
        if (input.longTermPricingIds != null) {
            listField(LONGTERMPRICINGIDS_DESCRIPTOR) {
                for (el0 in input.longTermPricingIds) {
                    serializeString(el0)
                }
            }
        }
        input.notification?.let { field(NOTIFICATION_DESCRIPTOR, it, ::serializeNotificationDocument) }
        input.onDeviceServiceConfiguration?.let { field(ONDEVICESERVICECONFIGURATION_DESCRIPTOR, it, ::serializeOnDeviceServiceConfigurationDocument) }
        input.remoteManagement?.let { field(REMOTEMANAGEMENT_DESCRIPTOR, it.value) }
        input.resources?.let { field(RESOURCES_DESCRIPTOR, it, ::serializeJobResourceDocument) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        input.shippingOption?.let { field(SHIPPINGOPTION_DESCRIPTOR, it.value) }
        input.snowballCapacityPreference?.let { field(SNOWBALLCAPACITYPREFERENCE_DESCRIPTOR, it.value) }
        input.snowballType?.let { field(SNOWBALLTYPE_DESCRIPTOR, it.value) }
        input.taxDocuments?.let { field(TAXDOCUMENTS_DESCRIPTOR, it, ::serializeTaxDocumentsDocument) }
    }
    return serializer.toByteArray()
}
