// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.serde

import aws.sdk.kotlin.services.snowball.model.CancelClusterResponse
import aws.sdk.kotlin.services.snowball.model.SnowballException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CancelClusterOperationDeserializer: HttpDeserializer.NonStreaming<CancelClusterResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CancelClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCancelClusterError(context, call, payload)
        }
        val builder = CancelClusterResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCancelClusterError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SnowballException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "KMSRequestFailedException" -> KmsRequestFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidJobStateException" -> InvalidJobStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidResourceException" -> InvalidResourceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SnowballException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
