// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateJobRequest private constructor(builder: Builder) {
    /**
     * The ID of the updated Address object.
     */
    public val addressId: kotlin.String? = builder.addressId
    /**
     * The updated description of this job's JobMetadata object.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The updated ID for the forwarding address for a job. This field is not supported in most regions.
     */
    public val forwardingAddressId: kotlin.String? = builder.forwardingAddressId
    /**
     * The job ID of the job that you want to update, for example `JID123e4567-e89b-12d3-a456-426655440000`.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The new or updated Notification object.
     */
    public val notification: aws.sdk.kotlin.services.snowball.model.Notification? = builder.notification
    /**
     * Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.
     */
    public val onDeviceServiceConfiguration: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration? = builder.onDeviceServiceConfiguration
    /**
     * Information identifying the person picking up the device.
     */
    public val pickupDetails: aws.sdk.kotlin.services.snowball.model.PickupDetails? = builder.pickupDetails
    /**
     * The updated `JobResource` object, or the updated JobResource object.
     */
    public val resources: aws.sdk.kotlin.services.snowball.model.JobResource? = builder.resources
    /**
     * The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use the [CreateRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)Identity and Access Management (IAM) API action.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The updated shipping option value of this job's ShippingDetails object.
     */
    public val shippingOption: aws.sdk.kotlin.services.snowball.model.ShippingOption? = builder.shippingOption
    /**
     * The updated `SnowballCapacityPreference` of this job's JobMetadata object. The 50 TB Snowballs are only available in the US regions.
     *
     * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
     */
    public val snowballCapacityPreference: aws.sdk.kotlin.services.snowball.model.SnowballCapacity? = builder.snowballCapacityPreference

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.UpdateJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateJobRequest(")
        append("addressId=$addressId,")
        append("description=$description,")
        append("forwardingAddressId=$forwardingAddressId,")
        append("jobId=$jobId,")
        append("notification=$notification,")
        append("onDeviceServiceConfiguration=$onDeviceServiceConfiguration,")
        append("pickupDetails=$pickupDetails,")
        append("resources=$resources,")
        append("roleArn=$roleArn,")
        append("shippingOption=$shippingOption,")
        append("snowballCapacityPreference=$snowballCapacityPreference")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (forwardingAddressId?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (notification?.hashCode() ?: 0)
        result = 31 * result + (onDeviceServiceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (pickupDetails?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (shippingOption?.hashCode() ?: 0)
        result = 31 * result + (snowballCapacityPreference?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateJobRequest

        if (addressId != other.addressId) return false
        if (description != other.description) return false
        if (forwardingAddressId != other.forwardingAddressId) return false
        if (jobId != other.jobId) return false
        if (notification != other.notification) return false
        if (onDeviceServiceConfiguration != other.onDeviceServiceConfiguration) return false
        if (pickupDetails != other.pickupDetails) return false
        if (resources != other.resources) return false
        if (roleArn != other.roleArn) return false
        if (shippingOption != other.shippingOption) return false
        if (snowballCapacityPreference != other.snowballCapacityPreference) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.UpdateJobRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the updated Address object.
         */
        public var addressId: kotlin.String? = null
        /**
         * The updated description of this job's JobMetadata object.
         */
        public var description: kotlin.String? = null
        /**
         * The updated ID for the forwarding address for a job. This field is not supported in most regions.
         */
        public var forwardingAddressId: kotlin.String? = null
        /**
         * The job ID of the job that you want to update, for example `JID123e4567-e89b-12d3-a456-426655440000`.
         */
        public var jobId: kotlin.String? = null
        /**
         * The new or updated Notification object.
         */
        public var notification: aws.sdk.kotlin.services.snowball.model.Notification? = null
        /**
         * Specifies the service or services on the Snow Family device that your transferred data will be exported from or imported into. Amazon Web Services Snow Family supports Amazon S3 and NFS (Network File System) and the Amazon Web Services Storage Gateway service Tape Gateway type.
         */
        public var onDeviceServiceConfiguration: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration? = null
        /**
         * Information identifying the person picking up the device.
         */
        public var pickupDetails: aws.sdk.kotlin.services.snowball.model.PickupDetails? = null
        /**
         * The updated `JobResource` object, or the updated JobResource object.
         */
        public var resources: aws.sdk.kotlin.services.snowball.model.JobResource? = null
        /**
         * The new role Amazon Resource Name (ARN) that you want to associate with this job. To create a role ARN, use the [CreateRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)Identity and Access Management (IAM) API action.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The updated shipping option value of this job's ShippingDetails object.
         */
        public var shippingOption: aws.sdk.kotlin.services.snowball.model.ShippingOption? = null
        /**
         * The updated `SnowballCapacityPreference` of this job's JobMetadata object. The 50 TB Snowballs are only available in the US regions.
         *
         * For more information, see "https://docs.aws.amazon.com/snowball/latest/snowcone-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide* or "https://docs.aws.amazon.com/snowball/latest/developer-guide/snow-device-types.html" (Snow Family Devices and Capacity) in the *Snowcone User Guide*.
         */
        public var snowballCapacityPreference: aws.sdk.kotlin.services.snowball.model.SnowballCapacity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.UpdateJobRequest) : this() {
            this.addressId = x.addressId
            this.description = x.description
            this.forwardingAddressId = x.forwardingAddressId
            this.jobId = x.jobId
            this.notification = x.notification
            this.onDeviceServiceConfiguration = x.onDeviceServiceConfiguration
            this.pickupDetails = x.pickupDetails
            this.resources = x.resources
            this.roleArn = x.roleArn
            this.shippingOption = x.shippingOption
            this.snowballCapacityPreference = x.snowballCapacityPreference
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.UpdateJobRequest = UpdateJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.Notification] inside the given [block]
         */
        public fun notification(block: aws.sdk.kotlin.services.snowball.model.Notification.Builder.() -> kotlin.Unit) {
            this.notification = aws.sdk.kotlin.services.snowball.model.Notification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration] inside the given [block]
         */
        public fun onDeviceServiceConfiguration(block: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration.Builder.() -> kotlin.Unit) {
            this.onDeviceServiceConfiguration = aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.PickupDetails] inside the given [block]
         */
        public fun pickupDetails(block: aws.sdk.kotlin.services.snowball.model.PickupDetails.Builder.() -> kotlin.Unit) {
            this.pickupDetails = aws.sdk.kotlin.services.snowball.model.PickupDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.JobResource] inside the given [block]
         */
        public fun resources(block: aws.sdk.kotlin.services.snowball.model.JobResource.Builder.() -> kotlin.Unit) {
            this.resources = aws.sdk.kotlin.services.snowball.model.JobResource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
