// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A job's shipping information, including inbound and outbound tracking numbers and shipping speed options.
 */
public class ShippingDetails private constructor(builder: Builder) {
    /**
     * The `Status` and `TrackingNumber` values for a Snow device being returned to Amazon Web Services for a particular job.
     */
    public val inboundShipment: aws.sdk.kotlin.services.snowball.model.Shipment? = builder.inboundShipment
    /**
     * The `Status` and `TrackingNumber` values for a Snow device being delivered to the address that you specified for a particular job.
     */
    public val outboundShipment: aws.sdk.kotlin.services.snowball.model.Shipment? = builder.outboundShipment
    /**
     * The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snow device from the job's creation date. This speed represents how quickly it moves to its destination while in transit. Regional shipping speeds are as follows:
     * + In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.
     * + In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.
     * + In India, Snow devices are delivered in one to seven days.
     * + In the United States of America (US), you have access to one-day shipping and two-day shipping.
     */
    public val shippingOption: aws.sdk.kotlin.services.snowball.model.ShippingOption? = builder.shippingOption

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.ShippingDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ShippingDetails(")
        append("inboundShipment=$inboundShipment,")
        append("outboundShipment=$outboundShipment,")
        append("shippingOption=$shippingOption")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inboundShipment?.hashCode() ?: 0
        result = 31 * result + (outboundShipment?.hashCode() ?: 0)
        result = 31 * result + (shippingOption?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ShippingDetails

        if (inboundShipment != other.inboundShipment) return false
        if (outboundShipment != other.outboundShipment) return false
        if (shippingOption != other.shippingOption) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.ShippingDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `Status` and `TrackingNumber` values for a Snow device being returned to Amazon Web Services for a particular job.
         */
        public var inboundShipment: aws.sdk.kotlin.services.snowball.model.Shipment? = null
        /**
         * The `Status` and `TrackingNumber` values for a Snow device being delivered to the address that you specified for a particular job.
         */
        public var outboundShipment: aws.sdk.kotlin.services.snowball.model.Shipment? = null
        /**
         * The shipping speed for a particular job. This speed doesn't dictate how soon you'll get the Snow device from the job's creation date. This speed represents how quickly it moves to its destination while in transit. Regional shipping speeds are as follows:
         * + In Australia, you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day.
         * + In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.
         * + In India, Snow devices are delivered in one to seven days.
         * + In the United States of America (US), you have access to one-day shipping and two-day shipping.
         */
        public var shippingOption: aws.sdk.kotlin.services.snowball.model.ShippingOption? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.ShippingDetails) : this() {
            this.inboundShipment = x.inboundShipment
            this.outboundShipment = x.outboundShipment
            this.shippingOption = x.shippingOption
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.ShippingDetails = ShippingDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.Shipment] inside the given [block]
         */
        public fun inboundShipment(block: aws.sdk.kotlin.services.snowball.model.Shipment.Builder.() -> kotlin.Unit) {
            this.inboundShipment = aws.sdk.kotlin.services.snowball.model.Shipment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.Shipment] inside the given [block]
         */
        public fun outboundShipment(block: aws.sdk.kotlin.services.snowball.model.Shipment.Builder.() -> kotlin.Unit) {
            this.outboundShipment = aws.sdk.kotlin.services.snowball.model.Shipment.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
