// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Amazon S3 compatible storage on Snow family devices configuration items.
 */
public class S3OnDeviceServiceConfiguration private constructor(builder: Builder) {
    /**
     * >Fault tolerance level of the cluster. This indicates the number of nodes that can go down without degrading the performance of the cluster. This additional input helps when the specified `StorageLimit` matches more than one Amazon S3 compatible storage on Snow family devices service configuration.
     */
    public val faultTolerance: kotlin.Int? = builder.faultTolerance
    /**
     * Applicable when creating a cluster. Specifies how many nodes are needed for Amazon S3 compatible storage on Snow family devices. If specified, the other input can be omitted.
     */
    public val serviceSize: kotlin.Int? = builder.serviceSize
    /**
     * If the specified storage limit value matches storage limit of one of the defined configurations, that configuration will be used. If the specified storage limit value does not match any defined configuration, the request will fail. If more than one configuration has the same storage limit as specified, the other input need to be provided.
     */
    public val storageLimit: kotlin.Double? = builder.storageLimit
    /**
     * Storage unit. Currently the only supported unit is TB.
     */
    public val storageUnit: aws.sdk.kotlin.services.snowball.model.StorageUnit? = builder.storageUnit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.S3OnDeviceServiceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3OnDeviceServiceConfiguration(")
        append("faultTolerance=$faultTolerance,")
        append("serviceSize=$serviceSize,")
        append("storageLimit=$storageLimit,")
        append("storageUnit=$storageUnit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = faultTolerance ?: 0
        result = 31 * result + (serviceSize ?: 0)
        result = 31 * result + (storageLimit?.hashCode() ?: 0)
        result = 31 * result + (storageUnit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3OnDeviceServiceConfiguration

        if (faultTolerance != other.faultTolerance) return false
        if (serviceSize != other.serviceSize) return false
        if (storageLimit != other.storageLimit) return false
        if (storageUnit != other.storageUnit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.S3OnDeviceServiceConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * >Fault tolerance level of the cluster. This indicates the number of nodes that can go down without degrading the performance of the cluster. This additional input helps when the specified `StorageLimit` matches more than one Amazon S3 compatible storage on Snow family devices service configuration.
         */
        public var faultTolerance: kotlin.Int? = null
        /**
         * Applicable when creating a cluster. Specifies how many nodes are needed for Amazon S3 compatible storage on Snow family devices. If specified, the other input can be omitted.
         */
        public var serviceSize: kotlin.Int? = null
        /**
         * If the specified storage limit value matches storage limit of one of the defined configurations, that configuration will be used. If the specified storage limit value does not match any defined configuration, the request will fail. If more than one configuration has the same storage limit as specified, the other input need to be provided.
         */
        public var storageLimit: kotlin.Double? = null
        /**
         * Storage unit. Currently the only supported unit is TB.
         */
        public var storageUnit: aws.sdk.kotlin.services.snowball.model.StorageUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.S3OnDeviceServiceConfiguration) : this() {
            this.faultTolerance = x.faultTolerance
            this.serviceSize = x.serviceSize
            this.storageLimit = x.storageLimit
            this.storageUnit = x.storageUnit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.S3OnDeviceServiceConfiguration = S3OnDeviceServiceConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
