// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information identifying the person picking up the device.
 */
public class PickupDetails private constructor(builder: Builder) {
    /**
     * The unique ID for a device that will be picked up.
     */
    public val devicePickupId: kotlin.String? = builder.devicePickupId
    /**
     * The email address of the person picking up the device.
     */
    public val email: kotlin.String? = builder.email
    /**
     * Expiration date of the credential identifying the person picking up the device.
     */
    public val identificationExpirationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.identificationExpirationDate
    /**
     * Organization that issued the credential identifying the person picking up the device.
     */
    public val identificationIssuingOrg: kotlin.String? = builder.identificationIssuingOrg
    /**
     * The number on the credential identifying the person picking up the device.
     */
    public val identificationNumber: kotlin.String? = builder.identificationNumber
    /**
     * The name of the person picking up the device.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The phone number of the person picking up the device.
     */
    public val phoneNumber: kotlin.String? = builder.phoneNumber

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.PickupDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PickupDetails(")
        append("devicePickupId=$devicePickupId,")
        append("email=*** Sensitive Data Redacted ***,")
        append("identificationExpirationDate=$identificationExpirationDate,")
        append("identificationIssuingOrg=$identificationIssuingOrg,")
        append("identificationNumber=$identificationNumber,")
        append("name=$name,")
        append("phoneNumber=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = devicePickupId?.hashCode() ?: 0
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (identificationExpirationDate?.hashCode() ?: 0)
        result = 31 * result + (identificationIssuingOrg?.hashCode() ?: 0)
        result = 31 * result + (identificationNumber?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (phoneNumber?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PickupDetails

        if (devicePickupId != other.devicePickupId) return false
        if (email != other.email) return false
        if (identificationExpirationDate != other.identificationExpirationDate) return false
        if (identificationIssuingOrg != other.identificationIssuingOrg) return false
        if (identificationNumber != other.identificationNumber) return false
        if (name != other.name) return false
        if (phoneNumber != other.phoneNumber) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.PickupDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique ID for a device that will be picked up.
         */
        public var devicePickupId: kotlin.String? = null
        /**
         * The email address of the person picking up the device.
         */
        public var email: kotlin.String? = null
        /**
         * Expiration date of the credential identifying the person picking up the device.
         */
        public var identificationExpirationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Organization that issued the credential identifying the person picking up the device.
         */
        public var identificationIssuingOrg: kotlin.String? = null
        /**
         * The number on the credential identifying the person picking up the device.
         */
        public var identificationNumber: kotlin.String? = null
        /**
         * The name of the person picking up the device.
         */
        public var name: kotlin.String? = null
        /**
         * The phone number of the person picking up the device.
         */
        public var phoneNumber: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.PickupDetails) : this() {
            this.devicePickupId = x.devicePickupId
            this.email = x.email
            this.identificationExpirationDate = x.identificationExpirationDate
            this.identificationIssuingOrg = x.identificationIssuingOrg
            this.identificationNumber = x.identificationNumber
            this.name = x.name
            this.phoneNumber = x.phoneNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.PickupDetails = PickupDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
