// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Amazon Simple Notification Service (Amazon SNS) notification settings associated with a specific job. The `Notification` object is returned as a part of the response syntax of the `DescribeJob` action in the `JobMetadata` data type.
 *
 * When the notification settings are defined during job creation, you can choose to notify based on a specific set of job states using the `JobStatesToNotify` array of strings, or you can specify that you want to have Amazon SNS notifications sent out for all job states with `NotifyAll` set to true.
 */
public class Notification private constructor(builder: Builder) {
    /**
     * Used to send SNS notifications for the person picking up the device (identified during job creation).
     */
    public val devicePickupSnsTopicArn: kotlin.String? = builder.devicePickupSnsTopicArn
    /**
     * The list of job states that will trigger a notification for this job.
     */
    public val jobStatesToNotify: List<JobState>? = builder.jobStatesToNotify
    /**
     * Any change in job state will trigger a notification for this job.
     */
    public val notifyAll: kotlin.Boolean = builder.notifyAll
    /**
     * The new SNS `TopicArn` that you want to associate with this job. You can create Amazon Resource Names (ARNs) for topics by using the [CreateTopic](https://docs.aws.amazon.com/sns/latest/api/API_CreateTopic.html) Amazon SNS API action.
     *
     * You can subscribe email addresses to an Amazon SNS topic through the Amazon Web Services Management Console, or by using the [Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html) Amazon Simple Notification Service (Amazon SNS) API action.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.Notification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Notification(")
        append("devicePickupSnsTopicArn=$devicePickupSnsTopicArn,")
        append("jobStatesToNotify=$jobStatesToNotify,")
        append("notifyAll=$notifyAll,")
        append("snsTopicArn=$snsTopicArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = devicePickupSnsTopicArn?.hashCode() ?: 0
        result = 31 * result + (jobStatesToNotify?.hashCode() ?: 0)
        result = 31 * result + (notifyAll.hashCode())
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Notification

        if (devicePickupSnsTopicArn != other.devicePickupSnsTopicArn) return false
        if (jobStatesToNotify != other.jobStatesToNotify) return false
        if (notifyAll != other.notifyAll) return false
        if (snsTopicArn != other.snsTopicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.Notification = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Used to send SNS notifications for the person picking up the device (identified during job creation).
         */
        public var devicePickupSnsTopicArn: kotlin.String? = null
        /**
         * The list of job states that will trigger a notification for this job.
         */
        public var jobStatesToNotify: List<JobState>? = null
        /**
         * Any change in job state will trigger a notification for this job.
         */
        public var notifyAll: kotlin.Boolean = false
        /**
         * The new SNS `TopicArn` that you want to associate with this job. You can create Amazon Resource Names (ARNs) for topics by using the [CreateTopic](https://docs.aws.amazon.com/sns/latest/api/API_CreateTopic.html) Amazon SNS API action.
         *
         * You can subscribe email addresses to an Amazon SNS topic through the Amazon Web Services Management Console, or by using the [Subscribe](https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html) Amazon Simple Notification Service (Amazon SNS) API action.
         */
        public var snsTopicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.Notification) : this() {
            this.devicePickupSnsTopicArn = x.devicePickupSnsTopicArn
            this.jobStatesToNotify = x.jobStatesToNotify
            this.notifyAll = x.notifyAll
            this.snsTopicArn = x.snsTopicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.Notification = Notification(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
