// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Each `LongTermPricingListEntry` object contains information about a long-term pricing type.
 */
public class LongTermPricingListEntry private constructor(builder: Builder) {
    /**
     * The current active jobs on the device the long-term pricing type.
     */
    public val currentActiveJob: kotlin.String? = builder.currentActiveJob
    /**
     * If set to `true`, specifies that the current long-term pricing type for the device should be automatically renewed before the long-term pricing contract expires.
     */
    public val isLongTermPricingAutoRenew: kotlin.Boolean? = builder.isLongTermPricingAutoRenew
    /**
     * The IDs of the jobs that are associated with a long-term pricing type.
     */
    public val jobIds: List<String>? = builder.jobIds
    /**
     * The end date the long-term pricing contract.
     */
    public val longTermPricingEndDate: aws.smithy.kotlin.runtime.time.Instant? = builder.longTermPricingEndDate
    /**
     * The ID of the long-term pricing type for the device.
     */
    public val longTermPricingId: kotlin.String? = builder.longTermPricingId
    /**
     * The start date of the long-term pricing contract.
     */
    public val longTermPricingStartDate: aws.smithy.kotlin.runtime.time.Instant? = builder.longTermPricingStartDate
    /**
     * The status of the long-term pricing type.
     */
    public val longTermPricingStatus: kotlin.String? = builder.longTermPricingStatus
    /**
     * The type of long-term pricing that was selected for the device.
     */
    public val longTermPricingType: aws.sdk.kotlin.services.snowball.model.LongTermPricingType? = builder.longTermPricingType
    /**
     * A new device that replaces a device that is ordered with long-term pricing.
     */
    public val replacementJob: kotlin.String? = builder.replacementJob
    /**
     * The type of Snow Family devices associated with this long-term pricing job.
     */
    public val snowballType: aws.sdk.kotlin.services.snowball.model.SnowballType? = builder.snowballType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.LongTermPricingListEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LongTermPricingListEntry(")
        append("currentActiveJob=$currentActiveJob,")
        append("isLongTermPricingAutoRenew=$isLongTermPricingAutoRenew,")
        append("jobIds=$jobIds,")
        append("longTermPricingEndDate=$longTermPricingEndDate,")
        append("longTermPricingId=$longTermPricingId,")
        append("longTermPricingStartDate=$longTermPricingStartDate,")
        append("longTermPricingStatus=$longTermPricingStatus,")
        append("longTermPricingType=$longTermPricingType,")
        append("replacementJob=$replacementJob,")
        append("snowballType=$snowballType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentActiveJob?.hashCode() ?: 0
        result = 31 * result + (isLongTermPricingAutoRenew?.hashCode() ?: 0)
        result = 31 * result + (jobIds?.hashCode() ?: 0)
        result = 31 * result + (longTermPricingEndDate?.hashCode() ?: 0)
        result = 31 * result + (longTermPricingId?.hashCode() ?: 0)
        result = 31 * result + (longTermPricingStartDate?.hashCode() ?: 0)
        result = 31 * result + (longTermPricingStatus?.hashCode() ?: 0)
        result = 31 * result + (longTermPricingType?.hashCode() ?: 0)
        result = 31 * result + (replacementJob?.hashCode() ?: 0)
        result = 31 * result + (snowballType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LongTermPricingListEntry

        if (currentActiveJob != other.currentActiveJob) return false
        if (isLongTermPricingAutoRenew != other.isLongTermPricingAutoRenew) return false
        if (jobIds != other.jobIds) return false
        if (longTermPricingEndDate != other.longTermPricingEndDate) return false
        if (longTermPricingId != other.longTermPricingId) return false
        if (longTermPricingStartDate != other.longTermPricingStartDate) return false
        if (longTermPricingStatus != other.longTermPricingStatus) return false
        if (longTermPricingType != other.longTermPricingType) return false
        if (replacementJob != other.replacementJob) return false
        if (snowballType != other.snowballType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.LongTermPricingListEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The current active jobs on the device the long-term pricing type.
         */
        public var currentActiveJob: kotlin.String? = null
        /**
         * If set to `true`, specifies that the current long-term pricing type for the device should be automatically renewed before the long-term pricing contract expires.
         */
        public var isLongTermPricingAutoRenew: kotlin.Boolean? = null
        /**
         * The IDs of the jobs that are associated with a long-term pricing type.
         */
        public var jobIds: List<String>? = null
        /**
         * The end date the long-term pricing contract.
         */
        public var longTermPricingEndDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the long-term pricing type for the device.
         */
        public var longTermPricingId: kotlin.String? = null
        /**
         * The start date of the long-term pricing contract.
         */
        public var longTermPricingStartDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the long-term pricing type.
         */
        public var longTermPricingStatus: kotlin.String? = null
        /**
         * The type of long-term pricing that was selected for the device.
         */
        public var longTermPricingType: aws.sdk.kotlin.services.snowball.model.LongTermPricingType? = null
        /**
         * A new device that replaces a device that is ordered with long-term pricing.
         */
        public var replacementJob: kotlin.String? = null
        /**
         * The type of Snow Family devices associated with this long-term pricing job.
         */
        public var snowballType: aws.sdk.kotlin.services.snowball.model.SnowballType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.LongTermPricingListEntry) : this() {
            this.currentActiveJob = x.currentActiveJob
            this.isLongTermPricingAutoRenew = x.isLongTermPricingAutoRenew
            this.jobIds = x.jobIds
            this.longTermPricingEndDate = x.longTermPricingEndDate
            this.longTermPricingId = x.longTermPricingId
            this.longTermPricingStartDate = x.longTermPricingStartDate
            this.longTermPricingStatus = x.longTermPricingStatus
            this.longTermPricingType = x.longTermPricingType
            this.replacementJob = x.replacementJob
            this.snowballType = x.snowballType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.LongTermPricingListEntry = LongTermPricingListEntry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
