// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListServiceVersionsResponse private constructor(builder: Builder) {
    /**
     * A list of names and versions of dependant services of the service for which the system provided supported versions.
     */
    public val dependentServices: List<DependentService>? = builder.dependentServices
    /**
     * Because HTTP requests are stateless, this is the starting point of the next list of returned `ListServiceVersionsResult` results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The name of the service for which the system provided supported versions.
     */
    public val serviceName: aws.sdk.kotlin.services.snowball.model.ServiceName = requireNotNull(builder.serviceName) { "A non-null value must be provided for serviceName" }
    /**
     * A list of supported versions.
     */
    public val serviceVersions: List<ServiceVersion> = requireNotNull(builder.serviceVersions) { "A non-null value must be provided for serviceVersions" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.ListServiceVersionsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListServiceVersionsResponse(")
        append("dependentServices=$dependentServices,")
        append("nextToken=$nextToken,")
        append("serviceName=$serviceName,")
        append("serviceVersions=$serviceVersions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dependentServices?.hashCode() ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (serviceName.hashCode())
        result = 31 * result + (serviceVersions.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListServiceVersionsResponse

        if (dependentServices != other.dependentServices) return false
        if (nextToken != other.nextToken) return false
        if (serviceName != other.serviceName) return false
        if (serviceVersions != other.serviceVersions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.ListServiceVersionsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of names and versions of dependant services of the service for which the system provided supported versions.
         */
        public var dependentServices: List<DependentService>? = null
        /**
         * Because HTTP requests are stateless, this is the starting point of the next list of returned `ListServiceVersionsResult` results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The name of the service for which the system provided supported versions.
         */
        public var serviceName: aws.sdk.kotlin.services.snowball.model.ServiceName? = null
        /**
         * A list of supported versions.
         */
        public var serviceVersions: List<ServiceVersion>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.ListServiceVersionsResponse) : this() {
            this.dependentServices = x.dependentServices
            this.nextToken = x.nextToken
            this.serviceName = x.serviceName
            this.serviceVersions = x.serviceVersions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.ListServiceVersionsResponse = ListServiceVersionsResponse(this)

        internal fun correctErrors(): Builder {
            if (serviceName == null) serviceName = ServiceName.SdkUnknown("no value provided")
            if (serviceVersions == null) serviceVersions = emptyList()
            return this
        }
    }
}
