// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains metadata about a specific cluster.
 */
public class ClusterMetadata private constructor(builder: Builder) {
    /**
     * The automatically generated ID for a specific address.
     */
    public val addressId: kotlin.String? = builder.addressId
    /**
     * The automatically generated ID for a cluster.
     */
    public val clusterId: kotlin.String? = builder.clusterId
    /**
     * The current status of the cluster.
     */
    public val clusterState: aws.sdk.kotlin.services.snowball.model.ClusterState? = builder.clusterState
    /**
     * The creation date for this cluster.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The optional description of the cluster.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the address that you want a cluster shipped to, after it will be shipped to its primary address. This field is not supported in most regions.
     */
    public val forwardingAddressId: kotlin.String? = builder.forwardingAddressId
    /**
     * The type of job for this cluster. Currently, the only job type supported for clusters is `LOCAL_USE`.
     */
    public val jobType: aws.sdk.kotlin.services.snowball.model.JobType? = builder.jobType
    /**
     * The `KmsKeyARN` Amazon Resource Name (ARN) associated with this cluster. This ARN was created using the [CreateKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html) API action in Key Management Service (KMS.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
     */
    public val notification: aws.sdk.kotlin.services.snowball.model.Notification? = builder.notification
    /**
     * Represents metadata and configuration settings for services on an Amazon Web Services Snow Family device.
     */
    public val onDeviceServiceConfiguration: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration? = builder.onDeviceServiceConfiguration
    /**
     * The arrays of JobResource objects that can include updated S3Resource objects or LambdaResource objects.
     */
    public val resources: aws.sdk.kotlin.services.snowball.model.JobResource? = builder.resources
    /**
     * The role ARN associated with this cluster. This ARN was created using the [CreateRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html) API action in Identity and Access Management (IAM).
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows:
     * + In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.
     * + In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.
     * + In India, Snow devices are delivered in one to seven days.
     * + In the US, you have access to one-day shipping and two-day shipping.
     */
    public val shippingOption: aws.sdk.kotlin.services.snowball.model.ShippingOption? = builder.shippingOption
    /**
     * The type of Snowcone device to use for this cluster.
     *
     * For cluster jobs, Amazon Web Services Snow Family currently supports only the `EDGE` device type.
     */
    public val snowballType: aws.sdk.kotlin.services.snowball.model.SnowballType? = builder.snowballType
    /**
     * The tax documents required in your Amazon Web Services Region.
     */
    public val taxDocuments: aws.sdk.kotlin.services.snowball.model.TaxDocuments? = builder.taxDocuments

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.snowball.model.ClusterMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterMetadata(")
        append("addressId=$addressId,")
        append("clusterId=$clusterId,")
        append("clusterState=$clusterState,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("forwardingAddressId=$forwardingAddressId,")
        append("jobType=$jobType,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("notification=$notification,")
        append("onDeviceServiceConfiguration=$onDeviceServiceConfiguration,")
        append("resources=$resources,")
        append("roleArn=$roleArn,")
        append("shippingOption=$shippingOption,")
        append("snowballType=$snowballType,")
        append("taxDocuments=$taxDocuments")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressId?.hashCode() ?: 0
        result = 31 * result + (clusterId?.hashCode() ?: 0)
        result = 31 * result + (clusterState?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (forwardingAddressId?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (notification?.hashCode() ?: 0)
        result = 31 * result + (onDeviceServiceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (shippingOption?.hashCode() ?: 0)
        result = 31 * result + (snowballType?.hashCode() ?: 0)
        result = 31 * result + (taxDocuments?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterMetadata

        if (addressId != other.addressId) return false
        if (clusterId != other.clusterId) return false
        if (clusterState != other.clusterState) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (forwardingAddressId != other.forwardingAddressId) return false
        if (jobType != other.jobType) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (notification != other.notification) return false
        if (onDeviceServiceConfiguration != other.onDeviceServiceConfiguration) return false
        if (resources != other.resources) return false
        if (roleArn != other.roleArn) return false
        if (shippingOption != other.shippingOption) return false
        if (snowballType != other.snowballType) return false
        if (taxDocuments != other.taxDocuments) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.snowball.model.ClusterMetadata = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The automatically generated ID for a specific address.
         */
        public var addressId: kotlin.String? = null
        /**
         * The automatically generated ID for a cluster.
         */
        public var clusterId: kotlin.String? = null
        /**
         * The current status of the cluster.
         */
        public var clusterState: aws.sdk.kotlin.services.snowball.model.ClusterState? = null
        /**
         * The creation date for this cluster.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The optional description of the cluster.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the address that you want a cluster shipped to, after it will be shipped to its primary address. This field is not supported in most regions.
         */
        public var forwardingAddressId: kotlin.String? = null
        /**
         * The type of job for this cluster. Currently, the only job type supported for clusters is `LOCAL_USE`.
         */
        public var jobType: aws.sdk.kotlin.services.snowball.model.JobType? = null
        /**
         * The `KmsKeyARN` Amazon Resource Name (ARN) associated with this cluster. This ARN was created using the [CreateKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html) API action in Key Management Service (KMS.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The Amazon Simple Notification Service (Amazon SNS) notification settings for this cluster.
         */
        public var notification: aws.sdk.kotlin.services.snowball.model.Notification? = null
        /**
         * Represents metadata and configuration settings for services on an Amazon Web Services Snow Family device.
         */
        public var onDeviceServiceConfiguration: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration? = null
        /**
         * The arrays of JobResource objects that can include updated S3Resource objects or LambdaResource objects.
         */
        public var resources: aws.sdk.kotlin.services.snowball.model.JobResource? = null
        /**
         * The role ARN associated with this cluster. This ARN was created using the [CreateRole](https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html) API action in Identity and Access Management (IAM).
         */
        public var roleArn: kotlin.String? = null
        /**
         * The shipping speed for each node in this cluster. This speed doesn't dictate how soon you'll get each device, rather it represents how quickly each device moves to its destination while in transit. Regional shipping speeds are as follows:
         * + In Australia, you have access to express shipping. Typically, devices shipped express are delivered in about a day.
         * + In the European Union (EU), you have access to express shipping. Typically, Snow devices shipped express are delivered in about a day. In addition, most countries in the EU have access to standard shipping, which typically takes less than a week, one way.
         * + In India, Snow devices are delivered in one to seven days.
         * + In the US, you have access to one-day shipping and two-day shipping.
         */
        public var shippingOption: aws.sdk.kotlin.services.snowball.model.ShippingOption? = null
        /**
         * The type of Snowcone device to use for this cluster.
         *
         * For cluster jobs, Amazon Web Services Snow Family currently supports only the `EDGE` device type.
         */
        public var snowballType: aws.sdk.kotlin.services.snowball.model.SnowballType? = null
        /**
         * The tax documents required in your Amazon Web Services Region.
         */
        public var taxDocuments: aws.sdk.kotlin.services.snowball.model.TaxDocuments? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.snowball.model.ClusterMetadata) : this() {
            this.addressId = x.addressId
            this.clusterId = x.clusterId
            this.clusterState = x.clusterState
            this.creationDate = x.creationDate
            this.description = x.description
            this.forwardingAddressId = x.forwardingAddressId
            this.jobType = x.jobType
            this.kmsKeyArn = x.kmsKeyArn
            this.notification = x.notification
            this.onDeviceServiceConfiguration = x.onDeviceServiceConfiguration
            this.resources = x.resources
            this.roleArn = x.roleArn
            this.shippingOption = x.shippingOption
            this.snowballType = x.snowballType
            this.taxDocuments = x.taxDocuments
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.snowball.model.ClusterMetadata = ClusterMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.Notification] inside the given [block]
         */
        public fun notification(block: aws.sdk.kotlin.services.snowball.model.Notification.Builder.() -> kotlin.Unit) {
            this.notification = aws.sdk.kotlin.services.snowball.model.Notification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration] inside the given [block]
         */
        public fun onDeviceServiceConfiguration(block: aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration.Builder.() -> kotlin.Unit) {
            this.onDeviceServiceConfiguration = aws.sdk.kotlin.services.snowball.model.OnDeviceServiceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.JobResource] inside the given [block]
         */
        public fun resources(block: aws.sdk.kotlin.services.snowball.model.JobResource.Builder.() -> kotlin.Unit) {
            this.resources = aws.sdk.kotlin.services.snowball.model.JobResource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.snowball.model.TaxDocuments] inside the given [block]
         */
        public fun taxDocuments(block: aws.sdk.kotlin.services.snowball.model.TaxDocuments.Builder.() -> kotlin.Unit) {
            this.taxDocuments = aws.sdk.kotlin.services.snowball.model.TaxDocuments.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
