// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.snowball.auth.DefaultSnowballAuthSchemeProvider
import aws.sdk.kotlin.services.snowball.auth.SnowballAuthSchemeProvider
import aws.sdk.kotlin.services.snowball.endpoints.DefaultSnowballEndpointProvider
import aws.sdk.kotlin.services.snowball.endpoints.SnowballEndpointParameters
import aws.sdk.kotlin.services.snowball.endpoints.SnowballEndpointProvider
import aws.sdk.kotlin.services.snowball.model.CancelClusterRequest
import aws.sdk.kotlin.services.snowball.model.CancelClusterResponse
import aws.sdk.kotlin.services.snowball.model.CancelJobRequest
import aws.sdk.kotlin.services.snowball.model.CancelJobResponse
import aws.sdk.kotlin.services.snowball.model.CreateAddressRequest
import aws.sdk.kotlin.services.snowball.model.CreateAddressResponse
import aws.sdk.kotlin.services.snowball.model.CreateClusterRequest
import aws.sdk.kotlin.services.snowball.model.CreateClusterResponse
import aws.sdk.kotlin.services.snowball.model.CreateJobRequest
import aws.sdk.kotlin.services.snowball.model.CreateJobResponse
import aws.sdk.kotlin.services.snowball.model.CreateLongTermPricingRequest
import aws.sdk.kotlin.services.snowball.model.CreateLongTermPricingResponse
import aws.sdk.kotlin.services.snowball.model.CreateReturnShippingLabelRequest
import aws.sdk.kotlin.services.snowball.model.CreateReturnShippingLabelResponse
import aws.sdk.kotlin.services.snowball.model.DescribeAddressRequest
import aws.sdk.kotlin.services.snowball.model.DescribeAddressResponse
import aws.sdk.kotlin.services.snowball.model.DescribeAddressesRequest
import aws.sdk.kotlin.services.snowball.model.DescribeAddressesResponse
import aws.sdk.kotlin.services.snowball.model.DescribeClusterRequest
import aws.sdk.kotlin.services.snowball.model.DescribeClusterResponse
import aws.sdk.kotlin.services.snowball.model.DescribeJobRequest
import aws.sdk.kotlin.services.snowball.model.DescribeJobResponse
import aws.sdk.kotlin.services.snowball.model.DescribeReturnShippingLabelRequest
import aws.sdk.kotlin.services.snowball.model.DescribeReturnShippingLabelResponse
import aws.sdk.kotlin.services.snowball.model.GetJobManifestRequest
import aws.sdk.kotlin.services.snowball.model.GetJobManifestResponse
import aws.sdk.kotlin.services.snowball.model.GetJobUnlockCodeRequest
import aws.sdk.kotlin.services.snowball.model.GetJobUnlockCodeResponse
import aws.sdk.kotlin.services.snowball.model.GetSnowballUsageRequest
import aws.sdk.kotlin.services.snowball.model.GetSnowballUsageResponse
import aws.sdk.kotlin.services.snowball.model.GetSoftwareUpdatesRequest
import aws.sdk.kotlin.services.snowball.model.GetSoftwareUpdatesResponse
import aws.sdk.kotlin.services.snowball.model.ListClusterJobsRequest
import aws.sdk.kotlin.services.snowball.model.ListClusterJobsResponse
import aws.sdk.kotlin.services.snowball.model.ListClustersRequest
import aws.sdk.kotlin.services.snowball.model.ListClustersResponse
import aws.sdk.kotlin.services.snowball.model.ListCompatibleImagesRequest
import aws.sdk.kotlin.services.snowball.model.ListCompatibleImagesResponse
import aws.sdk.kotlin.services.snowball.model.ListJobsRequest
import aws.sdk.kotlin.services.snowball.model.ListJobsResponse
import aws.sdk.kotlin.services.snowball.model.ListLongTermPricingRequest
import aws.sdk.kotlin.services.snowball.model.ListLongTermPricingResponse
import aws.sdk.kotlin.services.snowball.model.ListPickupLocationsRequest
import aws.sdk.kotlin.services.snowball.model.ListPickupLocationsResponse
import aws.sdk.kotlin.services.snowball.model.ListServiceVersionsRequest
import aws.sdk.kotlin.services.snowball.model.ListServiceVersionsResponse
import aws.sdk.kotlin.services.snowball.model.UpdateClusterRequest
import aws.sdk.kotlin.services.snowball.model.UpdateClusterResponse
import aws.sdk.kotlin.services.snowball.model.UpdateJobRequest
import aws.sdk.kotlin.services.snowball.model.UpdateJobResponse
import aws.sdk.kotlin.services.snowball.model.UpdateJobShipmentStateRequest
import aws.sdk.kotlin.services.snowball.model.UpdateJobShipmentStateResponse
import aws.sdk.kotlin.services.snowball.model.UpdateLongTermPricingRequest
import aws.sdk.kotlin.services.snowball.model.UpdateLongTermPricingResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Snowball"
public const val SdkVersion: String = "1.1.26"
public const val ServiceApiVersion: String = "2016-06-30"

/**
 * The Amazon Web Services Snow Family provides a petabyte-scale data transport solution that uses secure devices to transfer large amounts of data between your on-premises data centers and Amazon Simple Storage Service (Amazon S3). The Snow Family commands described here provide access to the same functionality that is available in the Amazon Web Services Snow Family Management Console, which enables you to create and manage jobs for a Snow Family device. To transfer data locally with a Snow Family device, you'll need to use the Snowball Edge client or the Amazon S3 API Interface for Snowball or OpsHub for Snow Family. For more information, see the [User Guide](https://docs.aws.amazon.com/AWSImportExport/latest/ug/api-reference.html).
 */
public interface SnowballClient : SdkClient {
    /**
     * SnowballClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SnowballClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Snowball",
                "SNOWBALL",
                "snowball",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SnowballClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SnowballClient = DefaultSnowballClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SnowballEndpointProvider = builder.endpointProvider ?: DefaultSnowballEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SnowballAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSnowballAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Snowball"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SnowballEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SnowballAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels a cluster job. You can only cancel a cluster job while it's in the `AwaitingQuorum` status. You'll have at least an hour after creating a cluster job to cancel it.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.CancelCluster.sample
     */
    public suspend fun cancelCluster(input: CancelClusterRequest): CancelClusterResponse

    /**
     * Cancels the specified job. You can only cancel a job before its `JobState` value changes to `PreparingAppliance`. Requesting the `ListJobs` or `DescribeJob` action returns a job's `JobState` as part of the response element data returned.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.CancelJob.sample
     */
    public suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse

    /**
     * Creates an address for a Snow device to be shipped to. In most regions, addresses are validated at the time of creation. The address you provide must be located within the serviceable area of your region. If the address is invalid or unsupported, then an exception is thrown. If providing an address as a JSON file through the `cli-input-json` option, include the full file path. For example, `--cli-input-json file://create-address.json`.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.CreateAddress.sample
     */
    public suspend fun createAddress(input: CreateAddressRequest): CreateAddressResponse

    /**
     * Creates an empty cluster. Each cluster supports five nodes. You use the CreateJob action separately to create the jobs for each of these nodes. The cluster does not ship until these five node jobs have been created.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.CreateCluster.sample
     */
    public suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse

    /**
     * Creates a job to import or export data between Amazon S3 and your on-premises data center. Your Amazon Web Services account must have the right trust policies and permissions in place to create a job for a Snow device. If you're creating a job for a node in a cluster, you only need to provide the `clusterId` value; the other job attributes are inherited from the cluster.
     *
     * Only the Snowball; Edge device type is supported when ordering clustered jobs.
     *
     * The device capacity is optional.
     *
     * Availability of device types differ by Amazon Web Services Region. For more information about Region availability, see [Amazon Web Services Regional Services](https://aws.amazon.com/about-aws/global-infrastructure/regional-product-services/?p=ngi&loc=4).
     *
     * **Snow Family devices and their capacities.**
     * + Device type: **SNC1_SSD**
     *    + Capacity: T14
     *    + Description: Snowcone
     * + Device type: **SNC1_HDD**
     *    + Capacity: T8
     *    + Description: Snowcone
     * + Device type: **EDGE_S**
     *    + Capacity: T98
     *    + Description: Snowball Edge Storage Optimized for data transfer only
     * + Device type: **EDGE_CG**
     *    + Capacity: T42
     *    + Description: Snowball Edge Compute Optimized with GPU
     * + Device type: **EDGE_C**
     *    + Capacity: T42
     *    + Description: Snowball Edge Compute Optimized without GPU
     * + Device type: **EDGE**
     *    + Capacity: T100
     *    + Description: Snowball Edge Storage Optimized with EC2 Compute
     * This device is replaced with T98.
     * + Device type: **STANDARD**
     *    + Capacity: T50
     *    + Description: Original Snowball deviceThis device is only available in the Ningxia, Beijing, and Singapore Amazon Web Services Region
     * + Device type: **STANDARD**
     *    + Capacity: T80
     *    + Description: Original Snowball deviceThis device is only available in the Ningxia, Beijing, and Singapore Amazon Web Services Region.
     * + Snow Family device type: **RACK_5U_C**
     *    + Capacity: T13
     *    + Description: Snowblade.
     * + Device type: **V3_5S**
     *    + Capacity: T240
     *    + Description: Snowball Edge Storage Optimized 210TB
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.CreateJob.sample
     */
    public suspend fun createJob(input: CreateJobRequest = CreateJobRequest { }): CreateJobResponse

    /**
     * Creates a job with the long-term usage option for a device. The long-term usage is a 1-year or 3-year long-term pricing type for the device. You are billed upfront, and Amazon Web Services provides discounts for long-term pricing.
     */
    public suspend fun createLongTermPricing(input: CreateLongTermPricingRequest): CreateLongTermPricingResponse

    /**
     * Creates a shipping label that will be used to return the Snow device to Amazon Web Services.
     */
    public suspend fun createReturnShippingLabel(input: CreateReturnShippingLabelRequest): CreateReturnShippingLabelResponse

    /**
     * Takes an `AddressId` and returns specific details about that address in the form of an `Address` object.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.DescribeAddress.sample
     */
    public suspend fun describeAddress(input: DescribeAddressRequest): DescribeAddressResponse

    /**
     * Returns a specified number of `ADDRESS` objects. Calling this API in one of the US regions will return addresses from the list of all addresses associated with this account in all US regions.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.DescribeAddresses.sample
     */
    public suspend fun describeAddresses(input: DescribeAddressesRequest = DescribeAddressesRequest { }): DescribeAddressesResponse

    /**
     * Returns information about a specific cluster including shipping information, cluster status, and other important metadata.
     */
    public suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse

    /**
     * Returns information about a specific job including shipping information, job status, and other important metadata.
     */
    public suspend fun describeJob(input: DescribeJobRequest): DescribeJobResponse

    /**
     * Information on the shipping label of a Snow device that is being returned to Amazon Web Services.
     */
    public suspend fun describeReturnShippingLabel(input: DescribeReturnShippingLabelRequest): DescribeReturnShippingLabelResponse

    /**
     * Returns a link to an Amazon S3 presigned URL for the manifest file associated with the specified `JobId` value. You can access the manifest file for up to 60 minutes after this request has been made. To access the manifest file after 60 minutes have passed, you'll have to make another call to the `GetJobManifest` action.
     *
     * The manifest is an encrypted file that you can download after your job enters the `WithCustomer` status. This is the only valid status for calling this API as the manifest and `UnlockCode` code value are used for securing your device and should only be used when you have the device. The manifest is decrypted by using the `UnlockCode` code value, when you pass both values to the Snow device through the Snowball client when the client is started for the first time.
     *
     * As a best practice, we recommend that you don't save a copy of an `UnlockCode` value in the same location as the manifest file for that job. Saving these separately helps prevent unauthorized parties from gaining access to the Snow device associated with that job.
     *
     * The credentials of a given job, including its manifest file and unlock code, expire 360 days after the job is created.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.GetJobManifest.sample
     */
    public suspend fun getJobManifest(input: GetJobManifestRequest): GetJobManifestResponse

    /**
     * Returns the `UnlockCode` code value for the specified job. A particular `UnlockCode` value can be accessed for up to 360 days after the associated job has been created.
     *
     * The `UnlockCode` value is a 29-character code with 25 alphanumeric characters and 4 hyphens. This code is used to decrypt the manifest file when it is passed along with the manifest to the Snow device through the Snowball client when the client is started for the first time. The only valid status for calling this API is `WithCustomer` as the manifest and `Unlock` code values are used for securing your device and should only be used when you have the device.
     *
     * As a best practice, we recommend that you don't save a copy of the `UnlockCode` in the same location as the manifest file for that job. Saving these separately helps prevent unauthorized parties from gaining access to the Snow device associated with that job.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.GetJobUnlockCode.sample
     */
    public suspend fun getJobUnlockCode(input: GetJobUnlockCodeRequest): GetJobUnlockCodeResponse

    /**
     * Returns information about the Snow Family service limit for your account, and also the number of Snow devices your account has in use.
     *
     * The default service limit for the number of Snow devices that you can have at one time is 1. If you want to increase your service limit, contact Amazon Web Services Support.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.GetSnowballUsage.sample
     */
    public suspend fun getSnowballUsage(input: GetSnowballUsageRequest = GetSnowballUsageRequest { }): GetSnowballUsageResponse

    /**
     * Returns an Amazon S3 presigned URL for an update file associated with a specified `JobId`.
     */
    public suspend fun getSoftwareUpdates(input: GetSoftwareUpdatesRequest): GetSoftwareUpdatesResponse

    /**
     * Returns an array of `JobListEntry` objects of the specified length. Each `JobListEntry` object is for a job in the specified cluster and contains a job's state, a job's ID, and other information.
     */
    public suspend fun listClusterJobs(input: ListClusterJobsRequest): ListClusterJobsResponse

    /**
     * Returns an array of `ClusterListEntry` objects of the specified length. Each `ClusterListEntry` object contains a cluster's state, a cluster's ID, and other important status information.
     */
    public suspend fun listClusters(input: ListClustersRequest = ListClustersRequest { }): ListClustersResponse

    /**
     * This action returns a list of the different Amazon EC2-compatible Amazon Machine Images (AMIs) that are owned by your Amazon Web Services accountthat would be supported for use on a Snow device. Currently, supported AMIs are based on the Amazon Linux-2, Ubuntu 20.04 LTS - Focal, or Ubuntu 22.04 LTS - Jammy images, available on the Amazon Web Services Marketplace. Ubuntu 16.04 LTS - Xenial (HVM) images are no longer supported in the Market, but still supported for use on devices through Amazon EC2 VM Import/Export and running locally in AMIs.
     */
    public suspend fun listCompatibleImages(input: ListCompatibleImagesRequest = ListCompatibleImagesRequest { }): ListCompatibleImagesResponse

    /**
     * Returns an array of `JobListEntry` objects of the specified length. Each `JobListEntry` object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case of export jobs. Calling this API action in one of the US regions will return jobs from the list of all jobs associated with this account in all US regions.
     */
    public suspend fun listJobs(input: ListJobsRequest = ListJobsRequest { }): ListJobsResponse

    /**
     * Lists all long-term pricing types.
     */
    public suspend fun listLongTermPricing(input: ListLongTermPricingRequest = ListLongTermPricingRequest { }): ListLongTermPricingResponse

    /**
     * A list of locations from which the customer can choose to pickup a device.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.ListPickupLocations.sample
     */
    public suspend fun listPickupLocations(input: ListPickupLocationsRequest = ListPickupLocationsRequest { }): ListPickupLocationsResponse

    /**
     * Lists all supported versions for Snow on-device services. Returns an array of `ServiceVersion` object containing the supported versions for a particular service.
     */
    public suspend fun listServiceVersions(input: ListServiceVersionsRequest): ListServiceVersionsResponse

    /**
     * While a cluster's `ClusterState` value is in the `AwaitingQuorum` state, you can update some of the information associated with a cluster. Once the cluster changes to a different job state, usually 60 minutes after the cluster being created, this action is no longer available.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.UpdateCluster.sample
     */
    public suspend fun updateCluster(input: UpdateClusterRequest): UpdateClusterResponse

    /**
     * While a job's `JobState` value is `New`, you can update some of the information associated with a job. Once the job changes to a different job state, usually within 60 minutes of the job being created, this action is no longer available.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.UpdateJob.sample
     */
    public suspend fun updateJob(input: UpdateJobRequest): UpdateJobResponse

    /**
     * Updates the state when a shipment state changes to a different state.
     */
    public suspend fun updateJobShipmentState(input: UpdateJobShipmentStateRequest): UpdateJobShipmentStateResponse

    /**
     * Updates the long-term pricing type.
     */
    public suspend fun updateLongTermPricing(input: UpdateLongTermPricingRequest): UpdateLongTermPricingResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SnowballClient.withConfig(block: SnowballClient.Config.Builder.() -> Unit): SnowballClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSnowballClient(newConfig)
}

/**
 * Cancels a cluster job. You can only cancel a cluster job while it's in the `AwaitingQuorum` status. You'll have at least an hour after creating a cluster job to cancel it.
 *
 * @sample aws.sdk.kotlin.services.snowball.samples.CancelCluster.sample
 */
public suspend inline fun SnowballClient.cancelCluster(crossinline block: CancelClusterRequest.Builder.() -> Unit): CancelClusterResponse = cancelCluster(CancelClusterRequest.Builder().apply(block).build())

/**
 * Cancels the specified job. You can only cancel a job before its `JobState` value changes to `PreparingAppliance`. Requesting the `ListJobs` or `DescribeJob` action returns a job's `JobState` as part of the response element data returned.
 *
 * @sample aws.sdk.kotlin.services.snowball.samples.CancelJob.sample
 */
public suspend inline fun SnowballClient.cancelJob(crossinline block: CancelJobRequest.Builder.() -> Unit): CancelJobResponse = cancelJob(CancelJobRequest.Builder().apply(block).build())

/**
 * Creates an address for a Snow device to be shipped to. In most regions, addresses are validated at the time of creation. The address you provide must be located within the serviceable area of your region. If the address is invalid or unsupported, then an exception is thrown. If providing an address as a JSON file through the `cli-input-json` option, include the full file path. For example, `--cli-input-json file://create-address.json`.
 *
 * @sample aws.sdk.kotlin.services.snowball.samples.CreateAddress.sample
 */
public suspend inline fun SnowballClient.createAddress(crossinline block: CreateAddressRequest.Builder.() -> Unit): CreateAddressResponse = createAddress(CreateAddressRequest.Builder().apply(block).build())

/**
 * Creates an empty cluster. Each cluster supports five nodes. You use the CreateJob action separately to create the jobs for each of these nodes. The cluster does not ship until these five node jobs have been created.
 *
 * @sample aws.sdk.kotlin.services.snowball.samples.CreateCluster.sample
 */
public suspend inline fun SnowballClient.createCluster(crossinline block: CreateClusterRequest.Builder.() -> Unit): CreateClusterResponse = createCluster(CreateClusterRequest.Builder().apply(block).build())

/**
 * Creates a job to import or export data between Amazon S3 and your on-premises data center. Your Amazon Web Services account must have the right trust policies and permissions in place to create a job for a Snow device. If you're creating a job for a node in a cluster, you only need to provide the `clusterId` value; the other job attributes are inherited from the cluster.
 *
 * Only the Snowball; Edge device type is supported when ordering clustered jobs.
 *
 * The device capacity is optional.
 *
 * Availability of device types differ by Amazon Web Services Region. For more information about Region availability, see [Amazon Web Services Regional Services](https://aws.amazon.com/about-aws/global-infrastructure/regional-product-services/?p=ngi&loc=4).
 *
 * **Snow Family devices and their capacities.**
 * + Device type: **SNC1_SSD**
 *    + Capacity: T14
 *    + Description: Snowcone
 * + Device type: **SNC1_HDD**
 *    + Capacity: T8
 *    + Description: Snowcone
 * + Device type: **EDGE_S**
 *    + Capacity: T98
 *    + Description: Snowball Edge Storage Optimized for data transfer only
 * + Device type: **EDGE_CG**
 *    + Capacity: T42
 *    + Description: Snowball Edge Compute Optimized with GPU
 * + Device type: **EDGE_C**
 *    + Capacity: T42
 *    + Description: Snowball Edge Compute Optimized without GPU
 * + Device type: **EDGE**
 *    + Capacity: T100
 *    + Description: Snowball Edge Storage Optimized with EC2 Compute
 * This device is replaced with T98.
 * + Device type: **STANDARD**
 *    + Capacity: T50
 *    + Description: Original Snowball deviceThis device is only available in the Ningxia, Beijing, and Singapore Amazon Web Services Region
 * + Device type: **STANDARD**
 *    + Capacity: T80
 *    + Description: Original Snowball deviceThis device is only available in the Ningxia, Beijing, and Singapore Amazon Web Services Region.
 * + Snow Family device type: **RACK_5U_C**
 *    + Capacity: T13
 *    + Description: Snowblade.
 * + Device type: **V3_5S**
 *    + Capacity: T240
 *    + Description: Snowball Edge Storage Optimized 210TB
 *
 * @sample aws.sdk.kotlin.services.snowball.samples.CreateJob.sample
 */
public suspend inline fun SnowballClient.createJob(crossinline block: CreateJobRequest.Builder.() -> Unit): CreateJobResponse = createJob(CreateJobRequest.Builder().apply(block).build())

/**
 * Creates a job with the long-term usage option for a device. The long-term usage is a 1-year or 3-year long-term pricing type for the device. You are billed upfront, and Amazon Web Services provides discounts for long-term pricing.
 */
public suspend inline fun SnowballClient.createLongTermPricing(crossinline block: CreateLongTermPricingRequest.Builder.() -> Unit): CreateLongTermPricingResponse = createLongTermPricing(CreateLongTermPricingRequest.Builder().apply(block).build())

/**
 * Creates a shipping label that will be used to return the Snow device to Amazon Web Services.
 */
public suspend inline fun SnowballClient.createReturnShippingLabel(crossinline block: CreateReturnShippingLabelRequest.Builder.() -> Unit): CreateReturnShippingLabelResponse = createReturnShippingLabel(CreateReturnShippingLabelRequest.Builder().apply(block).build())

/**
 * Takes an `AddressId` and returns specific details about that address in the form of an `Address` object.
 *
 * @sample aws.sdk.kotlin.services.snowball.samples.DescribeAddress.sample
 */
public suspend inline fun SnowballClient.describeAddress(crossinline block: DescribeAddressRequest.Builder.() -> Unit): DescribeAddressResponse = describeAddress(DescribeAddressRequest.Builder().apply(block).build())

/**
 * Returns a specified number of `ADDRESS` objects. Calling this API in one of the US regions will return addresses from the list of all addresses associated with this account in all US regions.
 *
 * @sample aws.sdk.kotlin.services.snowball.samples.DescribeAddresses.sample
 */
public suspend inline fun SnowballClient.describeAddresses(crossinline block: DescribeAddressesRequest.Builder.() -> Unit): DescribeAddressesResponse = describeAddresses(DescribeAddressesRequest.Builder().apply(block).build())

/**
 * Returns information about a specific cluster including shipping information, cluster status, and other important metadata.
 */
public suspend inline fun SnowballClient.describeCluster(crossinline block: DescribeClusterRequest.Builder.() -> Unit): DescribeClusterResponse = describeCluster(DescribeClusterRequest.Builder().apply(block).build())

/**
 * Returns information about a specific job including shipping information, job status, and other important metadata.
 */
public suspend inline fun SnowballClient.describeJob(crossinline block: DescribeJobRequest.Builder.() -> Unit): DescribeJobResponse = describeJob(DescribeJobRequest.Builder().apply(block).build())

/**
 * Information on the shipping label of a Snow device that is being returned to Amazon Web Services.
 */
public suspend inline fun SnowballClient.describeReturnShippingLabel(crossinline block: DescribeReturnShippingLabelRequest.Builder.() -> Unit): DescribeReturnShippingLabelResponse = describeReturnShippingLabel(DescribeReturnShippingLabelRequest.Builder().apply(block).build())

/**
 * Returns a link to an Amazon S3 presigned URL for the manifest file associated with the specified `JobId` value. You can access the manifest file for up to 60 minutes after this request has been made. To access the manifest file after 60 minutes have passed, you'll have to make another call to the `GetJobManifest` action.
 *
 * The manifest is an encrypted file that you can download after your job enters the `WithCustomer` status. This is the only valid status for calling this API as the manifest and `UnlockCode` code value are used for securing your device and should only be used when you have the device. The manifest is decrypted by using the `UnlockCode` code value, when you pass both values to the Snow device through the Snowball client when the client is started for the first time.
 *
 * As a best practice, we recommend that you don't save a copy of an `UnlockCode` value in the same location as the manifest file for that job. Saving these separately helps prevent unauthorized parties from gaining access to the Snow device associated with that job.
 *
 * The credentials of a given job, including its manifest file and unlock code, expire 360 days after the job is created.
 *
 * @sample aws.sdk.kotlin.services.snowball.samples.GetJobManifest.sample
 */
public suspend inline fun SnowballClient.getJobManifest(crossinline block: GetJobManifestRequest.Builder.() -> Unit): GetJobManifestResponse = getJobManifest(GetJobManifestRequest.Builder().apply(block).build())

/**
 * Returns the `UnlockCode` code value for the specified job. A particular `UnlockCode` value can be accessed for up to 360 days after the associated job has been created.
 *
 * The `UnlockCode` value is a 29-character code with 25 alphanumeric characters and 4 hyphens. This code is used to decrypt the manifest file when it is passed along with the manifest to the Snow device through the Snowball client when the client is started for the first time. The only valid status for calling this API is `WithCustomer` as the manifest and `Unlock` code values are used for securing your device and should only be used when you have the device.
 *
 * As a best practice, we recommend that you don't save a copy of the `UnlockCode` in the same location as the manifest file for that job. Saving these separately helps prevent unauthorized parties from gaining access to the Snow device associated with that job.
 *
 * @sample aws.sdk.kotlin.services.snowball.samples.GetJobUnlockCode.sample
 */
public suspend inline fun SnowballClient.getJobUnlockCode(crossinline block: GetJobUnlockCodeRequest.Builder.() -> Unit): GetJobUnlockCodeResponse = getJobUnlockCode(GetJobUnlockCodeRequest.Builder().apply(block).build())

/**
 * Returns information about the Snow Family service limit for your account, and also the number of Snow devices your account has in use.
 *
 * The default service limit for the number of Snow devices that you can have at one time is 1. If you want to increase your service limit, contact Amazon Web Services Support.
 *
 * @sample aws.sdk.kotlin.services.snowball.samples.GetSnowballUsage.sample
 */
public suspend inline fun SnowballClient.getSnowballUsage(crossinline block: GetSnowballUsageRequest.Builder.() -> Unit): GetSnowballUsageResponse = getSnowballUsage(GetSnowballUsageRequest.Builder().apply(block).build())

/**
 * Returns an Amazon S3 presigned URL for an update file associated with a specified `JobId`.
 */
public suspend inline fun SnowballClient.getSoftwareUpdates(crossinline block: GetSoftwareUpdatesRequest.Builder.() -> Unit): GetSoftwareUpdatesResponse = getSoftwareUpdates(GetSoftwareUpdatesRequest.Builder().apply(block).build())

/**
 * Returns an array of `JobListEntry` objects of the specified length. Each `JobListEntry` object is for a job in the specified cluster and contains a job's state, a job's ID, and other information.
 */
public suspend inline fun SnowballClient.listClusterJobs(crossinline block: ListClusterJobsRequest.Builder.() -> Unit): ListClusterJobsResponse = listClusterJobs(ListClusterJobsRequest.Builder().apply(block).build())

/**
 * Returns an array of `ClusterListEntry` objects of the specified length. Each `ClusterListEntry` object contains a cluster's state, a cluster's ID, and other important status information.
 */
public suspend inline fun SnowballClient.listClusters(crossinline block: ListClustersRequest.Builder.() -> Unit): ListClustersResponse = listClusters(ListClustersRequest.Builder().apply(block).build())

/**
 * This action returns a list of the different Amazon EC2-compatible Amazon Machine Images (AMIs) that are owned by your Amazon Web Services accountthat would be supported for use on a Snow device. Currently, supported AMIs are based on the Amazon Linux-2, Ubuntu 20.04 LTS - Focal, or Ubuntu 22.04 LTS - Jammy images, available on the Amazon Web Services Marketplace. Ubuntu 16.04 LTS - Xenial (HVM) images are no longer supported in the Market, but still supported for use on devices through Amazon EC2 VM Import/Export and running locally in AMIs.
 */
public suspend inline fun SnowballClient.listCompatibleImages(crossinline block: ListCompatibleImagesRequest.Builder.() -> Unit): ListCompatibleImagesResponse = listCompatibleImages(ListCompatibleImagesRequest.Builder().apply(block).build())

/**
 * Returns an array of `JobListEntry` objects of the specified length. Each `JobListEntry` object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case of export jobs. Calling this API action in one of the US regions will return jobs from the list of all jobs associated with this account in all US regions.
 */
public suspend inline fun SnowballClient.listJobs(crossinline block: ListJobsRequest.Builder.() -> Unit): ListJobsResponse = listJobs(ListJobsRequest.Builder().apply(block).build())

/**
 * Lists all long-term pricing types.
 */
public suspend inline fun SnowballClient.listLongTermPricing(crossinline block: ListLongTermPricingRequest.Builder.() -> Unit): ListLongTermPricingResponse = listLongTermPricing(ListLongTermPricingRequest.Builder().apply(block).build())

/**
 * A list of locations from which the customer can choose to pickup a device.
 *
 * @sample aws.sdk.kotlin.services.snowball.samples.ListPickupLocations.sample
 */
public suspend inline fun SnowballClient.listPickupLocations(crossinline block: ListPickupLocationsRequest.Builder.() -> Unit): ListPickupLocationsResponse = listPickupLocations(ListPickupLocationsRequest.Builder().apply(block).build())

/**
 * Lists all supported versions for Snow on-device services. Returns an array of `ServiceVersion` object containing the supported versions for a particular service.
 */
public suspend inline fun SnowballClient.listServiceVersions(crossinline block: ListServiceVersionsRequest.Builder.() -> Unit): ListServiceVersionsResponse = listServiceVersions(ListServiceVersionsRequest.Builder().apply(block).build())

/**
 * While a cluster's `ClusterState` value is in the `AwaitingQuorum` state, you can update some of the information associated with a cluster. Once the cluster changes to a different job state, usually 60 minutes after the cluster being created, this action is no longer available.
 *
 * @sample aws.sdk.kotlin.services.snowball.samples.UpdateCluster.sample
 */
public suspend inline fun SnowballClient.updateCluster(crossinline block: UpdateClusterRequest.Builder.() -> Unit): UpdateClusterResponse = updateCluster(UpdateClusterRequest.Builder().apply(block).build())

/**
 * While a job's `JobState` value is `New`, you can update some of the information associated with a job. Once the job changes to a different job state, usually within 60 minutes of the job being created, this action is no longer available.
 *
 * @sample aws.sdk.kotlin.services.snowball.samples.UpdateJob.sample
 */
public suspend inline fun SnowballClient.updateJob(crossinline block: UpdateJobRequest.Builder.() -> Unit): UpdateJobResponse = updateJob(UpdateJobRequest.Builder().apply(block).build())

/**
 * Updates the state when a shipment state changes to a different state.
 */
public suspend inline fun SnowballClient.updateJobShipmentState(crossinline block: UpdateJobShipmentStateRequest.Builder.() -> Unit): UpdateJobShipmentStateResponse = updateJobShipmentState(UpdateJobShipmentStateRequest.Builder().apply(block).build())

/**
 * Updates the long-term pricing type.
 */
public suspend inline fun SnowballClient.updateLongTermPricing(crossinline block: UpdateLongTermPricingRequest.Builder.() -> Unit): UpdateLongTermPricingResponse = updateLongTermPricing(UpdateLongTermPricingRequest.Builder().apply(block).build())
