// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.snowball.auth.SnowballAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.snowball.auth.SnowballIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.snowball.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.snowball.model.*
import aws.sdk.kotlin.services.snowball.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultSnowballClient(override val config: SnowballClient.Config) : SnowballClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = SnowballIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "snowball")
        }
        toMap()
    }
    private val authSchemeAdapter = SnowballAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.snowball"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Cancels a cluster job. You can only cancel a cluster job while it's in the `AwaitingQuorum` status. You'll have at least an hour after creating a cluster job to cancel it.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.CancelCluster.sample
     */
    override suspend fun cancelCluster(input: CancelClusterRequest): CancelClusterResponse {
        val op = SdkHttpOperation.build<CancelClusterRequest, CancelClusterResponse> {
            serializeWith = CancelClusterOperationSerializer()
            deserializeWith = CancelClusterOperationDeserializer()
            operationName = "CancelCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Cancels the specified job. You can only cancel a job before its `JobState` value changes to `PreparingAppliance`. Requesting the `ListJobs` or `DescribeJob` action returns a job's `JobState` as part of the response element data returned.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.CancelJob.sample
     */
    override suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse {
        val op = SdkHttpOperation.build<CancelJobRequest, CancelJobResponse> {
            serializeWith = CancelJobOperationSerializer()
            deserializeWith = CancelJobOperationDeserializer()
            operationName = "CancelJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an address for a Snow device to be shipped to. In most regions, addresses are validated at the time of creation. The address you provide must be located within the serviceable area of your region. If the address is invalid or unsupported, then an exception is thrown. If providing an address as a JSON file through the `cli-input-json` option, include the full file path. For example, `--cli-input-json file://create-address.json`.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.CreateAddress.sample
     */
    override suspend fun createAddress(input: CreateAddressRequest): CreateAddressResponse {
        val op = SdkHttpOperation.build<CreateAddressRequest, CreateAddressResponse> {
            serializeWith = CreateAddressOperationSerializer()
            deserializeWith = CreateAddressOperationDeserializer()
            operationName = "CreateAddress"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an empty cluster. Each cluster supports five nodes. You use the CreateJob action separately to create the jobs for each of these nodes. The cluster does not ship until these five node jobs have been created.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.CreateCluster.sample
     */
    override suspend fun createCluster(input: CreateClusterRequest): CreateClusterResponse {
        val op = SdkHttpOperation.build<CreateClusterRequest, CreateClusterResponse> {
            serializeWith = CreateClusterOperationSerializer()
            deserializeWith = CreateClusterOperationDeserializer()
            operationName = "CreateCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a job to import or export data between Amazon S3 and your on-premises data center. Your Amazon Web Services account must have the right trust policies and permissions in place to create a job for a Snow device. If you're creating a job for a node in a cluster, you only need to provide the `clusterId` value; the other job attributes are inherited from the cluster.
     *
     * Only the Snowball; Edge device type is supported when ordering clustered jobs.
     *
     * The device capacity is optional.
     *
     * Availability of device types differ by Amazon Web Services Region. For more information about Region availability, see [Amazon Web Services Regional Services](https://aws.amazon.com/about-aws/global-infrastructure/regional-product-services/?p=ngi&loc=4).
     *
     * **Snow Family devices and their capacities.**
     * + Device type: **SNC1_SSD**
     *    + Capacity: T14
     *    + Description: Snowcone
     * + Device type: **SNC1_HDD**
     *    + Capacity: T8
     *    + Description: Snowcone
     * + Device type: **EDGE_S**
     *    + Capacity: T98
     *    + Description: Snowball Edge Storage Optimized for data transfer only
     * + Device type: **EDGE_CG**
     *    + Capacity: T42
     *    + Description: Snowball Edge Compute Optimized with GPU
     * + Device type: **EDGE_C**
     *    + Capacity: T42
     *    + Description: Snowball Edge Compute Optimized without GPU
     * + Device type: **EDGE**
     *    + Capacity: T100
     *    + Description: Snowball Edge Storage Optimized with EC2 Compute
     * This device is replaced with T98.
     * + Device type: **STANDARD**
     *    + Capacity: T50
     *    + Description: Original Snowball deviceThis device is only available in the Ningxia, Beijing, and Singapore Amazon Web Services Region
     * + Device type: **STANDARD**
     *    + Capacity: T80
     *    + Description: Original Snowball deviceThis device is only available in the Ningxia, Beijing, and Singapore Amazon Web Services Region.
     * + Snow Family device type: **RACK_5U_C**
     *    + Capacity: T13
     *    + Description: Snowblade.
     * + Device type: **V3_5S**
     *    + Capacity: T240
     *    + Description: Snowball Edge Storage Optimized 210TB
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.CreateJob.sample
     */
    override suspend fun createJob(input: CreateJobRequest): CreateJobResponse {
        val op = SdkHttpOperation.build<CreateJobRequest, CreateJobResponse> {
            serializeWith = CreateJobOperationSerializer()
            deserializeWith = CreateJobOperationDeserializer()
            operationName = "CreateJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a job with the long-term usage option for a device. The long-term usage is a 1-year or 3-year long-term pricing type for the device. You are billed upfront, and Amazon Web Services provides discounts for long-term pricing.
     */
    override suspend fun createLongTermPricing(input: CreateLongTermPricingRequest): CreateLongTermPricingResponse {
        val op = SdkHttpOperation.build<CreateLongTermPricingRequest, CreateLongTermPricingResponse> {
            serializeWith = CreateLongTermPricingOperationSerializer()
            deserializeWith = CreateLongTermPricingOperationDeserializer()
            operationName = "CreateLongTermPricing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a shipping label that will be used to return the Snow device to Amazon Web Services.
     */
    override suspend fun createReturnShippingLabel(input: CreateReturnShippingLabelRequest): CreateReturnShippingLabelResponse {
        val op = SdkHttpOperation.build<CreateReturnShippingLabelRequest, CreateReturnShippingLabelResponse> {
            serializeWith = CreateReturnShippingLabelOperationSerializer()
            deserializeWith = CreateReturnShippingLabelOperationDeserializer()
            operationName = "CreateReturnShippingLabel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Takes an `AddressId` and returns specific details about that address in the form of an `Address` object.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.DescribeAddress.sample
     */
    override suspend fun describeAddress(input: DescribeAddressRequest): DescribeAddressResponse {
        val op = SdkHttpOperation.build<DescribeAddressRequest, DescribeAddressResponse> {
            serializeWith = DescribeAddressOperationSerializer()
            deserializeWith = DescribeAddressOperationDeserializer()
            operationName = "DescribeAddress"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a specified number of `ADDRESS` objects. Calling this API in one of the US regions will return addresses from the list of all addresses associated with this account in all US regions.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.DescribeAddresses.sample
     */
    override suspend fun describeAddresses(input: DescribeAddressesRequest): DescribeAddressesResponse {
        val op = SdkHttpOperation.build<DescribeAddressesRequest, DescribeAddressesResponse> {
            serializeWith = DescribeAddressesOperationSerializer()
            deserializeWith = DescribeAddressesOperationDeserializer()
            operationName = "DescribeAddresses"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specific cluster including shipping information, cluster status, and other important metadata.
     */
    override suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse {
        val op = SdkHttpOperation.build<DescribeClusterRequest, DescribeClusterResponse> {
            serializeWith = DescribeClusterOperationSerializer()
            deserializeWith = DescribeClusterOperationDeserializer()
            operationName = "DescribeCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a specific job including shipping information, job status, and other important metadata.
     */
    override suspend fun describeJob(input: DescribeJobRequest): DescribeJobResponse {
        val op = SdkHttpOperation.build<DescribeJobRequest, DescribeJobResponse> {
            serializeWith = DescribeJobOperationSerializer()
            deserializeWith = DescribeJobOperationDeserializer()
            operationName = "DescribeJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Information on the shipping label of a Snow device that is being returned to Amazon Web Services.
     */
    override suspend fun describeReturnShippingLabel(input: DescribeReturnShippingLabelRequest): DescribeReturnShippingLabelResponse {
        val op = SdkHttpOperation.build<DescribeReturnShippingLabelRequest, DescribeReturnShippingLabelResponse> {
            serializeWith = DescribeReturnShippingLabelOperationSerializer()
            deserializeWith = DescribeReturnShippingLabelOperationDeserializer()
            operationName = "DescribeReturnShippingLabel"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a link to an Amazon S3 presigned URL for the manifest file associated with the specified `JobId` value. You can access the manifest file for up to 60 minutes after this request has been made. To access the manifest file after 60 minutes have passed, you'll have to make another call to the `GetJobManifest` action.
     *
     * The manifest is an encrypted file that you can download after your job enters the `WithCustomer` status. This is the only valid status for calling this API as the manifest and `UnlockCode` code value are used for securing your device and should only be used when you have the device. The manifest is decrypted by using the `UnlockCode` code value, when you pass both values to the Snow device through the Snowball client when the client is started for the first time.
     *
     * As a best practice, we recommend that you don't save a copy of an `UnlockCode` value in the same location as the manifest file for that job. Saving these separately helps prevent unauthorized parties from gaining access to the Snow device associated with that job.
     *
     * The credentials of a given job, including its manifest file and unlock code, expire 360 days after the job is created.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.GetJobManifest.sample
     */
    override suspend fun getJobManifest(input: GetJobManifestRequest): GetJobManifestResponse {
        val op = SdkHttpOperation.build<GetJobManifestRequest, GetJobManifestResponse> {
            serializeWith = GetJobManifestOperationSerializer()
            deserializeWith = GetJobManifestOperationDeserializer()
            operationName = "GetJobManifest"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the `UnlockCode` code value for the specified job. A particular `UnlockCode` value can be accessed for up to 360 days after the associated job has been created.
     *
     * The `UnlockCode` value is a 29-character code with 25 alphanumeric characters and 4 hyphens. This code is used to decrypt the manifest file when it is passed along with the manifest to the Snow device through the Snowball client when the client is started for the first time. The only valid status for calling this API is `WithCustomer` as the manifest and `Unlock` code values are used for securing your device and should only be used when you have the device.
     *
     * As a best practice, we recommend that you don't save a copy of the `UnlockCode` in the same location as the manifest file for that job. Saving these separately helps prevent unauthorized parties from gaining access to the Snow device associated with that job.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.GetJobUnlockCode.sample
     */
    override suspend fun getJobUnlockCode(input: GetJobUnlockCodeRequest): GetJobUnlockCodeResponse {
        val op = SdkHttpOperation.build<GetJobUnlockCodeRequest, GetJobUnlockCodeResponse> {
            serializeWith = GetJobUnlockCodeOperationSerializer()
            deserializeWith = GetJobUnlockCodeOperationDeserializer()
            operationName = "GetJobUnlockCode"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the Snow Family service limit for your account, and also the number of Snow devices your account has in use.
     *
     * The default service limit for the number of Snow devices that you can have at one time is 1. If you want to increase your service limit, contact Amazon Web Services Support.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.GetSnowballUsage.sample
     */
    override suspend fun getSnowballUsage(input: GetSnowballUsageRequest): GetSnowballUsageResponse {
        val op = SdkHttpOperation.build<GetSnowballUsageRequest, GetSnowballUsageResponse> {
            serializeWith = GetSnowballUsageOperationSerializer()
            deserializeWith = GetSnowballUsageOperationDeserializer()
            operationName = "GetSnowballUsage"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an Amazon S3 presigned URL for an update file associated with a specified `JobId`.
     */
    override suspend fun getSoftwareUpdates(input: GetSoftwareUpdatesRequest): GetSoftwareUpdatesResponse {
        val op = SdkHttpOperation.build<GetSoftwareUpdatesRequest, GetSoftwareUpdatesResponse> {
            serializeWith = GetSoftwareUpdatesOperationSerializer()
            deserializeWith = GetSoftwareUpdatesOperationDeserializer()
            operationName = "GetSoftwareUpdates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of `JobListEntry` objects of the specified length. Each `JobListEntry` object is for a job in the specified cluster and contains a job's state, a job's ID, and other information.
     */
    override suspend fun listClusterJobs(input: ListClusterJobsRequest): ListClusterJobsResponse {
        val op = SdkHttpOperation.build<ListClusterJobsRequest, ListClusterJobsResponse> {
            serializeWith = ListClusterJobsOperationSerializer()
            deserializeWith = ListClusterJobsOperationDeserializer()
            operationName = "ListClusterJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of `ClusterListEntry` objects of the specified length. Each `ClusterListEntry` object contains a cluster's state, a cluster's ID, and other important status information.
     */
    override suspend fun listClusters(input: ListClustersRequest): ListClustersResponse {
        val op = SdkHttpOperation.build<ListClustersRequest, ListClustersResponse> {
            serializeWith = ListClustersOperationSerializer()
            deserializeWith = ListClustersOperationDeserializer()
            operationName = "ListClusters"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This action returns a list of the different Amazon EC2-compatible Amazon Machine Images (AMIs) that are owned by your Amazon Web Services accountthat would be supported for use on a Snow device. Currently, supported AMIs are based on the Amazon Linux-2, Ubuntu 20.04 LTS - Focal, or Ubuntu 22.04 LTS - Jammy images, available on the Amazon Web Services Marketplace. Ubuntu 16.04 LTS - Xenial (HVM) images are no longer supported in the Market, but still supported for use on devices through Amazon EC2 VM Import/Export and running locally in AMIs.
     */
    override suspend fun listCompatibleImages(input: ListCompatibleImagesRequest): ListCompatibleImagesResponse {
        val op = SdkHttpOperation.build<ListCompatibleImagesRequest, ListCompatibleImagesResponse> {
            serializeWith = ListCompatibleImagesOperationSerializer()
            deserializeWith = ListCompatibleImagesOperationDeserializer()
            operationName = "ListCompatibleImages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of `JobListEntry` objects of the specified length. Each `JobListEntry` object contains a job's state, a job's ID, and a value that indicates whether the job is a job part, in the case of export jobs. Calling this API action in one of the US regions will return jobs from the list of all jobs associated with this account in all US regions.
     */
    override suspend fun listJobs(input: ListJobsRequest): ListJobsResponse {
        val op = SdkHttpOperation.build<ListJobsRequest, ListJobsResponse> {
            serializeWith = ListJobsOperationSerializer()
            deserializeWith = ListJobsOperationDeserializer()
            operationName = "ListJobs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all long-term pricing types.
     */
    override suspend fun listLongTermPricing(input: ListLongTermPricingRequest): ListLongTermPricingResponse {
        val op = SdkHttpOperation.build<ListLongTermPricingRequest, ListLongTermPricingResponse> {
            serializeWith = ListLongTermPricingOperationSerializer()
            deserializeWith = ListLongTermPricingOperationDeserializer()
            operationName = "ListLongTermPricing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * A list of locations from which the customer can choose to pickup a device.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.ListPickupLocations.sample
     */
    override suspend fun listPickupLocations(input: ListPickupLocationsRequest): ListPickupLocationsResponse {
        val op = SdkHttpOperation.build<ListPickupLocationsRequest, ListPickupLocationsResponse> {
            serializeWith = ListPickupLocationsOperationSerializer()
            deserializeWith = ListPickupLocationsOperationDeserializer()
            operationName = "ListPickupLocations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all supported versions for Snow on-device services. Returns an array of `ServiceVersion` object containing the supported versions for a particular service.
     */
    override suspend fun listServiceVersions(input: ListServiceVersionsRequest): ListServiceVersionsResponse {
        val op = SdkHttpOperation.build<ListServiceVersionsRequest, ListServiceVersionsResponse> {
            serializeWith = ListServiceVersionsOperationSerializer()
            deserializeWith = ListServiceVersionsOperationDeserializer()
            operationName = "ListServiceVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * While a cluster's `ClusterState` value is in the `AwaitingQuorum` state, you can update some of the information associated with a cluster. Once the cluster changes to a different job state, usually 60 minutes after the cluster being created, this action is no longer available.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.UpdateCluster.sample
     */
    override suspend fun updateCluster(input: UpdateClusterRequest): UpdateClusterResponse {
        val op = SdkHttpOperation.build<UpdateClusterRequest, UpdateClusterResponse> {
            serializeWith = UpdateClusterOperationSerializer()
            deserializeWith = UpdateClusterOperationDeserializer()
            operationName = "UpdateCluster"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * While a job's `JobState` value is `New`, you can update some of the information associated with a job. Once the job changes to a different job state, usually within 60 minutes of the job being created, this action is no longer available.
     *
     * @sample aws.sdk.kotlin.services.snowball.samples.UpdateJob.sample
     */
    override suspend fun updateJob(input: UpdateJobRequest): UpdateJobResponse {
        val op = SdkHttpOperation.build<UpdateJobRequest, UpdateJobResponse> {
            serializeWith = UpdateJobOperationSerializer()
            deserializeWith = UpdateJobOperationDeserializer()
            operationName = "UpdateJob"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the state when a shipment state changes to a different state.
     */
    override suspend fun updateJobShipmentState(input: UpdateJobShipmentStateRequest): UpdateJobShipmentStateResponse {
        val op = SdkHttpOperation.build<UpdateJobShipmentStateRequest, UpdateJobShipmentStateResponse> {
            serializeWith = UpdateJobShipmentStateOperationSerializer()
            deserializeWith = UpdateJobShipmentStateOperationDeserializer()
            operationName = "UpdateJobShipmentState"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the long-term pricing type.
     */
    override suspend fun updateLongTermPricing(input: UpdateLongTermPricingRequest): UpdateLongTermPricingResponse {
        val op = SdkHttpOperation.build<UpdateLongTermPricingRequest, UpdateLongTermPricingResponse> {
            serializeWith = UpdateLongTermPricingOperationSerializer()
            deserializeWith = UpdateLongTermPricingOperationDeserializer()
            operationName = "UpdateLongTermPricing"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWSIESnowballJobManagementService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "snowball")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
