// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.snowball.serde

import aws.sdk.kotlin.services.snowball.model.DependentService
import aws.sdk.kotlin.services.snowball.model.ListServiceVersionsResponse
import aws.sdk.kotlin.services.snowball.model.ServiceName
import aws.sdk.kotlin.services.snowball.model.ServiceVersion
import aws.sdk.kotlin.services.snowball.model.SnowballException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListServiceVersionsOperationDeserializer: HttpDeserialize<ListServiceVersionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListServiceVersionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListServiceVersionsError(context, call)
        }
        val builder = ListServiceVersionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListServiceVersionsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListServiceVersionsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SnowballException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidResourceException" -> InvalidResourceExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SnowballException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListServiceVersionsOperationBody(builder: ListServiceVersionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEPENDENTSERVICES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DependentServices"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SERVICENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ServiceName"))
    val SERVICEVERSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ServiceVersions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEPENDENTSERVICES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SERVICENAME_DESCRIPTOR)
        field(SERVICEVERSIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEPENDENTSERVICES_DESCRIPTOR.index -> builder.dependentServices =
                    deserializer.deserializeList(DEPENDENTSERVICES_DESCRIPTOR) {
                        val col0 = mutableListOf<DependentService>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDependentServiceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SERVICENAME_DESCRIPTOR.index -> builder.serviceName = deserializeString().let { ServiceName.fromValue(it) }
                SERVICEVERSIONS_DESCRIPTOR.index -> builder.serviceVersions =
                    deserializer.deserializeList(SERVICEVERSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ServiceVersion>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeServiceVersionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
